/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.traceAnalysis.filter.visualization.util.dot;

public final class DotFactory {
    public static final String DOT_SHAPE_BOX = "box";
    public static final String DOT_SHAPE_BOX3D = "box3d";
    public static final String DOT_SHAPE_NONE = "none";
    public static final String DOT_SHAPE_OVAL = "oval";
    public static final String DOT_STYLE_SOLID = "solid";
    public static final String DOT_STYLE_DASHED = "dashed";
    public static final String DOT_ARROWHEAD_OPEN = "open";
    public static final double DOT_DEFAULT_FONTSIZE = 0.0;
    public static final String DOT_DOT_RANKDIR_LR = "LR";
    public static final String DOT_FILLCOLOR_WHITE = "white";
    public static final String DOT_FILLCOLOR_GRAY = "gray";
    public static final String DOT_STYLE_FILLED = "filled";

    private DotFactory() {
    }

    public static StringBuilder createHeader(String name, String label, String fontcolor, String fontname, double fontsize) {
        StringBuilder dot = new StringBuilder(256);
        dot.append("digraph ");
        dot.append(name);
        dot.append(" {\n label=<");
        dot.append(label);
        dot.append(">;\n fontcolor=\"");
        dot.append(fontcolor);
        dot.append("\";\n fontname=\"");
        dot.append(fontname);
        dot.append("\";\n fontsize=\"");
        dot.append(Double.toString(fontsize));
        dot.append("\";\n");
        return dot;
    }

    public static StringBuilder createNodeDefaults(String style, String shape, String framecolor, String fontcolor, String fontname, double fontsize, String imagescale) {
        StringBuilder dot = new StringBuilder(256);
        dot.append(" node [style=\"");
        dot.append(style);
        dot.append("\",shape=\"");
        dot.append(shape);
        dot.append("\",color=\"");
        dot.append(framecolor);
        dot.append("\",fontcolor=\"");
        dot.append(fontcolor);
        dot.append("\",fontname=\"");
        dot.append(fontname);
        dot.append("\",fontsize=\"");
        dot.append(fontsize);
        dot.append("\",imagescale=\"");
        dot.append(imagescale);
        dot.append("\"];\n");
        return dot;
    }

    public static StringBuilder createEdgeDefaults(String style, String arrowhead, String labelfontname) {
        StringBuilder dot = new StringBuilder(128);
        dot.append(" edge [style=\"");
        dot.append(style);
        dot.append("\",arrowhead=\"");
        dot.append(arrowhead);
        dot.append("\",labelfontname=\"");
        dot.append(labelfontname);
        dot.append("\"];\n");
        return dot;
    }

    public static StringBuilder createNode(String prefix, String nodeId, String label, String shape, String style, String framecolor, String fillcolor, String fontcolor, double fontsize, String imageFilename, String misc, String tooltip) {
        StringBuilder dot = new StringBuilder(128);
        boolean addComma = false;
        if (prefix != null) {
            dot.append(prefix);
        }
        dot.append('\"');
        dot.append(nodeId);
        dot.append("\" [");
        if (label != null) {
            dot.append("label=\"");
            dot.append(label);
            dot.append('\"');
            addComma = true;
        }
        if (shape != null) {
            if (addComma) {
                dot.append(',');
            }
            dot.append("shape=\"");
            dot.append(shape);
            dot.append('\"');
            addComma = true;
        }
        if (style != null) {
            if (addComma) {
                dot.append(',');
            }
            dot.append("style=\"");
            dot.append(style);
            dot.append('\"');
            addComma = true;
        }
        if (framecolor != null) {
            if (addComma) {
                dot.append(',');
            }
            dot.append("color=\"");
            dot.append(framecolor);
            dot.append('\"');
            addComma = true;
        }
        if (fillcolor != null) {
            if (addComma) {
                dot.append(',');
            }
            dot.append("fillcolor=\"");
            dot.append(fillcolor);
            dot.append('\"');
            addComma = true;
        }
        if (fontcolor != null) {
            if (addComma) {
                dot.append(',');
            }
            dot.append("fontcolor=\"");
            dot.append(fontcolor);
            dot.append('\"');
            addComma = true;
        }
        if (fontsize != 0.0) {
            if (addComma) {
                dot.append(',');
            }
            dot.append("fontsize=\"");
            dot.append(fontsize);
            dot.append('\"');
            addComma = true;
        }
        if (imageFilename != null) {
            if (addComma) {
                dot.append(',');
            }
            dot.append("image=\"");
            dot.append(imageFilename);
            dot.append('\"');
            addComma = true;
        }
        if (tooltip != null) {
            if (addComma) {
                dot.append(',');
            }
            dot.append("tooltip=\"");
            dot.append(tooltip);
            dot.append('\"');
            addComma = true;
        }
        if (misc != null) {
            if (addComma) {
                dot.append(',');
            }
            dot.append(misc);
        }
        dot.append("]\n");
        return dot;
    }

    public static StringBuilder createCluster(String prefix, String name, String label, String shape, String style, String framecolor, String fillcolor, String fontcolor, double fontsize, String misc) {
        StringBuilder dot = new StringBuilder(256);
        dot.append(prefix);
        dot.append("subgraph \"cluster_");
        dot.append(name);
        dot.append("\" {\n");
        dot.append(prefix);
        dot.append(" label = \"");
        dot.append(label);
        if (shape != null) {
            dot.append("\";\n");
            dot.append(prefix);
            dot.append(" shape = \"");
            dot.append(shape);
        }
        if (style != null) {
            dot.append("\";\n");
            dot.append(prefix);
            dot.append(" style = \"");
            dot.append(style);
        }
        if (framecolor != null) {
            dot.append("\";\n");
            dot.append(prefix);
            dot.append(" pencolor = \"");
            dot.append(framecolor);
        }
        if (fillcolor != null) {
            dot.append("\";\n");
            dot.append(prefix);
            dot.append(" fillcolor = \"");
            dot.append(fillcolor);
        }
        if (fontcolor != null) {
            dot.append("\";\n");
            dot.append(prefix);
            dot.append(" fontcolor = \"");
            dot.append(fontcolor);
        }
        if (fontsize != 0.0) {
            dot.append("\";\n");
            dot.append(prefix);
            dot.append(" fontsize = \"");
            dot.append(fontsize);
        }
        dot.append("\";");
        if (misc != null) {
            dot.append(misc);
        }
        dot.append('\n');
        return dot;
    }

    public static String createConnection(String prefix, String from, String to, String style, String arrowhead, String color) {
        StringBuilder dot = new StringBuilder(128);
        dot.append(prefix);
        dot.append(from);
        dot.append("->");
        dot.append(to);
        boolean firstFlag = true;
        if (style != null) {
            dot.append("style=\"");
            dot.append(style);
            dot.append('\"');
            firstFlag = false;
        }
        if (arrowhead != null) {
            if (!firstFlag) {
                dot.append(',');
            }
            dot.append(" arrowhead=\"");
            dot.append(arrowhead);
            dot.append('\"');
            firstFlag = false;
        }
        if (color != null) {
            if (!firstFlag) {
                dot.append(',');
            }
            dot.append(" color=\"");
            dot.append(color);
            dot.append('\"');
            firstFlag = false;
        }
        dot.append(']');
        return dot.toString();
    }

    public static String createConnection(String prefix, String from, String to, String label, String style, String arrowhead, String color) {
        StringBuilder dot = new StringBuilder(128);
        dot.append(prefix);
        dot.append(from);
        dot.append("->");
        dot.append(to);
        dot.append("[label=");
        dot.append(label);
        if (style != null) {
            dot.append(", style=\"");
            dot.append(style);
            dot.append('\"');
        }
        if (arrowhead != null) {
            dot.append(", arrowhead=\"");
            dot.append(arrowhead);
            dot.append('\"');
        }
        if (color != null) {
            dot.append(", color=\"");
            dot.append(color);
            dot.append('\"');
        }
        dot.append(']');
        return dot.toString();
    }

    public static String createConnection(String prefix, String from, String to, double taillabel, double headlabel) {
        StringBuilder dot = new StringBuilder(128);
        dot.append(prefix);
        dot.append('\"');
        dot.append(from);
        dot.append("\" -> \"");
        dot.append(to);
        dot.append("\" [label=\" \",taillabel=\"");
        dot.append(taillabel * 100.0);
        dot.append("(\",headlabel=\"");
        dot.append(headlabel * 100.0);
        dot.append("\"];\n");
        return dot.toString();
    }
}

