/*
 * Decompiled with CFR 0.152.
 */
package de.upb.eim.kiekerToPba;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.concurrent.atomic.AtomicInteger;
import kieker.analysis.plugin.annotation.InputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.Property;
import kieker.analysis.plugin.filter.AbstractFilterPlugin;
import kieker.common.configuration.Configuration;
import kieker.common.record.flow.trace.operation.AbstractOperationEvent;
import kieker.common.record.flow.trace.operation.AfterOperationEvent;
import kieker.common.record.flow.trace.operation.AfterOperationFailedEvent;
import kieker.common.record.flow.trace.operation.BeforeOperationEvent;

@Plugin(name="Stack trace builder and printer", description="builds stack traces from before and after operation measurement types and prints them to file", configuration={@Property(name="CONFIG_OUTPUT_PATH", defaultValue="."), @Property(name="CONFIG_OUTPUT_FILE", defaultValue="stack-traced.out.txt"), @Property(name="CONFIG_OUTPUT_MAPPING", defaultValue="stack-traced.map.txt")})
public class StackTraceBuilderAndPrinter
extends AbstractFilterPlugin {
    public static final boolean DO_DEBUG = true;
    public static final String INPUT_PORT_NAME_EVENTS = "newEvent";
    public static final String CONFIG_OUTPUT_PATH = "CONFIG_OUTPUT_PATH";
    public static final String CONFIG_OUTPUT_FILE = "CONFIG_OUTPUT_FILE";
    public static final String CONFIG_OUTPUT_MAPPING = "CONFIG_OUTPUT_MAPPING";
    private Configuration conf = null;
    private BufferedWriter dataFileOut = null;
    private HashMap<Long, ArrayList<BeforeOperationEvent>> bunchOfStacks = new HashMap();
    private HashMap<String, String> mappings = new HashMap();
    private AtomicInteger mappingCount = new AtomicInteger(0);
    private Path mapFile = null;

    public StackTraceBuilderAndPrinter(Configuration configuration) {
        super(configuration);
        System.err.println("[STBAP] initializing ...");
        this.conf = configuration;
        String base = this.conf.getPathProperty(CONFIG_OUTPUT_PATH);
        Path dataFile = Paths.get(String.valueOf(base) + "/" + this.conf.getPathProperty(CONFIG_OUTPUT_FILE), new String[0]);
        this.mapFile = Paths.get(String.valueOf(base) + "/" + this.conf.getPathProperty(CONFIG_OUTPUT_MAPPING), new String[0]);
        try {
            Files.deleteIfExists(dataFile);
            this.dataFileOut = Files.newBufferedWriter(dataFile, Charset.forName("UTF-8"), StandardOpenOption.CREATE);
            this.dataFileOut.write("key;thread;time;duration;stacktrace\n");
            this.dataFileOut.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.err.println("[STBAP] ... initializing [DONE]");
    }

    @InputPort(name="newEvent", eventTypes={BeforeOperationEvent.class, AfterOperationFailedEvent.class, AfterOperationEvent.class})
    public void newEvent(Object event) {
        if (event instanceof BeforeOperationEvent) {
            BeforeOperationEvent myRecord = (BeforeOperationEvent)event;
            if (!this.bunchOfStacks.containsKey(myRecord.getTraceId())) {
                this.bunchOfStacks.put(myRecord.getTraceId(), new ArrayList());
            }
            this.bunchOfStacks.get(myRecord.getTraceId()).add(myRecord);
        } else if (event instanceof AfterOperationEvent) {
            AfterOperationEvent myRecord = (AfterOperationEvent)event;
            String curStackTrace = this.buildStackTrace(myRecord.getTraceId());
            if (this.checkAfterOp(myRecord)) {
                String curKey = this.updateMappings(curStackTrace);
                BeforeOperationEvent lastOp = this.popStack(myRecord);
                long duration = myRecord.getTimestamp() - lastOp.getTimestamp();
                this.writeMeasurementLine(myRecord, curKey, myRecord.getTimestamp(), duration, curStackTrace);
            } else {
                System.err.println("WARN: did not find class / operation(" + myRecord.getClassSignature() + ";" + myRecord.getOperationSignature() + ")");
            }
        }
    }

    private void writeMeasurementLine(AfterOperationEvent myRecord, String curKey, long start, long duration, String curStackTrace) {
        try {
            this.dataFileOut.write(curKey);
            this.dataFileOut.write(";");
            this.dataFileOut.write(String.valueOf(myRecord.getTraceId()));
            this.dataFileOut.write(";");
            this.dataFileOut.write(String.valueOf(start));
            this.dataFileOut.write(";");
            this.dataFileOut.write(String.valueOf(duration));
            this.dataFileOut.write(";");
            this.dataFileOut.write(curKey);
            this.dataFileOut.write("\n");
            this.dataFileOut.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private BeforeOperationEvent popStack(AfterOperationEvent myRecord) {
        ArrayList<BeforeOperationEvent> curStack = this.bunchOfStacks.get(myRecord.getTraceId());
        return curStack.remove(curStack.size() - 1);
    }

    private boolean checkAfterOp(AfterOperationEvent myRecord) {
        ArrayList<BeforeOperationEvent> curStack = this.bunchOfStacks.get(myRecord.getTraceId());
        String stackOpSig = curStack.get(curStack.size() - 1).getOperationSignature();
        String stackClSig = curStack.get(curStack.size() - 1).getClassSignature();
        return stackOpSig.equals(myRecord.getOperationSignature()) && stackClSig.equals(myRecord.getClassSignature());
    }

    private String getConcreteOperationSignature(AbstractOperationEvent event) {
        String clSig = event.getClassSignature();
        String opSig = event.getOperationSignature();
        int opSigParamStart = opSig.indexOf("(");
        opSig = String.valueOf(clSig) + opSig.substring(opSig.lastIndexOf(".", opSigParamStart), opSig.indexOf(")") + 1);
        return opSig;
    }

    private String buildStackTrace(long traceId) {
        ArrayList<BeforeOperationEvent> curStack = this.bunchOfStacks.get(traceId);
        StringBuilder stackTrace = new StringBuilder();
        ListIterator<BeforeOperationEvent> iterator = curStack.listIterator(curStack.size());
        while (iterator.hasPrevious()) {
            BeforeOperationEvent curOp = iterator.previous();
            if (stackTrace.length() > 0) {
                stackTrace.append(",");
            }
            stackTrace.append(this.getConcreteOperationSignature(curOp));
        }
        return stackTrace.toString();
    }

    private String updateMappings(String curStackTrace) {
        String result = this.mappings.get(curStackTrace);
        if (result == null) {
            String shortName;
            int paran = curStackTrace.indexOf("(");
            int dot = curStackTrace.lastIndexOf(".", paran);
            result = shortName = String.valueOf(this.mappingCount.getAndIncrement()) + ") " + curStackTrace.substring(curStackTrace.lastIndexOf(".", dot - 1) + 1, paran);
            this.mappings.put(curStackTrace, shortName);
            try {
                Files.deleteIfExists(this.mapFile);
                BufferedWriter mapFileOut = Files.newBufferedWriter(this.mapFile, Charset.forName("UTF-8"), StandardOpenOption.CREATE);
                mapFileOut.write("key;stacktrace;palladio mapping\n");
                for (String stackTrace : this.mappings.keySet()) {
                    mapFileOut.write(this.mappings.get(stackTrace));
                    mapFileOut.write(";");
                    mapFileOut.write(stackTrace);
                    mapFileOut.write(";\n");
                }
                mapFileOut.write("\n");
                mapFileOut.flush();
                mapFileOut.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    @Override
    public Configuration getCurrentConfiguration() {
        return this.conf;
    }

    @Override
    public void terminate(boolean error) {
        block13: {
            super.terminate(error);
            System.err.println("[STBAP] terminating ...");
            if (this.dataFileOut != null) {
                try {
                    try {
                        this.dataFileOut.flush();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        try {
                            this.dataFileOut.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        this.dataFileOut.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    throw throwable;
                }
                try {
                    this.dataFileOut.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                System.err.println("[STBAP] ... WARN: data file uninitialized.");
            }
        }
        System.err.println("[STBAP] ... terminating [DONE].");
    }
}

