/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kieker.analysis.AnalysisController;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;

public final class AnalysisControllerThread
extends Thread {
    private static final Log LOG = LogFactory.getLog(AnalysisControllerThread.class);
    private final AnalysisController analysisController;
    private final CountDownLatch terminationLatch = new CountDownLatch(1);

    public AnalysisControllerThread(AnalysisController analysisController) {
        this.analysisController = analysisController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        AnalysisControllerThread analysisControllerThread = this;
        synchronized (analysisControllerThread) {
            super.start();
            this.analysisController.awaitInitialization();
        }
    }

    public void run() {
        try {
            this.analysisController.run();
            this.terminationLatch.countDown();
        }
        catch (Exception ex) {
            LOG.error("Error running AnalysisCOntroller.", ex);
        }
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.terminationLatch.await(timeout, unit);
    }

    public void awaitTermination() throws InterruptedException {
        this.terminationLatch.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        AnalysisControllerThread analysisControllerThread = this;
        synchronized (analysisControllerThread) {
            this.analysisController.terminate();
        }
    }
}

