/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.plugin;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import kieker.analysis.exception.AnalysisConfigurationException;
import kieker.analysis.repository.AbstractRepository;
import kieker.common.configuration.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface IPlugin {
    public boolean init();

    public void terminate(boolean var1);

    public Configuration getCurrentConfiguration();

    public String getPluginName();

    public String getPluginDescription();

    public String getName();

    public void connect(String var1, AbstractRepository var2) throws AnalysisConfigurationException;

    public Map<String, AbstractRepository> getCurrentRepositories();

    public String[] getAllOutputPortNames();

    public String[] getAllInputPortNames();

    public String[] getAllDisplayNames();

    public List<PluginInputPortReference> getConnectedPlugins(String var1);

    public STATE getState();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum STATE {
        READY,
        RUNNING,
        TERMINATING,
        TERMINATED,
        FAILING,
        FAILED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class PluginInputPortReference {
        private final IPlugin plugin;
        private final String inputPortName;
        private final Method inputPortMethod;
        private final Class<?>[] eventTypes;

        public PluginInputPortReference(IPlugin plugin, String inputPortName, Method inputPortMethod, Class<?>[] eventTypes) {
            this.plugin = plugin;
            this.inputPortName = inputPortName;
            this.inputPortMethod = inputPortMethod;
            this.eventTypes = (Class[])eventTypes.clone();
        }

        public final IPlugin getPlugin() {
            return this.plugin;
        }

        public final Method getInputPortMethod() {
            return this.inputPortMethod;
        }

        public final Class<?>[] getEventTypes() {
            return (Class[])this.eventTypes.clone();
        }

        public final String getInputPortName() {
            return this.inputPortName;
        }
    }
}

