/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.plugin.filter.forward;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import kieker.analysis.plugin.annotation.InputPort;
import kieker.analysis.plugin.annotation.OutputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.Property;
import kieker.analysis.plugin.filter.AbstractFilterPlugin;
import kieker.common.configuration.Configuration;
import kieker.common.record.IMonitoringRecord;
import kieker.common.util.ImmutableEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Plugin(description="A filter computing the throughput in terms of the number of events received per time unit", outputPorts={@OutputPort(name="relayedEvents", eventTypes={Object.class}, description="Provides each incoming object")}, configuration={@Property(name="intervalSizeNanos", defaultValue="60000000000"), @Property(name="intervalsBasedOn1stTstamp", defaultValue="true")})
public final class CountingThroughputFilter
extends AbstractFilterPlugin {
    public static final String INPUT_PORT_NAME_RECORDS = "inputRecords";
    public static final String INPUT_PORT_NAME_OBJECTS = "inputObjects";
    public static final String OUTPUT_PORT_NAME_RELAYED_OBJECTS = "relayedEvents";
    public static final String CONFIG_PROPERTY_NAME_INTERVAL_SIZE_NANOS = "intervalSizeNanos";
    public static final String CONFIG_PROPERTY_NAME_INTERVALS_BASED_ON_1ST_TSTAMP = "intervalsBasedOn1stTstamp";
    public static final String CONFIG_PROPERTY_VALUE_INTERVAL_SIZE_ONE_MINUTE = "60000000000";
    private volatile long firstIntervalStart = -1L;
    private final boolean intervalsBasedOn1stTstamp;
    private final Queue<Map.Entry<Long, Long>> eventCountsPerInterval = new ConcurrentLinkedQueue<Map.Entry<Long, Long>>();
    private final long intervalSizeNanos;
    private final AtomicLong currentCountForCurrentInterval = new AtomicLong(0L);
    private volatile long firstTimestampInCurrentInterval = -1L;
    private volatile long lastTimestampInCurrentInterval = -1L;

    public CountingThroughputFilter(Configuration configuration) {
        super(configuration);
        this.intervalSizeNanos = configuration.getLongProperty(CONFIG_PROPERTY_NAME_INTERVAL_SIZE_NANOS);
        this.intervalsBasedOn1stTstamp = configuration.getBooleanProperty(CONFIG_PROPERTY_NAME_INTERVALS_BASED_ON_1ST_TSTAMP);
    }

    @Override
    public final Configuration getCurrentConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setProperty(CONFIG_PROPERTY_NAME_INTERVAL_SIZE_NANOS, Long.toString(this.intervalSizeNanos));
        configuration.setProperty(CONFIG_PROPERTY_NAME_INTERVALS_BASED_ON_1ST_TSTAMP, Boolean.toString(this.intervalsBasedOn1stTstamp));
        return configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEvent(Object event, long currentTimeNanos) {
        long startOfTimestampsInterval = this.computeFirstTimestampInInterval(currentTimeNanos);
        long endOfTimestampsInterval = this.computeLastTimestampInInterval(currentTimeNanos);
        CountingThroughputFilter countingThroughputFilter = this;
        synchronized (countingThroughputFilter) {
            if (endOfTimestampsInterval > this.lastTimestampInCurrentInterval) {
                if (this.firstTimestampInCurrentInterval >= 0L) {
                    this.eventCountsPerInterval.add(new ImmutableEntry<Long, Long>(this.lastTimestampInCurrentInterval + 1L, this.currentCountForCurrentInterval.get()));
                }
                this.firstTimestampInCurrentInterval = startOfTimestampsInterval;
                this.lastTimestampInCurrentInterval = endOfTimestampsInterval;
                this.currentCountForCurrentInterval.set(0L);
            }
            this.currentCountForCurrentInterval.incrementAndGet();
        }
        super.deliver(OUTPUT_PORT_NAME_RELAYED_OBJECTS, event);
    }

    @InputPort(name="inputRecords", eventTypes={IMonitoringRecord.class}, description="Receives incoming monitoring records to be considered for the throughput computation and uses the record's logging timestamp")
    public final void inputRecord(IMonitoringRecord record) {
        this.processEvent(record, record.getLoggingTimestamp());
    }

    @InputPort(name="inputObjects", eventTypes={Object.class}, description="Receives incoming objects to be considered for the throughput computation and uses the current system time")
    public final void inputObjects(Object object) {
        this.processEvent(object, this.currentTimeNanos());
    }

    private long currentTimeNanos() {
        return TimeUnit.NANOSECONDS.convert(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    public Collection<Map.Entry<Long, Long>> getCountsPerInterval() {
        return Collections.unmodifiableCollection(this.eventCountsPerInterval);
    }

    private long computeFirstTimestampInInterval(long timestamp) {
        if (this.firstIntervalStart == -1L) {
            this.firstIntervalStart = timestamp;
        }
        long referenceTimePoint = this.intervalsBasedOn1stTstamp ? this.firstIntervalStart : 0L;
        return referenceTimePoint + (timestamp - referenceTimePoint) / this.intervalSizeNanos * this.intervalSizeNanos;
    }

    private long computeLastTimestampInInterval(long timestamp) {
        long referenceTimePoint = this.intervalsBasedOn1stTstamp ? this.firstIntervalStart : 0L;
        return referenceTimePoint + (((timestamp - referenceTimePoint) / this.intervalSizeNanos + 1L) * this.intervalSizeNanos - 1L);
    }

    public long getIntervalSizeNanos() {
        return this.intervalSizeNanos;
    }

    public long getFirstTimestampInCurrentInterval() {
        return this.firstTimestampInCurrentInterval;
    }

    public long getLastTimestampInCurrentInterval() {
        return this.lastTimestampInCurrentInterval;
    }

    public long getCurrentCountForCurrentInterval() {
        return this.currentCountForCurrentInterval.get();
    }
}

