/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.plugin.filter.select;

import java.util.LinkedList;
import kieker.analysis.plugin.annotation.InputPort;
import kieker.analysis.plugin.annotation.OutputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.Property;
import kieker.analysis.plugin.filter.AbstractFilterPlugin;
import kieker.common.configuration.Configuration;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;

@Plugin(description="Filters incoming objects based on their type", outputPorts={@OutputPort(name="eventsMatchingType", eventTypes={Object.class}, description="Forwards events matching the configured types"), @OutputPort(name="eventsNotMatchingType", eventTypes={}, description="Forwards events not matching the configured types")}, configuration={@Property(name="types", defaultValue="java.lang.Object")})
public final class TypeFilter
extends AbstractFilterPlugin {
    public static final String INPUT_PORT_NAME_EVENTS = "events";
    public static final String OUTPUT_PORT_NAME_TYPE_MATCH = "eventsMatchingType";
    public static final String OUTPUT_PORT_NAME_TYPE_MISMATCH = "eventsNotMatchingType";
    public static final String CONFIG_PROPERTY_NAME_TYPES = "types";
    private static final Log LOG = LogFactory.getLog(TypeFilter.class);
    private final Class<?>[] acceptedClasses;

    public TypeFilter(Configuration configuration) {
        super(configuration);
        String[] classes = configuration.getStringArrayProperty(CONFIG_PROPERTY_NAME_TYPES);
        LinkedList listOfClasses = new LinkedList();
        for (String clazz : classes) {
            try {
                listOfClasses.add(Class.forName(clazz));
            }
            catch (ClassNotFoundException ex) {
                LOG.warn("Failed to add class " + clazz + " to the filter.", ex);
            }
        }
        this.acceptedClasses = listOfClasses.toArray(new Class[listOfClasses.size()]);
    }

    public final Configuration getCurrentConfiguration() {
        Configuration configuration = new Configuration();
        Object[] acceptedClassesConfig = new String[this.acceptedClasses.length];
        for (int i = 0; i < acceptedClassesConfig.length; ++i) {
            acceptedClassesConfig[i] = this.acceptedClasses[i].getName();
        }
        configuration.setProperty(CONFIG_PROPERTY_NAME_TYPES, Configuration.toProperty(acceptedClassesConfig));
        return configuration;
    }

    @InputPort(name="events", eventTypes={Object.class}, description="all objects with matching types are forwarded")
    public final void inputEvents(Object event) {
        Class<?> eventClass = event.getClass();
        for (Class<?> clazz : this.acceptedClasses) {
            if (!clazz.isAssignableFrom(eventClass)) continue;
            super.deliver(OUTPUT_PORT_NAME_TYPE_MATCH, event);
            break;
        }
        super.deliver(OUTPUT_PORT_NAME_TYPE_MISMATCH, event);
    }
}

