/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.plugin.reader.namedRecordPipe;

import java.util.concurrent.CountDownLatch;
import kieker.analysis.plugin.annotation.OutputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.Property;
import kieker.analysis.plugin.reader.AbstractReaderPlugin;
import kieker.common.configuration.Configuration;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.common.namedRecordPipe.Broker;
import kieker.common.namedRecordPipe.IPipeReader;
import kieker.common.namedRecordPipe.Pipe;
import kieker.common.record.IMonitoringRecord;

@Plugin(description="A reader which reads records via an in-memory pipe", outputPorts={@OutputPort(name="monitoringRecords", eventTypes={IMonitoringRecord.class}, description="Output Port of the PipeReader")}, configuration={@Property(name="pipeName", defaultValue="kieker-pipe", description="The name of the pipe used to read data.")})
public final class PipeReader
extends AbstractReaderPlugin
implements IPipeReader {
    public static final String OUTPUT_PORT_NAME_RECORDS = "monitoringRecords";
    public static final String CONFIG_PROPERTY_NAME_PIPENAME = "pipeName";
    public static final String CONFIG_PROPERTY_VALUE_PIPENAME_DEFAULT = "kieker-pipe";
    private static final Log LOG = LogFactory.getLog(PipeReader.class);
    private volatile Pipe pipe;
    private final String pipeName;
    private final CountDownLatch terminationLatch = new CountDownLatch(1);

    public PipeReader(Configuration configuration) throws IllegalArgumentException {
        super(configuration);
        String pipeNameConfig;
        this.pipeName = pipeNameConfig = this.configuration.getStringProperty(CONFIG_PROPERTY_NAME_PIPENAME);
        this.pipe = Broker.INSTANCE.acquirePipe(pipeNameConfig);
        if (this.pipe == null) {
            throw new IllegalArgumentException("Failed to get Pipe with name " + pipeNameConfig);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Connected to named pipe '" + this.pipe.getName() + "'");
        }
        this.pipe.setPipeReader(this);
    }

    public boolean read() {
        try {
            this.terminationLatch.await();
            LOG.info("Pipe closed. Will terminate.");
        }
        catch (InterruptedException ex) {
            LOG.error("Received InterruptedException", ex);
            return false;
        }
        return true;
    }

    public boolean newMonitoringRecord(IMonitoringRecord rec) {
        return super.deliver(OUTPUT_PORT_NAME_RECORDS, rec);
    }

    public void notifyPipeClosed() {
        this.terminationLatch.countDown();
    }

    public void terminate(boolean error) {
        if (this.pipe != null) {
            this.pipe.close();
        }
    }

    public Configuration getCurrentConfiguration() {
        Configuration configuration = new Configuration(null);
        configuration.setProperty(CONFIG_PROPERTY_NAME_PIPENAME, this.pipeName);
        return configuration;
    }
}

