/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kieker.common.exception.MonitoringRecordException;
import kieker.common.record.IMonitoringRecord;
import kieker.common.record.controlflow.BranchingRecord;
import kieker.common.record.controlflow.OperationExecutionRecord;
import kieker.common.record.system.CPUUtilizationRecord;
import kieker.common.record.system.MemSwapUsageRecord;
import kieker.common.record.system.ResourceUtilizationRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMonitoringRecord
implements IMonitoringRecord {
    private static final long serialVersionUID = 1L;
    private static final ConcurrentMap<String, Class<? extends IMonitoringRecord>> OLD_KIEKERRECORDS = new ConcurrentHashMap<String, Class<? extends IMonitoringRecord>>();
    private volatile long loggingTimestamp = -1L;

    @Override
    public final long getLoggingTimestamp() {
        return this.loggingTimestamp;
    }

    @Override
    public final void setLoggingTimestamp(long timestamp) {
        this.loggingTimestamp = timestamp;
    }

    @Override
    public final String toString() {
        Object[] recordVector = this.toArray();
        StringBuilder sb = new StringBuilder();
        sb.append(this.loggingTimestamp);
        for (Object curStr : recordVector) {
            sb.append(';');
            if (curStr != null) {
                sb.append(curStr.toString());
                continue;
            }
            sb.append("null");
        }
        return sb.toString();
    }

    @Override
    public int compareTo(IMonitoringRecord otherRecord) {
        long timedifference = this.loggingTimestamp - otherRecord.getLoggingTimestamp();
        if (timedifference < 0L) {
            return -1;
        }
        if (timedifference > 0L) {
            return 1;
        }
        return this.hashCode() - otherRecord.hashCode();
    }

    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        if (this.loggingTimestamp != ((AbstractMonitoringRecord)obj).getLoggingTimestamp()) {
            return false;
        }
        return Arrays.equals(((AbstractMonitoringRecord)obj).toArray(), this.toArray());
    }

    public final int hashCode() {
        return 31 * Arrays.hashCode(this.toArray()) + (int)(this.loggingTimestamp ^ this.loggingTimestamp >>> 32);
    }

    public static final void checkArray(Object[] values, Class<?>[] valueTypes) {
        if (values.length != valueTypes.length) {
            throw new IllegalArgumentException("Expecting array with " + valueTypes.length + " elements but found " + values.length + " elements.");
        }
        for (int curIdx = 0; curIdx < valueTypes.length; ++curIdx) {
            if (values[curIdx] == null) {
                throw new IllegalArgumentException("Expecting " + valueTypes[curIdx].getName() + " but found null at position " + curIdx + " of the array.");
            }
            if (valueTypes[curIdx] == Integer.TYPE || valueTypes[curIdx] == Integer.class ? values[curIdx] instanceof Integer : (valueTypes[curIdx] == Long.TYPE || valueTypes[curIdx] == Long.class ? values[curIdx] instanceof Long : (valueTypes[curIdx] == Float.TYPE || valueTypes[curIdx] == Float.class ? values[curIdx] instanceof Float : (valueTypes[curIdx] == Double.TYPE || valueTypes[curIdx] == Double.class ? values[curIdx] instanceof Double : (valueTypes[curIdx] == Byte.TYPE || valueTypes[curIdx] == Byte.class ? values[curIdx] instanceof Byte : (valueTypes[curIdx] == Short.TYPE || valueTypes[curIdx] == Short.class ? values[curIdx] instanceof Short : (valueTypes[curIdx] == Boolean.TYPE || valueTypes[curIdx] == Boolean.class ? values[curIdx] instanceof Boolean : valueTypes[curIdx].equals(values[curIdx].getClass())))))))) continue;
            throw new IllegalArgumentException("Expecting " + valueTypes[curIdx].getName() + " but found " + values[curIdx].getClass().getName() + " at position " + curIdx + " of the array.");
        }
    }

    public static final Object[] fromStringArrayToTypedArray(String[] recordFields, Class<?>[] valueTypes) throws IllegalArgumentException {
        if (recordFields.length != valueTypes.length) {
            throw new IllegalArgumentException("Expected " + valueTypes.length + " record fields, but found " + recordFields.length);
        }
        Object[] typedArray = new Object[recordFields.length];
        for (int curIdx = 0; curIdx < typedArray.length; ++curIdx) {
            if (valueTypes[curIdx] == String.class) {
                typedArray[curIdx] = recordFields[curIdx];
                continue;
            }
            if (valueTypes[curIdx] == Integer.TYPE || valueTypes[curIdx] == Integer.class) {
                typedArray[curIdx] = Integer.valueOf(recordFields[curIdx]);
                continue;
            }
            if (valueTypes[curIdx] == Long.TYPE || valueTypes[curIdx] == Long.class) {
                typedArray[curIdx] = Long.valueOf(recordFields[curIdx]);
                continue;
            }
            if (valueTypes[curIdx] == Float.TYPE || valueTypes[curIdx] == Float.class) {
                typedArray[curIdx] = Float.valueOf(recordFields[curIdx]);
                continue;
            }
            if (valueTypes[curIdx] == Double.TYPE || valueTypes[curIdx] == Double.class) {
                typedArray[curIdx] = Double.valueOf(recordFields[curIdx]);
                continue;
            }
            if (valueTypes[curIdx] == Byte.TYPE || valueTypes[curIdx] == Byte.class) {
                typedArray[curIdx] = Byte.valueOf(recordFields[curIdx]);
                continue;
            }
            if (valueTypes[curIdx] == Short.TYPE || valueTypes[curIdx] == Short.class) {
                typedArray[curIdx] = Short.valueOf(recordFields[curIdx]);
                continue;
            }
            if (valueTypes[curIdx] == Boolean.TYPE || valueTypes[curIdx] == Boolean.class) {
                typedArray[curIdx] = Boolean.valueOf(recordFields[curIdx]);
                continue;
            }
            throw new IllegalArgumentException("Unsupported type: " + valueTypes[curIdx].getName());
        }
        return typedArray;
    }

    public static final Class<? extends IMonitoringRecord> classForName(String classname) throws MonitoringRecordException {
        Class clazz = (Class)OLD_KIEKERRECORDS.get(classname);
        if (clazz != null) {
            return clazz;
        }
        try {
            return Class.forName(classname).asSubclass(IMonitoringRecord.class);
        }
        catch (ClassNotFoundException ex) {
            throw new MonitoringRecordException("Failed to get record type of name " + classname, ex);
        }
        catch (ClassCastException ex) {
            throw new MonitoringRecordException("Failed to get record type of name " + classname, ex);
        }
    }

    public static final Class<?>[] typesForClass(Class<? extends IMonitoringRecord> clazz) throws MonitoringRecordException {
        try {
            if (IMonitoringRecord.Factory.class.isAssignableFrom(clazz)) {
                final Field types = clazz.getDeclaredField("TYPES");
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        types.setAccessible(true);
                        return null;
                    }
                });
                return (Class[])((Class[])types.get(null)).clone();
            }
            return clazz.newInstance().getValueTypes();
        }
        catch (SecurityException ex) {
            throw new MonitoringRecordException("Failed to get types for monitoring record of type " + clazz.getName(), ex);
        }
        catch (NoSuchFieldException ex) {
            throw new MonitoringRecordException("Failed to get types for monitoring record of type " + clazz.getName(), ex);
        }
        catch (IllegalArgumentException ex) {
            throw new MonitoringRecordException("Failed to get types for monitoring record of type " + clazz.getName(), ex);
        }
        catch (IllegalAccessException ex) {
            throw new MonitoringRecordException("Failed to get types for monitoring record of type " + clazz.getName(), ex);
        }
        catch (InstantiationException ex) {
            throw new MonitoringRecordException("Failed to get types for monitoring record of type " + clazz.getName(), ex);
        }
    }

    public static final IMonitoringRecord createFromArray(Class<? extends IMonitoringRecord> clazz, Object[] values) throws MonitoringRecordException {
        try {
            if (IMonitoringRecord.Factory.class.isAssignableFrom(clazz)) {
                Constructor<? extends IMonitoringRecord> constructor = clazz.getConstructor(Object[].class);
                return constructor.newInstance(new Object[]{values});
            }
            IMonitoringRecord record = clazz.newInstance();
            record.initFromArray(values);
            return record;
        }
        catch (SecurityException ex) {
            throw new MonitoringRecordException("Failed to instatiate new monitoring record of type " + clazz.getName(), ex);
        }
        catch (NoSuchMethodException ex) {
            throw new MonitoringRecordException("Failed to instatiate new monitoring record of type " + clazz.getName(), ex);
        }
        catch (IllegalArgumentException ex) {
            throw new MonitoringRecordException("Failed to instatiate new monitoring record of type " + clazz.getName(), ex);
        }
        catch (InstantiationException ex) {
            throw new MonitoringRecordException("Failed to instatiate new monitoring record of type " + clazz.getName(), ex);
        }
        catch (IllegalAccessException ex) {
            throw new MonitoringRecordException("Failed to instatiate new monitoring record of type " + clazz.getName(), ex);
        }
        catch (InvocationTargetException ex) {
            throw new MonitoringRecordException("Failed to instatiate new monitoring record of type " + clazz.getName(), ex);
        }
    }

    public static final IMonitoringRecord createFromStringArray(Class<? extends IMonitoringRecord> clazz, String[] values) throws MonitoringRecordException {
        try {
            if (IMonitoringRecord.Factory.class.isAssignableFrom(clazz)) {
                Constructor<? extends IMonitoringRecord> constructor = clazz.getConstructor(Object[].class);
                final Field types = clazz.getDeclaredField("TYPES");
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        types.setAccessible(true);
                        return null;
                    }
                });
                return constructor.newInstance(new Object[]{AbstractMonitoringRecord.fromStringArrayToTypedArray(values, (Class[])types.get(null))});
            }
            IMonitoringRecord record = clazz.newInstance();
            record.initFromArray(AbstractMonitoringRecord.fromStringArrayToTypedArray(values, record.getValueTypes()));
            return record;
        }
        catch (SecurityException ex) {
            throw new MonitoringRecordException("Failed to instatiate new monitoring record of type " + clazz.getName(), ex);
        }
        catch (NoSuchMethodException ex) {
            throw new MonitoringRecordException("Failed to instatiate new monitoring record of type " + clazz.getName(), ex);
        }
        catch (NoSuchFieldException ex) {
            throw new MonitoringRecordException("Failed to instatiate new monitoring record of type " + clazz.getName(), ex);
        }
        catch (IllegalArgumentException ex) {
            throw new MonitoringRecordException("Failed to instatiate new monitoring record of type " + clazz.getName(), ex);
        }
        catch (InstantiationException ex) {
            throw new MonitoringRecordException("Failed to instatiate new monitoring record of type " + clazz.getName(), ex);
        }
        catch (IllegalAccessException ex) {
            throw new MonitoringRecordException("Failed to instatiate new monitoring record of type " + clazz.getName(), ex);
        }
        catch (InvocationTargetException ex) {
            throw new MonitoringRecordException("Failed to instatiate new monitoring record of type " + clazz.getName(), ex);
        }
    }

    static {
        OLD_KIEKERRECORDS.put("kieker.tpmon.monitoringRecord.executions.KiekerExecutionRecord", OperationExecutionRecord.class);
        OLD_KIEKERRECORDS.put("kieker.common.record.CPUUtilizationRecord", CPUUtilizationRecord.class);
        OLD_KIEKERRECORDS.put("kieker.common.record.MemSwapUsageRecord", MemSwapUsageRecord.class);
        OLD_KIEKERRECORDS.put("kieker.common.record.ResourceUtilizationRecord", ResourceUtilizationRecord.class);
        OLD_KIEKERRECORDS.put("kieker.common.record.OperationExecutionRecord", OperationExecutionRecord.class);
        OLD_KIEKERRECORDS.put("kieker.common.record.BranchingRecord", BranchingRecord.class);
    }
}

