/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.flow.trace.operation;

import kieker.common.record.flow.IOperationRecord;
import kieker.common.record.flow.trace.AbstractTraceEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOperationEvent
extends AbstractTraceEvent
implements IOperationRecord {
    private static final long serialVersionUID = 1L;
    private static final String NO_OPERATIONSIGNATURE = "<no-operationSignature>";
    private static final String NO_CLASSSIGNATURE = "";
    private final String operationSignature;
    private final String classSignature;

    public AbstractOperationEvent(long timestamp, long traceId, int orderIndex, String operationSignature, String classSignature) {
        super(timestamp, traceId, orderIndex);
        this.operationSignature = operationSignature == null ? NO_OPERATIONSIGNATURE : operationSignature;
        this.classSignature = classSignature == null ? NO_CLASSSIGNATURE : classSignature;
    }

    protected AbstractOperationEvent(Object[] values, Class<?>[] valueTypes) {
        super(values, valueTypes);
        this.operationSignature = (String)values[3];
        this.classSignature = (String)values[4];
    }

    @Override
    public final String getOperationSignature() {
        return this.operationSignature;
    }

    @Override
    public final String getClassSignature() {
        return this.classSignature;
    }

    @Override
    public final boolean refersToSameOperationAs(IOperationRecord record) {
        return this.getOperationSignature().equals(record.getOperationSignature()) && this.getClassSignature().equals(record.getClassSignature());
    }
}

