/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.system;

import kieker.common.record.AbstractMonitoringRecord;
import kieker.common.record.IMonitoringRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MemSwapUsageRecord
extends AbstractMonitoringRecord
implements IMonitoringRecord.Factory {
    public static final String DEFAULT_VALUE = "N/A";
    private static final long serialVersionUID = 8072422694598002383L;
    private static final Class<?>[] TYPES = new Class[]{Long.TYPE, String.class, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE};
    private final long memUsed;
    private final long memFree;
    private final long swapTotal;
    private final long swapUsed;
    private final long swapFree;
    private final long timestamp;
    private final String hostname;
    private final long memTotal;

    public MemSwapUsageRecord(long timestamp, String hostname, long memTotal, long memUsed, long memFree, long swapTotal, long swapUsed, long swapFree) {
        this.timestamp = timestamp;
        this.hostname = hostname == null ? DEFAULT_VALUE : hostname;
        this.memTotal = memTotal;
        this.memUsed = memUsed;
        this.memFree = memFree;
        this.swapTotal = swapTotal;
        this.swapUsed = swapUsed;
        this.swapFree = swapFree;
    }

    public MemSwapUsageRecord(Object[] values) {
        AbstractMonitoringRecord.checkArray(values, TYPES);
        this.timestamp = (Long)values[0];
        this.hostname = (String)values[1];
        this.memTotal = (Long)values[2];
        this.memUsed = (Long)values[3];
        this.memFree = (Long)values[4];
        this.swapTotal = (Long)values[5];
        this.swapUsed = (Long)values[6];
        this.swapFree = (Long)values[7];
    }

    @Override
    public Object[] toArray() {
        return new Object[]{this.timestamp, this.hostname, this.memTotal, this.memUsed, this.memFree, this.swapTotal, this.swapUsed, this.swapFree};
    }

    @Override
    @Deprecated
    public void initFromArray(Object[] values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Class<?>[] getValueTypes() {
        return (Class[])TYPES.clone();
    }

    public final long getMemTotal() {
        return this.memTotal;
    }

    public final long getMemUsed() {
        return this.memUsed;
    }

    public final long getMemFree() {
        return this.memFree;
    }

    public final long getSwapTotal() {
        return this.swapTotal;
    }

    public final long getSwapUsed() {
        return this.swapUsed;
    }

    public final long getSwapFree() {
        return this.swapFree;
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    public final String getHostname() {
        return this.hostname;
    }
}

