/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.system;

import kieker.common.record.AbstractMonitoringRecord;
import kieker.common.record.IMonitoringRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResourceUtilizationRecord
extends AbstractMonitoringRecord
implements IMonitoringRecord.Factory {
    private static final long serialVersionUID = 8412442607068036054L;
    private static final Class<?>[] TYPES = new Class[]{Long.TYPE, String.class, String.class, Double.TYPE};
    private static final String DEFAULT_VALUE = "N/A";
    private final long timestamp;
    private final String hostname;
    private final String resourceName;
    private final double utilization;

    public ResourceUtilizationRecord(long timestamp, String hostname, String resourceName, double utilization) {
        this.timestamp = timestamp;
        this.hostname = hostname == null ? DEFAULT_VALUE : hostname;
        this.resourceName = resourceName == null ? DEFAULT_VALUE : resourceName;
        this.utilization = utilization;
    }

    public ResourceUtilizationRecord(Object[] values) {
        AbstractMonitoringRecord.checkArray(values, TYPES);
        this.timestamp = (Long)values[0];
        this.hostname = (String)values[1];
        this.resourceName = (String)values[2];
        this.utilization = (Double)values[3];
    }

    @Override
    public Object[] toArray() {
        return new Object[]{this.timestamp, this.hostname, this.resourceName, this.utilization};
    }

    @Override
    @Deprecated
    public void initFromArray(Object[] values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Class<?>[] getValueTypes() {
        return (Class[])TYPES.clone();
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    public final String getHostname() {
        return this.hostname;
    }

    public final String getResourceName() {
        return this.resourceName;
    }

    public final double getUtilization() {
        return this.utilization;
    }
}

