/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.core.configuration;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import kieker.common.configuration.Configuration;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.monitoring.core.configuration.Keys;
import kieker.monitoring.core.controller.MonitoringController;

public final class ConfigurationFactory
implements Keys {
    private static final Log LOG = LogFactory.getLog(ConfigurationFactory.class);

    private ConfigurationFactory() {
    }

    public static final Configuration createSingletonConfiguration() {
        Configuration loadConfiguration;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Searching for JVM argument 'kieker.monitoring.configuration' ...");
        }
        Configuration defaultConfiguration = ConfigurationFactory.defaultConfiguration();
        defaultConfiguration.setProperty("kieker.monitoring.name", "KIEKER-SINGLETON");
        String configurationFile = System.getProperty("kieker.monitoring.configuration");
        if (configurationFile != null) {
            LOG.info("Loading configuration from JVM-specified location: '" + configurationFile + "'");
            loadConfiguration = ConfigurationFactory.loadConfigurationFromFile(configurationFile, defaultConfiguration);
        } else {
            configurationFile = "META-INF/kieker.monitoring.properties";
            LOG.info("Loading properties from properties file in classpath: '" + configurationFile + "'");
            loadConfiguration = ConfigurationFactory.loadConfigurationFromResource(configurationFile, defaultConfiguration);
        }
        return ConfigurationFactory.getSystemPropertiesStartingWith("kieker.monitoring.", loadConfiguration);
    }

    public static final Configuration createDefaultConfiguration() {
        return new Configuration(ConfigurationFactory.defaultConfiguration());
    }

    public static final Configuration createConfigurationFromFile(String configurationFile) {
        return ConfigurationFactory.loadConfigurationFromFile(configurationFile, ConfigurationFactory.defaultConfiguration());
    }

    private static final Configuration defaultConfiguration() {
        return ConfigurationFactory.loadConfigurationFromResource("META-INF/kieker.monitoring.default.properties", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Configuration loadConfigurationFromFile(String propertiesFn, Configuration defaultValues) {
        Configuration properties = new Configuration(defaultValues);
        InputStream is = null;
        try {
            block18: {
                try {
                    is = new FileInputStream(propertiesFn);
                }
                catch (FileNotFoundException ex) {
                    is = MonitoringController.class.getClassLoader().getResourceAsStream(propertiesFn);
                    if (is != null) break block18;
                    LOG.warn("File '" + propertiesFn + "' not found");
                    Configuration configuration = new Configuration(defaultValues);
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException ex2) {
                            LOG.warn("Failed to close FileInputStream", ex2);
                        }
                    }
                    return configuration;
                }
            }
            properties.load(is);
            Configuration ex = properties;
            return ex;
        }
        catch (Exception ex) {
            LOG.error("Error reading file '" + propertiesFn + "'", ex);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    LOG.warn("Failed to close FileInputStream", ex);
                }
            }
        }
        return new Configuration(defaultValues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Configuration loadConfigurationFromResource(String propertiesFn, Configuration defaultValues) {
        InputStream is = MonitoringController.class.getClassLoader().getResourceAsStream(propertiesFn);
        if (is == null) {
            LOG.warn("File '" + propertiesFn + "' not found in classpath");
        } else {
            try {
                Configuration properties = new Configuration(defaultValues);
                properties.load(is);
                Configuration configuration = properties;
                return configuration;
            }
            catch (Exception ex) {
                LOG.error("Error reading file '" + propertiesFn + "'", ex);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    LOG.warn("Failed to close RessourceInputStream", ex);
                }
            }
        }
        return new Configuration(defaultValues);
    }

    private static final Configuration getSystemPropertiesStartingWith(String prefix, Configuration defaultValues) {
        Configuration configuration = new Configuration(defaultValues);
        Properties properties = System.getProperties();
        Enumeration<?> keys = properties.propertyNames();
        while (keys.hasMoreElements()) {
            String property = (String)keys.nextElement();
            if (!property.startsWith(prefix)) continue;
            configuration.setProperty(property, properties.getProperty(property));
        }
        return configuration;
    }
}

