/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.probe.aspectj.flow.construction;

import kieker.common.record.flow.trace.ConstructionEvent;
import kieker.common.record.flow.trace.Trace;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.core.controller.MonitoringController;
import kieker.monitoring.core.registry.TraceRegistry;
import kieker.monitoring.probe.aspectj.AbstractAspectJProbe;
import kieker.monitoring.timer.ITimeSource;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;

@Aspect
public abstract class AbstractAspect
extends AbstractAspectJProbe {
    private static final IMonitoringController CTRLINST = MonitoringController.getInstance();
    private static final ITimeSource TIME = CTRLINST.getTimeSource();
    private static final TraceRegistry TRACEREGISTRY = TraceRegistry.INSTANCE;

    @Pointcut
    public abstract /* synthetic */ void monitoredConstructor();

    @AfterReturning(value="monitoredConstructor() && this(thisObject) && notWithinKieker()")
    public void afterConstruction(Object thisObject, JoinPoint.StaticPart jp) {
        boolean newTrace;
        Signature signature = jp.getSignature();
        if (!CTRLINST.isProbeActivated(signature.toLongString())) {
            return;
        }
        Trace trace = TRACEREGISTRY.getTrace();
        boolean bl = newTrace = trace == null;
        if (newTrace) {
            trace = TRACEREGISTRY.registerTrace();
            CTRLINST.newMonitoringRecord(trace);
        }
        ConstructionEvent crecord = new ConstructionEvent(TIME.getTime(), trace.getTraceId(), trace.getNextOrderId(), signature.getDeclaringTypeName(), System.identityHashCode(thisObject));
        CTRLINST.newMonitoringRecord(crecord);
    }
}

