/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.writer;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import kieker.common.configuration.Configuration;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.common.record.IMonitoringRecord;
import kieker.monitoring.writer.AbstractMonitoringWriter;

public class PrintStreamWriter
extends AbstractMonitoringWriter {
    private static final Log LOG = LogFactory.getLog(PrintStreamWriter.class);
    private static final String PREFIX = PrintStreamWriter.class.getName() + ".";
    public static final String STREAM = PREFIX + "Stream";
    public static final String CONFIG_STREAM_STDOUT = "STDOUT";
    public static final String CONFIG_STREAM_STDERR = "STDERR";
    private static final String ENCODING = "UTF-8";
    private PrintStream printStream;

    public PrintStreamWriter(Configuration configuration) {
        super(configuration);
    }

    public void init() throws FileNotFoundException, UnsupportedEncodingException {
        String printStreamName = this.configuration.getStringProperty(STREAM);
        this.printStream = CONFIG_STREAM_STDOUT.equals(printStreamName) ? System.out : (CONFIG_STREAM_STDERR.equals(printStreamName) ? System.err : new PrintStream((OutputStream)new FileOutputStream(printStreamName), false, ENCODING));
    }

    public boolean newMonitoringRecord(IMonitoringRecord record) {
        this.printStream.println(record.getClass().getSimpleName() + ": " + ((Object)record).toString());
        return true;
    }

    public void terminate() {
        if (this.printStream != null && this.printStream != System.out && this.printStream != System.err) {
            this.printStream.close();
        }
        LOG.info(this.getClass().getName() + " shutting down.");
    }
}

