/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.writer.filesystem.async;

import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.BlockingQueue;
import kieker.common.record.IMonitoringRecord;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.core.registry.RegistryRecord;
import kieker.monitoring.writer.AbstractAsyncThread;
import kieker.monitoring.writer.filesystem.MappingFileWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFsWriterThread
extends AbstractAsyncThread {
    private static final String FILE_PREFIX = "kieker-";
    protected String fileExtension = ".dat";
    private final MappingFileWriter mappingFileWriter;
    private final String filenamePrefix;
    private final String path;
    private final int maxEntriesInFile;
    private final long maxLogSize;
    private final int maxLogFiles;
    private int entriesInCurrentFileCounter;
    private final LinkedList<FileNameSize> listOfLogFiles;
    private long totalLogSize;
    private final DateFormat dateFormat;
    private long previousFileDate;
    private long sameFilenameCounter;

    public AbstractFsWriterThread(IMonitoringController monitoringController, BlockingQueue<IMonitoringRecord> writeQueue, MappingFileWriter mappingFileWriter, String path, int maxEntriesInFile, int maxLogSize, int maxLogFiles) {
        super(monitoringController, writeQueue);
        this.mappingFileWriter = mappingFileWriter;
        this.path = new File(path).getAbsolutePath();
        this.filenamePrefix = path + File.separatorChar + FILE_PREFIX;
        this.maxEntriesInFile = maxEntriesInFile;
        if (maxLogSize > 0 || maxLogFiles > 0) {
            this.maxLogSize = (long)maxLogSize * 1024L * 1024L;
            this.maxLogFiles = maxLogFiles;
            this.listOfLogFiles = new LinkedList();
        } else {
            this.maxLogSize = -1L;
            this.maxLogFiles = -1;
            this.listOfLogFiles = null;
        }
        this.entriesInCurrentFileCounter = maxEntriesInFile;
        this.dateFormat = new SimpleDateFormat("yyyyMMdd'-'HHmmssSSS", Locale.US);
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    protected final String getFilename() {
        String threadName = this.getName();
        long date = System.currentTimeMillis();
        if (this.previousFileDate == date) {
            ++this.sameFilenameCounter;
        } else {
            this.sameFilenameCounter = 0L;
            this.previousFileDate = date;
        }
        StringBuilder sb = new StringBuilder(this.filenamePrefix.length() + threadName.length() + this.fileExtension.length() + 27);
        sb.append(this.filenamePrefix).append(this.dateFormat.format(new Date(date))).append("-UTC-").append(String.format("%03d", this.sameFilenameCounter)).append('-').append(threadName).append(this.fileExtension);
        return sb.toString();
    }

    @Override
    protected final void consume(IMonitoringRecord monitoringRecord) throws Exception {
        if (monitoringRecord instanceof RegistryRecord) {
            this.mappingFileWriter.write((RegistryRecord)monitoringRecord);
        } else {
            if (++this.entriesInCurrentFileCounter > this.maxEntriesInFile) {
                this.entriesInCurrentFileCounter = 1;
                String filename = this.getFilename();
                this.prepareFile(filename);
                if (this.listOfLogFiles != null) {
                    FileNameSize removeFile;
                    if (!this.listOfLogFiles.isEmpty()) {
                        long filesize;
                        FileNameSize fns = this.listOfLogFiles.getLast();
                        fns.size = filesize = new File(fns.name).length();
                        this.totalLogSize += filesize;
                    }
                    this.listOfLogFiles.add(new FileNameSize(filename));
                    if (this.maxLogFiles > 0 && this.listOfLogFiles.size() > this.maxLogFiles) {
                        removeFile = this.listOfLogFiles.removeFirst();
                        if (!new File(removeFile.name).delete()) {
                            throw new IOException("Failed to delete file " + removeFile.name);
                        }
                        this.totalLogSize -= removeFile.size;
                    }
                    if (this.maxLogSize > 0L) {
                        while (this.listOfLogFiles.size() > 1 && this.totalLogSize > this.maxLogSize) {
                            removeFile = this.listOfLogFiles.removeFirst();
                            if (!new File(removeFile.name).delete()) {
                                throw new IOException("Failed to delete file " + removeFile.name);
                            }
                            this.totalLogSize -= removeFile.size;
                        }
                    }
                }
            }
            this.write(monitoringRecord);
        }
    }

    protected abstract void write(IMonitoringRecord var1) throws IOException;

    protected abstract void prepareFile(String var1) throws IOException;

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append(super.toString());
        sb.append("; Writing to Directory: '");
        sb.append(this.path);
        sb.append('\'');
        return sb.toString();
    }

    private static final class FileNameSize {
        public final String name;
        public long size;

        public FileNameSize(String name) {
            this.name = name;
        }
    }
}

