/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.traceAnalysis;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentMap;
import kieker.analysis.AnalysisController;
import kieker.analysis.exception.AnalysisConfigurationException;
import kieker.analysis.plugin.AbstractPlugin;
import kieker.analysis.plugin.filter.flow.EventRecordTraceReconstructionFilter;
import kieker.analysis.plugin.filter.forward.StringBufferFilter;
import kieker.analysis.plugin.filter.select.TimestampFilter;
import kieker.analysis.plugin.filter.trace.TraceIdFilter;
import kieker.analysis.plugin.reader.filesystem.FSReader;
import kieker.common.configuration.Configuration;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.tools.traceAnalysis.Constants;
import kieker.tools.traceAnalysis.filter.AbstractGraphProducingFilter;
import kieker.tools.traceAnalysis.filter.AbstractTraceProcessingFilter;
import kieker.tools.traceAnalysis.filter.IGraphOutputtingFilter;
import kieker.tools.traceAnalysis.filter.executionRecordTransformation.ExecutionRecordTransformationFilter;
import kieker.tools.traceAnalysis.filter.flow.TraceEventRecords2ExecutionAndMessageTraceFilter;
import kieker.tools.traceAnalysis.filter.systemModel.SystemModel2FileFilter;
import kieker.tools.traceAnalysis.filter.traceFilter.TraceEquivalenceClassFilter;
import kieker.tools.traceAnalysis.filter.traceReconstruction.TraceReconstructionFilter;
import kieker.tools.traceAnalysis.filter.traceWriter.ExecutionTraceWriterFilter;
import kieker.tools.traceAnalysis.filter.traceWriter.InvalidExecutionTraceWriterFilter;
import kieker.tools.traceAnalysis.filter.traceWriter.MessageTraceWriterFilter;
import kieker.tools.traceAnalysis.filter.visualization.AbstractGraphFilter;
import kieker.tools.traceAnalysis.filter.visualization.GraphWriterConfiguration;
import kieker.tools.traceAnalysis.filter.visualization.GraphWriterPlugin;
import kieker.tools.traceAnalysis.filter.visualization.callTree.AggregatedAllocationComponentOperationCallTreeFilter;
import kieker.tools.traceAnalysis.filter.visualization.callTree.AggregatedAssemblyComponentOperationCallTreeFilter;
import kieker.tools.traceAnalysis.filter.visualization.callTree.TraceCallTreeFilter;
import kieker.tools.traceAnalysis.filter.visualization.dependencyGraph.AbstractDependencyGraphFilter;
import kieker.tools.traceAnalysis.filter.visualization.dependencyGraph.AbstractNodeDecorator;
import kieker.tools.traceAnalysis.filter.visualization.dependencyGraph.ComponentDependencyGraphAllocationFilter;
import kieker.tools.traceAnalysis.filter.visualization.dependencyGraph.ComponentDependencyGraphAssemblyFilter;
import kieker.tools.traceAnalysis.filter.visualization.dependencyGraph.ContainerDependencyGraphFilter;
import kieker.tools.traceAnalysis.filter.visualization.dependencyGraph.OperationDependencyGraphAllocationFilter;
import kieker.tools.traceAnalysis.filter.visualization.dependencyGraph.OperationDependencyGraphAssemblyFilter;
import kieker.tools.traceAnalysis.filter.visualization.descriptions.DescriptionDecoratorFilter;
import kieker.tools.traceAnalysis.filter.visualization.sequenceDiagram.SequenceDiagramFilter;
import kieker.tools.traceAnalysis.filter.visualization.traceColoring.TraceColoringFilter;
import kieker.tools.traceAnalysis.repository.DescriptionRepository;
import kieker.tools.traceAnalysis.repository.TraceColorRepository;
import kieker.tools.traceAnalysis.systemModel.ExecutionTrace;
import kieker.tools.traceAnalysis.systemModel.repository.SystemModelRepository;
import kieker.tools.util.LoggingTimestampConverter;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TraceAnalysisTool {
    public static final String DATE_FORMAT_PATTERN_CMD_USAGE_HELP = "yyyyMMdd'-'HHmmss".replaceAll("'", "");
    private static final Log LOG = LogFactory.getLog(TraceAnalysisTool.class);
    private static final SystemModelRepository SYSTEM_ENTITY_FACTORY = new SystemModelRepository(new Configuration());
    private static final CommandLineParser CMDL_PARSER = new BasicParser();
    private static CommandLine cmdl;
    private static String[] inputDirs;
    private static String outputDir;
    private static String outputFnPrefix;
    private static Set<Long> selectedTraces;
    private static boolean shortLabels;
    private static boolean includeSelfLoops;
    private static boolean ignoreInvalidTraces;
    private static int maxTraceDurationMillis;
    private static long ignoreExecutionsBeforeTimestamp;
    private static long ignoreExecutionsAfterTimestamp;
    private static final String ENCODING = "UTF-8";

    private TraceAnalysisTool() {
    }

    private static boolean parseArgs(String[] args) {
        try {
            cmdl = CMDL_PARSER.parse(Constants.CMDL_OPTIONS, args);
        }
        catch (org.apache.commons.cli.ParseException e) {
            TraceAnalysisTool.printUsage();
            System.err.println("\nError parsing arguments: " + e.getMessage());
            return false;
        }
        return true;
    }

    private static void printUsage() {
        Constants.CMD_HELP_FORMATTER.printHelp(80, TraceAnalysisTool.class.getName(), "", Constants.CMDL_OPTIONS, "", true);
    }

    private static boolean initFromArgs() {
        inputDirs = cmdl.getOptionValues("inputdirs");
        outputDir = cmdl.getOptionValue("outputdir") + File.separator;
        outputFnPrefix = cmdl.getOptionValue("output-filename-prefix", "");
        if (cmdl.hasOption("select-traces")) {
            Object[] traceIdList = cmdl.getOptionValues("select-traces");
            selectedTraces = new TreeSet<Long>();
            int numSelectedTraces = traceIdList.length;
            try {
                for (Object idStr : traceIdList) {
                    selectedTraces.add(Long.valueOf((String)idStr));
                }
                LOG.info(numSelectedTraces + " trace" + (numSelectedTraces > 1 ? "s" : "") + " selected");
            }
            catch (Exception e) {
                System.err.println("\nFailed to parse list of trace IDs: " + Arrays.toString(traceIdList) + "(" + e.getMessage() + ")");
                LOG.error("Failed to parse list of trace IDs: " + Arrays.toString(traceIdList), e);
                return false;
            }
        }
        shortLabels = cmdl.hasOption("short-labels");
        includeSelfLoops = cmdl.hasOption("include-self-loops");
        ignoreInvalidTraces = cmdl.hasOption("ignore-invalid-traces");
        String maxTraceDurationStr = cmdl.getOptionValue("max-trace-duration", Integer.toString(maxTraceDurationMillis));
        try {
            maxTraceDurationMillis = Integer.parseInt(maxTraceDurationStr);
        }
        catch (NumberFormatException exc) {
            System.err.println("\nFailed to parse int value of property max-trace-duration (must be an integer): " + maxTraceDurationStr);
            LOG.error("Failed to parse int value of property max-trace-duration (must be an integer):" + maxTraceDurationStr, exc);
            return false;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd'-'HHmmss", Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        try {
            String ignoreRecordsBeforeTimestampString = cmdl.getOptionValue("ignore-executions-before-date", null);
            String ignoreRecordsAfterTimestampString = cmdl.getOptionValue("ignore-executions-after-date", null);
            if (ignoreRecordsBeforeTimestampString != null) {
                Date ignoreBeforeDate = dateFormat.parse(ignoreRecordsBeforeTimestampString);
                ignoreExecutionsBeforeTimestamp = ignoreBeforeDate.getTime() * 1000000L;
                LOG.info("Ignoring records before " + dateFormat.format(ignoreBeforeDate) + " (" + ignoreExecutionsBeforeTimestamp + ")");
            }
            if (ignoreRecordsAfterTimestampString != null) {
                Date ignoreAfterDate = dateFormat.parse(ignoreRecordsAfterTimestampString);
                ignoreExecutionsAfterTimestamp = ignoreAfterDate.getTime() * 1000000L;
                LOG.info("Ignoring records after " + dateFormat.format(ignoreAfterDate) + " (" + ignoreExecutionsAfterTimestamp + ")");
            }
        }
        catch (ParseException ex) {
            String errorMsg = "Error parsing date/time string. Please use the following pattern: " + DATE_FORMAT_PATTERN_CMD_USAGE_HELP;
            System.err.println(errorMsg);
            LOG.error(errorMsg, ex);
            return false;
        }
        return true;
    }

    private static void dumpConfiguration() {
        System.out.println("#");
        System.out.println("# Configuration");
        for (Option o : Constants.SORTED_OPTION_LIST) {
            String longOpt = o.getLongOpt();
            String val = "<null>";
            if (longOpt.equals("inputdirs")) {
                val = Constants.stringArrToStringList(inputDirs);
            } else if (longOpt.equals("outputdir")) {
                val = outputDir;
            } else if (longOpt.equals("output-filename-prefix")) {
                val = outputFnPrefix;
            } else if (longOpt.equals("print-Deployment-Equivalence-Classes") || longOpt.equals("print-Assembly-Equivalence-Classes") || longOpt.equals("plot-Deployment-Sequence-Diagrams") || longOpt.equals("plot-Assembly-Sequence-Diagrams") || longOpt.equals("plot-Deployment-Component-Dependency-Graph") || longOpt.equals("plot-Assembly-Component-Dependency-Graph") || longOpt.equals("plot-Container-Dependency-Graph") || longOpt.equals("plot-Deployment-Operation-Dependency-Graph") || longOpt.equals("plot-Assembly-Operation-Dependency-Graph") || longOpt.equals("plot-Aggregated-Deployment-Call-Tree") || longOpt.equals("plot-Aggregated-Assembly-Call-Tree") || longOpt.equals("plot-Call-Trees") || longOpt.equals("print-Execution-Traces") || longOpt.equals("print-invalid-Execution-Traces") || longOpt.equals("print-Message-Traces")) {
                val = cmdl.hasOption(longOpt) ? "true" : "false";
            } else if (longOpt.equals("select-traces")) {
                val = selectedTraces != null ? selectedTraces.toString() : "<select all>";
            } else if (longOpt.equals("short-labels")) {
                val = shortLabels ? "true" : "false";
            } else if (longOpt.equals("include-self-loops")) {
                val = includeSelfLoops ? "true" : "false";
            } else if (longOpt.equals("ignore-invalid-traces")) {
                val = ignoreInvalidTraces ? "true" : "false";
            } else if (longOpt.equals("max-trace-duration")) {
                val = maxTraceDurationMillis + " ms";
            } else if (longOpt.equals("ignore-executions-before-date")) {
                val = LoggingTimestampConverter.convertLoggingTimestampToUTCString(ignoreExecutionsBeforeTimestamp) + " (" + LoggingTimestampConverter.convertLoggingTimestampLocalTimeZoneString(ignoreExecutionsBeforeTimestamp) + ")";
            } else if (longOpt.equals("ignore-executions-after-date")) {
                val = LoggingTimestampConverter.convertLoggingTimestampToUTCString(ignoreExecutionsAfterTimestamp) + " (" + LoggingTimestampConverter.convertLoggingTimestampLocalTimeZoneString(ignoreExecutionsAfterTimestamp) + ")";
            } else if ("traceColoring".equals(longOpt)) {
                val = cmdl.getOptionValue("traceColoring");
                if (val == null) {
                    val = "";
                }
            } else if ("addDescriptions".equals(longOpt)) {
                val = cmdl.getOptionValue("addDescriptions");
                if (val == null) {
                    val = "";
                }
            } else {
                val = Arrays.toString(cmdl.getOptionValues(longOpt));
                LOG.warn("Unformatted configuration output for option " + longOpt);
            }
            System.out.println("--" + longOpt + ": " + val);
        }
    }

    private static void addDecorators(String[] decoratorNames, AbstractDependencyGraphFilter<?> plugin) {
        if (decoratorNames == null) {
            return;
        }
        for (String currentDecoratorName : decoratorNames) {
            AbstractNodeDecorator currentDecorator = AbstractNodeDecorator.createFromName(currentDecoratorName);
            if (currentDecorator == null) {
                LOG.warn("Unknown decoration name '" + currentDecoratorName + "'.");
                continue;
            }
            plugin.addDecorator(currentDecorator);
        }
    }

    private static GraphWriterConfiguration createGraphWriterConfiguration() {
        GraphWriterConfiguration configuration = new GraphWriterConfiguration();
        configuration.setOutputPath(outputDir + File.separator + outputFnPrefix);
        configuration.setIncludeWeights(true);
        configuration.setUseShortLabels(shortLabels);
        configuration.setPlotLoops(includeSelfLoops);
        return configuration;
    }

    private static <P extends AbstractPlugin> void attachGraphWriter(P plugin, AbstractGraphProducingFilter<?> producer, AnalysisController controller) throws IllegalStateException, AnalysisConfigurationException {
        GraphWriterConfiguration gConfiguration = TraceAnalysisTool.createGraphWriterConfiguration();
        Configuration configuration = gConfiguration.getConfiguration();
        configuration.setProperty("name-hiddenAndNeverExportedProperty", producer.getConfigurationName());
        GraphWriterPlugin graphWriter = new GraphWriterPlugin(configuration);
        controller.registerFilter(graphWriter);
        controller.connect(plugin, ((IGraphOutputtingFilter)((Object)plugin)).getGraphOutputPortName(), graphWriter, "inputGraph");
    }

    private static <P extends AbstractPlugin> void connectGraphFilters(P predecessor, AbstractGraphFilter<?, ?, ?, ?> filter, AnalysisController controller) throws IllegalStateException, AnalysisConfigurationException {
        controller.registerFilter(filter);
        controller.connect(predecessor, ((IGraphOutputtingFilter)((Object)predecessor)).getGraphOutputPortName(), filter, filter.getGraphInputPortName());
    }

    private static <P extends AbstractPlugin> TraceColoringFilter<?, ?> createTraceColoringFilter(P predecessor, String coloringFileName, AnalysisController controller) throws IOException, IllegalStateException, AnalysisConfigurationException {
        TraceColorRepository colorRepository = TraceColorRepository.createFromFile(coloringFileName);
        controller.registerRepository(colorRepository);
        TraceColoringFilter coloringFilter = new TraceColoringFilter(new Configuration());
        TraceAnalysisTool.connectGraphFilters(predecessor, coloringFilter, controller);
        controller.connect(coloringFilter, "colorRepository", colorRepository);
        return coloringFilter;
    }

    private static <P extends AbstractPlugin> DescriptionDecoratorFilter<?, ?, ?> createDescriptionDecoratorFilter(P predecessor, String descriptionsFileName, AnalysisController controller) throws IOException, IllegalStateException, AnalysisConfigurationException {
        DescriptionRepository descriptionRepository = DescriptionRepository.createFromFile(descriptionsFileName);
        controller.registerRepository(descriptionRepository);
        DescriptionDecoratorFilter descriptionFilter = new DescriptionDecoratorFilter(new Configuration());
        TraceAnalysisTool.connectGraphFilters(predecessor, descriptionFilter, controller);
        controller.connect(descriptionFilter, "descriptionRepository", descriptionRepository);
        return descriptionFilter;
    }

    private static void attachGraphProcessors(List<AbstractGraphProducingFilter<?>> graphProducers, AnalysisController controller, CommandLine commandLine) throws IllegalStateException, AnalysisConfigurationException, IOException {
        for (AbstractGraphProducingFilter<?> producer : graphProducers) {
            AbstractGraphFilter lastFilter = null;
            if (commandLine.hasOption("traceColoring")) {
                String coloringFileName = commandLine.getOptionValue("traceColoring");
                lastFilter = TraceAnalysisTool.createTraceColoringFilter(producer, coloringFileName, controller);
            }
            if (commandLine.hasOption("addDescriptions")) {
                String descriptionsFileName = commandLine.getOptionValue("addDescriptions");
                lastFilter = lastFilter != null ? TraceAnalysisTool.createDescriptionDecoratorFilter(lastFilter, descriptionsFileName, controller) : TraceAnalysisTool.createDescriptionDecoratorFilter(producer, descriptionsFileName, controller);
            }
            if (lastFilter != null) {
                TraceAnalysisTool.attachGraphWriter(lastFilter, producer, controller);
                continue;
            }
            TraceAnalysisTool.attachGraphWriter(producer, producer, controller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static boolean dispatchTasks() {
        boolean retVal;
        block48: {
            AbstractTraceProcessingFilter traceEvents2ExecutionAndMessageTraceFilter;
            TraceReconstructionFilter mtReconstrFilter;
            int numRequestedTasks;
            block47: {
                TraceEquivalenceClassFilter traceAssemblyEquivClassFilter;
                TraceEquivalenceClassFilter traceAllocationEquivClassFilter;
                ArrayList<AbstractTraceProcessingFilter> allTraceProcessingComponents;
                AnalysisController analysisInstance;
                block44: {
                    boolean componentPlotAssemblyCallTreeConfig2222;
                    block45: {
                        retVal = true;
                        numRequestedTasks = 0;
                        mtReconstrFilter = null;
                        EventRecordTraceReconstructionFilter eventTraceReconstructionFilter = null;
                        traceEvents2ExecutionAndMessageTraceFilter = null;
                        analysisInstance = new AnalysisController();
                        Configuration conf = new Configuration(null);
                        conf.setProperty("inputDirs", Configuration.toProperty(inputDirs));
                        conf.setProperty("ignoreUnknownRecordTypes", Boolean.TRUE.toString());
                        FSReader reader = new FSReader(conf);
                        analysisInstance.registerReader(reader);
                        StringBufferFilter stringBufferFilter = new StringBufferFilter(new Configuration());
                        analysisInstance.registerFilter(stringBufferFilter);
                        analysisInstance.connect(reader, "monitoringRecords", stringBufferFilter, "received-events");
                        analysisInstance.registerRepository(SYSTEM_ENTITY_FACTORY);
                        Configuration configTimestampFilter = new Configuration();
                        configTimestampFilter.setProperty("ignoreBeforeTimestamp", Long.toString(ignoreExecutionsBeforeTimestamp));
                        configTimestampFilter.setProperty("ignoreAfterTimestamp", Long.toString(ignoreExecutionsAfterTimestamp));
                        TimestampFilter timestampFilter = new TimestampFilter(configTimestampFilter);
                        analysisInstance.registerFilter(timestampFilter);
                        analysisInstance.connect(stringBufferFilter, "relayed-events", timestampFilter, "monitoringRecordsExecution");
                        analysisInstance.connect(stringBufferFilter, "relayed-events", timestampFilter, "monitoringRecordsFlow");
                        Configuration configTraceIdFilterFlow = new Configuration();
                        if (selectedTraces == null) {
                            configTraceIdFilterFlow.setProperty("acceptAllTraces", Boolean.TRUE.toString());
                        } else {
                            configTraceIdFilterFlow.setProperty("acceptAllTraces", Boolean.FALSE.toString());
                            configTraceIdFilterFlow.setProperty("selectedTraceIds", Configuration.toProperty(selectedTraces.toArray(new Long[selectedTraces.size()])));
                        }
                        TraceIdFilter traceIdFilter = new TraceIdFilter(configTraceIdFilterFlow);
                        analysisInstance.registerFilter(traceIdFilter);
                        analysisInstance.connect(timestampFilter, "recordsWithinTimePeriod", traceIdFilter, "monitoringRecordsCombined");
                        Configuration execRecTransformerConfig = new Configuration();
                        execRecTransformerConfig.setProperty("name-hiddenAndNeverExportedProperty", "Execution record transformation");
                        ExecutionRecordTransformationFilter execRecTransformer = new ExecutionRecordTransformationFilter(execRecTransformerConfig);
                        analysisInstance.registerFilter(execRecTransformer);
                        analysisInstance.connect(traceIdFilter, "recordsMatchingId", execRecTransformer, "operationExecutionRecords");
                        analysisInstance.connect(execRecTransformer, "systemModelRepository", SYSTEM_ENTITY_FACTORY);
                        Configuration mtReconstrFilterConfig = new Configuration();
                        mtReconstrFilterConfig.setProperty("name-hiddenAndNeverExportedProperty", "Trace reconstruction (execution records -> execution traces)");
                        mtReconstrFilterConfig.setProperty("maxTraceDurationMillis", Integer.toString(maxTraceDurationMillis));
                        mtReconstrFilterConfig.setProperty("ignoreInvalidTraces", Boolean.toString(ignoreInvalidTraces));
                        mtReconstrFilter = new TraceReconstructionFilter(mtReconstrFilterConfig);
                        analysisInstance.registerFilter(mtReconstrFilter);
                        analysisInstance.connect(mtReconstrFilter, "systemModelRepository", SYSTEM_ENTITY_FACTORY);
                        analysisInstance.connect(execRecTransformer, "transformedExecutions", mtReconstrFilter, "executions");
                        Configuration configurationEventRecordTraceGenerationFilter = new Configuration();
                        configurationEventRecordTraceGenerationFilter.setProperty("name-hiddenAndNeverExportedProperty", "Trace reconstruction (trace event records -> event record traces)");
                        configurationEventRecordTraceGenerationFilter.setProperty("maxTraceDuration", Integer.toString(maxTraceDurationMillis));
                        eventTraceReconstructionFilter = new EventRecordTraceReconstructionFilter(configurationEventRecordTraceGenerationFilter);
                        analysisInstance.registerFilter(eventTraceReconstructionFilter);
                        analysisInstance.connect(traceIdFilter, "recordsMatchingId", eventTraceReconstructionFilter, "traceRecords");
                        Configuration configurationEventTrace2ExecutionTraceFilter = new Configuration();
                        configurationEventTrace2ExecutionTraceFilter.setProperty("name-hiddenAndNeverExportedProperty", "Trace reconstruction (event record traces -> execution traces)");
                        traceEvents2ExecutionAndMessageTraceFilter = new TraceEventRecords2ExecutionAndMessageTraceFilter(configurationEventTrace2ExecutionTraceFilter);
                        analysisInstance.registerFilter(traceEvents2ExecutionAndMessageTraceFilter);
                        analysisInstance.connect(eventTraceReconstructionFilter, "validTraces", traceEvents2ExecutionAndMessageTraceFilter, "traceEvents");
                        analysisInstance.connect(traceEvents2ExecutionAndMessageTraceFilter, "systemModelRepository", SYSTEM_ENTITY_FACTORY);
                        allTraceProcessingComponents = new ArrayList<AbstractTraceProcessingFilter>();
                        ArrayList allGraphProducers = new ArrayList();
                        Configuration traceAllocationEquivClassFilterConfig = new Configuration();
                        traceAllocationEquivClassFilterConfig.setProperty("name-hiddenAndNeverExportedProperty", "Trace equivalence class filter (deployment mode)");
                        traceAllocationEquivClassFilterConfig.setProperty("equivalenceMode", TraceEquivalenceClassFilter.TraceEquivalenceClassModes.ALLOCATION.toString());
                        traceAllocationEquivClassFilter = new TraceEquivalenceClassFilter(traceAllocationEquivClassFilterConfig);
                        if (cmdl.hasOption("print-Deployment-Equivalence-Classes")) {
                            analysisInstance.registerFilter(traceAllocationEquivClassFilter);
                            analysisInstance.connect(traceAllocationEquivClassFilter, "systemModelRepository", SYSTEM_ENTITY_FACTORY);
                            analysisInstance.connect(mtReconstrFilter, "executionTraces", traceAllocationEquivClassFilter, "executionTraces");
                            analysisInstance.connect(traceEvents2ExecutionAndMessageTraceFilter, "executionTrace", traceAllocationEquivClassFilter, "executionTraces");
                            allTraceProcessingComponents.add(traceAllocationEquivClassFilter);
                        }
                        Configuration traceAssemblyEquivClassFilterConfig = new Configuration();
                        traceAssemblyEquivClassFilterConfig.setProperty("name-hiddenAndNeverExportedProperty", "Trace equivalence class filter (assembly mode)");
                        traceAssemblyEquivClassFilterConfig.setProperty("equivalenceMode", TraceEquivalenceClassFilter.TraceEquivalenceClassModes.ASSEMBLY.toString());
                        traceAssemblyEquivClassFilter = new TraceEquivalenceClassFilter(traceAssemblyEquivClassFilterConfig);
                        if (cmdl.hasOption("print-Assembly-Equivalence-Classes")) {
                            analysisInstance.registerFilter(traceAssemblyEquivClassFilter);
                            analysisInstance.connect(mtReconstrFilter, "executionTraces", traceAssemblyEquivClassFilter, "executionTraces");
                            analysisInstance.connect(traceEvents2ExecutionAndMessageTraceFilter, "executionTrace", traceAssemblyEquivClassFilter, "executionTraces");
                            analysisInstance.connect(traceAssemblyEquivClassFilter, "systemModelRepository", SYSTEM_ENTITY_FACTORY);
                            allTraceProcessingComponents.add(traceAssemblyEquivClassFilter);
                        }
                        MessageTraceWriterFilter componentPrintMsgTrace = null;
                        if (cmdl.hasOption("print-Message-Traces")) {
                            ++numRequestedTasks;
                            Configuration componentPrintMsgTraceConfig = new Configuration();
                            componentPrintMsgTraceConfig.setProperty("name-hiddenAndNeverExportedProperty", "Print message traces");
                            componentPrintMsgTraceConfig.setProperty("outputFn", new File(outputDir + File.separator + outputFnPrefix + "messageTraces" + ".txt").getCanonicalPath());
                            componentPrintMsgTrace = new MessageTraceWriterFilter(componentPrintMsgTraceConfig);
                            analysisInstance.registerFilter(componentPrintMsgTrace);
                            analysisInstance.connect(mtReconstrFilter, "messageTraces", componentPrintMsgTrace, "messageTraces");
                            analysisInstance.connect(traceEvents2ExecutionAndMessageTraceFilter, "messageTrace", componentPrintMsgTrace, "messageTraces");
                            analysisInstance.connect(componentPrintMsgTrace, "systemModelRepository", SYSTEM_ENTITY_FACTORY);
                            allTraceProcessingComponents.add(componentPrintMsgTrace);
                        }
                        ExecutionTraceWriterFilter componentPrintExecTrace = null;
                        if (cmdl.hasOption("print-Execution-Traces")) {
                            ++numRequestedTasks;
                            Configuration componentPrintExecTraceConfig = new Configuration();
                            componentPrintExecTraceConfig.setProperty("name-hiddenAndNeverExportedProperty", "Print execution traces");
                            componentPrintExecTraceConfig.setProperty("outputFn", new File(outputDir + File.separator + outputFnPrefix + "executionTraces" + ".txt").getCanonicalPath());
                            componentPrintExecTrace = new ExecutionTraceWriterFilter(componentPrintExecTraceConfig);
                            analysisInstance.registerFilter(componentPrintExecTrace);
                            analysisInstance.connect(mtReconstrFilter, "executionTraces", componentPrintExecTrace, "executionTraces");
                            analysisInstance.connect(traceEvents2ExecutionAndMessageTraceFilter, "executionTrace", componentPrintExecTrace, "executionTraces");
                            analysisInstance.connect(componentPrintExecTrace, "systemModelRepository", SYSTEM_ENTITY_FACTORY);
                            allTraceProcessingComponents.add(componentPrintExecTrace);
                        }
                        InvalidExecutionTraceWriterFilter componentPrintInvalidTrace = null;
                        if (cmdl.hasOption("print-invalid-Execution-Traces")) {
                            ++numRequestedTasks;
                            Configuration componentPrintInvalidTraceConfig = new Configuration();
                            componentPrintInvalidTraceConfig.setProperty("name-hiddenAndNeverExportedProperty", "Print invalid execution traces");
                            componentPrintInvalidTraceConfig.setProperty("outputFn", new File(outputDir + File.separator + outputFnPrefix + "invalidTraceArtifacts" + ".txt").getCanonicalPath());
                            componentPrintInvalidTrace = new InvalidExecutionTraceWriterFilter(componentPrintInvalidTraceConfig);
                            analysisInstance.registerFilter(componentPrintInvalidTrace);
                            analysisInstance.connect(mtReconstrFilter, "invalidExecutionTraces", componentPrintInvalidTrace, "invalidExecutionTraces");
                            analysisInstance.connect(componentPrintInvalidTrace, "systemModelRepository", SYSTEM_ENTITY_FACTORY);
                            LOG.warn("EventTrace2ExecutionTraceFilter doesn't provide an output port for invalid execution traces, yet");
                            allTraceProcessingComponents.add(componentPrintInvalidTrace);
                        }
                        SequenceDiagramFilter componentPlotAllocationSeqDiagr = null;
                        if (retVal && cmdl.hasOption("plot-Deployment-Sequence-Diagrams")) {
                            ++numRequestedTasks;
                            Configuration componentPlotAllocationSeqDiagrConfig = new Configuration();
                            componentPlotAllocationSeqDiagrConfig.setProperty("name-hiddenAndNeverExportedProperty", "Sequence diagrams (deployment level)");
                            componentPlotAllocationSeqDiagrConfig.setProperty("filename", outputDir + File.separator + outputFnPrefix + "deploymentSequenceDiagram");
                            componentPlotAllocationSeqDiagrConfig.setProperty("SDMode", SequenceDiagramFilter.SDModes.ALLOCATION.toString());
                            componentPlotAllocationSeqDiagrConfig.setProperty("shortLabels", Boolean.toString(shortLabels));
                            componentPlotAllocationSeqDiagr = new SequenceDiagramFilter(componentPlotAllocationSeqDiagrConfig);
                            analysisInstance.registerFilter(componentPlotAllocationSeqDiagr);
                            analysisInstance.connect(mtReconstrFilter, "messageTraces", componentPlotAllocationSeqDiagr, "messageTraces");
                            analysisInstance.connect(traceEvents2ExecutionAndMessageTraceFilter, "messageTrace", componentPlotAllocationSeqDiagr, "messageTraces");
                            analysisInstance.connect(componentPlotAllocationSeqDiagr, "systemModelRepository", SYSTEM_ENTITY_FACTORY);
                            allTraceProcessingComponents.add(componentPlotAllocationSeqDiagr);
                        }
                        SequenceDiagramFilter componentPlotAssemblySeqDiagr = null;
                        if (retVal && cmdl.hasOption("plot-Assembly-Sequence-Diagrams")) {
                            ++numRequestedTasks;
                            Configuration componentPlotAssemblySeqDiagrConfig = new Configuration();
                            componentPlotAssemblySeqDiagrConfig.setProperty("name-hiddenAndNeverExportedProperty", "Sequence diagrams (assembly level)");
                            componentPlotAssemblySeqDiagrConfig.setProperty("filename", outputDir + File.separator + outputFnPrefix + "assemblySequenceDiagram");
                            componentPlotAssemblySeqDiagrConfig.setProperty("SDMode", SequenceDiagramFilter.SDModes.ASSEMBLY.toString());
                            componentPlotAssemblySeqDiagrConfig.setProperty("shortLabels", Boolean.toString(shortLabels));
                            componentPlotAssemblySeqDiagr = new SequenceDiagramFilter(componentPlotAssemblySeqDiagrConfig);
                            analysisInstance.registerFilter(componentPlotAssemblySeqDiagr);
                            analysisInstance.connect(mtReconstrFilter, "messageTraces", componentPlotAssemblySeqDiagr, "messageTraces");
                            analysisInstance.connect(traceEvents2ExecutionAndMessageTraceFilter, "messageTrace", componentPlotAssemblySeqDiagr, "messageTraces");
                            analysisInstance.connect(componentPlotAssemblySeqDiagr, "systemModelRepository", SYSTEM_ENTITY_FACTORY);
                            allTraceProcessingComponents.add(componentPlotAssemblySeqDiagr);
                        }
                        ComponentDependencyGraphAllocationFilter componentPlotAllocationComponentDepGraph = null;
                        if (retVal && cmdl.hasOption("plot-Deployment-Component-Dependency-Graph")) {
                            ++numRequestedTasks;
                            componentPlotAllocationComponentDepGraph = new ComponentDependencyGraphAllocationFilter(new Configuration());
                            String[] nodeDecorations = cmdl.getOptionValues("plot-Deployment-Component-Dependency-Graph");
                            TraceAnalysisTool.addDecorators(nodeDecorations, componentPlotAllocationComponentDepGraph);
                            analysisInstance.registerFilter(componentPlotAllocationComponentDepGraph);
                            analysisInstance.connect(mtReconstrFilter, "messageTraces", componentPlotAllocationComponentDepGraph, "messageTraces");
                            analysisInstance.connect(traceEvents2ExecutionAndMessageTraceFilter, "messageTrace", componentPlotAllocationComponentDepGraph, "messageTraces");
                            analysisInstance.connect(componentPlotAllocationComponentDepGraph, "systemModelRepository", SYSTEM_ENTITY_FACTORY);
                            allTraceProcessingComponents.add(componentPlotAllocationComponentDepGraph);
                            allGraphProducers.add(componentPlotAllocationComponentDepGraph);
                        }
                        ComponentDependencyGraphAssemblyFilter componentPlotAssemblyComponentDepGraph = null;
                        if (retVal && cmdl.hasOption("plot-Assembly-Component-Dependency-Graph")) {
                            ++numRequestedTasks;
                            componentPlotAssemblyComponentDepGraph = new ComponentDependencyGraphAssemblyFilter(new Configuration());
                            String[] nodeDecorations = cmdl.getOptionValues("plot-Assembly-Component-Dependency-Graph");
                            TraceAnalysisTool.addDecorators(nodeDecorations, componentPlotAssemblyComponentDepGraph);
                            analysisInstance.registerFilter(componentPlotAssemblyComponentDepGraph);
                            analysisInstance.connect(mtReconstrFilter, "messageTraces", componentPlotAssemblyComponentDepGraph, "messageTraces");
                            analysisInstance.connect(traceEvents2ExecutionAndMessageTraceFilter, "messageTrace", componentPlotAssemblyComponentDepGraph, "messageTraces");
                            analysisInstance.connect(componentPlotAssemblyComponentDepGraph, "systemModelRepository", SYSTEM_ENTITY_FACTORY);
                            allTraceProcessingComponents.add(componentPlotAssemblyComponentDepGraph);
                            allGraphProducers.add(componentPlotAssemblyComponentDepGraph);
                        }
                        ContainerDependencyGraphFilter componentPlotContainerDepGraph = null;
                        if (retVal && cmdl.hasOption("plot-Container-Dependency-Graph")) {
                            ++numRequestedTasks;
                            componentPlotContainerDepGraph = new ContainerDependencyGraphFilter(new Configuration());
                            analysisInstance.registerFilter(componentPlotContainerDepGraph);
                            analysisInstance.connect(mtReconstrFilter, "messageTraces", componentPlotContainerDepGraph, "messageTraces");
                            analysisInstance.connect(traceEvents2ExecutionAndMessageTraceFilter, "messageTrace", componentPlotContainerDepGraph, "messageTraces");
                            analysisInstance.connect(componentPlotContainerDepGraph, "systemModelRepository", SYSTEM_ENTITY_FACTORY);
                            allTraceProcessingComponents.add(componentPlotContainerDepGraph);
                            allGraphProducers.add(componentPlotContainerDepGraph);
                        }
                        OperationDependencyGraphAllocationFilter componentPlotAllocationOperationDepGraph = null;
                        if (retVal && cmdl.hasOption("plot-Deployment-Operation-Dependency-Graph")) {
                            ++numRequestedTasks;
                            componentPlotAllocationOperationDepGraph = new OperationDependencyGraphAllocationFilter(new Configuration());
                            String[] nodeDecorations = cmdl.getOptionValues("plot-Deployment-Operation-Dependency-Graph");
                            TraceAnalysisTool.addDecorators(nodeDecorations, componentPlotAllocationOperationDepGraph);
                            analysisInstance.registerFilter(componentPlotAllocationOperationDepGraph);
                            analysisInstance.connect(mtReconstrFilter, "messageTraces", componentPlotAllocationOperationDepGraph, "messageTraces");
                            analysisInstance.connect(traceEvents2ExecutionAndMessageTraceFilter, "messageTrace", componentPlotAllocationOperationDepGraph, "messageTraces");
                            analysisInstance.connect(componentPlotAllocationOperationDepGraph, "systemModelRepository", SYSTEM_ENTITY_FACTORY);
                            allTraceProcessingComponents.add(componentPlotAllocationOperationDepGraph);
                            allGraphProducers.add(componentPlotAllocationOperationDepGraph);
                        }
                        OperationDependencyGraphAssemblyFilter componentPlotAssemblyOperationDepGraph = null;
                        if (retVal && cmdl.hasOption("plot-Assembly-Operation-Dependency-Graph")) {
                            ++numRequestedTasks;
                            componentPlotAssemblyOperationDepGraph = new OperationDependencyGraphAssemblyFilter(new Configuration());
                            String[] nodeDecorations = cmdl.getOptionValues("plot-Assembly-Operation-Dependency-Graph");
                            TraceAnalysisTool.addDecorators(nodeDecorations, componentPlotAssemblyOperationDepGraph);
                            analysisInstance.registerFilter(componentPlotAssemblyOperationDepGraph);
                            analysisInstance.connect(mtReconstrFilter, "messageTraces", componentPlotAssemblyOperationDepGraph, "messageTraces");
                            analysisInstance.connect(traceEvents2ExecutionAndMessageTraceFilter, "messageTrace", componentPlotAssemblyOperationDepGraph, "messageTraces");
                            analysisInstance.connect(componentPlotAssemblyOperationDepGraph, "systemModelRepository", SYSTEM_ENTITY_FACTORY);
                            allTraceProcessingComponents.add(componentPlotAssemblyOperationDepGraph);
                            allGraphProducers.add(componentPlotAssemblyOperationDepGraph);
                        }
                        TraceCallTreeFilter componentPlotTraceCallTrees = null;
                        if (retVal && cmdl.hasOption("plot-Call-Trees")) {
                            ++numRequestedTasks;
                            Configuration componentPlotTraceCallTreesConfig = new Configuration();
                            componentPlotTraceCallTreesConfig.setProperty("dotOutputFn", new File(outputDir + File.separator + outputFnPrefix + "callTree").getCanonicalPath());
                            componentPlotTraceCallTreesConfig.setProperty("shortLabels", Boolean.toString(shortLabels));
                            componentPlotTraceCallTreesConfig.setProperty("name-hiddenAndNeverExportedProperty", "Trace call trees");
                            componentPlotTraceCallTrees = new TraceCallTreeFilter(componentPlotTraceCallTreesConfig);
                            analysisInstance.registerFilter(componentPlotTraceCallTrees);
                            analysisInstance.connect(mtReconstrFilter, "messageTraces", componentPlotTraceCallTrees, "messageTraces");
                            analysisInstance.connect(traceEvents2ExecutionAndMessageTraceFilter, "messageTrace", componentPlotTraceCallTrees, "messageTraces");
                            analysisInstance.connect(componentPlotTraceCallTrees, "systemModelRepository", SYSTEM_ENTITY_FACTORY);
                            allTraceProcessingComponents.add(componentPlotTraceCallTrees);
                        }
                        AggregatedAllocationComponentOperationCallTreeFilter componentPlotAggregatedCallTree = null;
                        if (retVal && cmdl.hasOption("plot-Aggregated-Deployment-Call-Tree")) {
                            ++numRequestedTasks;
                            Configuration componentPlotAggregatedCallTreeConfig = new Configuration();
                            componentPlotAggregatedCallTreeConfig.setProperty("name-hiddenAndNeverExportedProperty", "Aggregated call tree (deployment level)");
                            componentPlotAggregatedCallTreeConfig.setProperty("includeWeights", Boolean.toString(true));
                            componentPlotAggregatedCallTreeConfig.setProperty("shortLabels", Boolean.toString(shortLabels));
                            componentPlotAggregatedCallTreeConfig.setProperty("dotOutputFn", outputDir + File.separator + outputFnPrefix + "aggregatedDeploymentCallTree" + ".dot");
                            componentPlotAggregatedCallTree = new AggregatedAllocationComponentOperationCallTreeFilter(componentPlotAggregatedCallTreeConfig);
                            analysisInstance.registerFilter(componentPlotAggregatedCallTree);
                            analysisInstance.connect(mtReconstrFilter, "messageTraces", componentPlotAggregatedCallTree, "messageTraces");
                            analysisInstance.connect(traceEvents2ExecutionAndMessageTraceFilter, "messageTrace", componentPlotAggregatedCallTree, "messageTraces");
                            analysisInstance.connect(componentPlotAggregatedCallTree, "systemModelRepository", SYSTEM_ENTITY_FACTORY);
                            allTraceProcessingComponents.add(componentPlotAggregatedCallTree);
                        }
                        AggregatedAssemblyComponentOperationCallTreeFilter componentPlotAssemblyCallTree = null;
                        if (retVal && cmdl.hasOption("plot-Aggregated-Assembly-Call-Tree")) {
                            ++numRequestedTasks;
                            Configuration componentPlotAssemblyCallTreeConfig2222 = new Configuration();
                            componentPlotAssemblyCallTreeConfig2222.setProperty("name-hiddenAndNeverExportedProperty", "Aggregated call tree (assembly level)");
                            componentPlotAssemblyCallTreeConfig2222.setProperty("includeWeights", Boolean.toString(true));
                            componentPlotAssemblyCallTreeConfig2222.setProperty("shortLabels", Boolean.toString(shortLabels));
                            componentPlotAssemblyCallTreeConfig2222.setProperty("dotOutputFn", outputDir + File.separator + outputFnPrefix + "aggregatedAssemblyCallTree" + ".dot");
                            componentPlotAssemblyCallTree = new AggregatedAssemblyComponentOperationCallTreeFilter(componentPlotAssemblyCallTreeConfig2222);
                            analysisInstance.registerFilter(componentPlotAssemblyCallTree);
                            analysisInstance.connect(mtReconstrFilter, "messageTraces", componentPlotAssemblyCallTree, "messageTraces");
                            analysisInstance.connect(traceEvents2ExecutionAndMessageTraceFilter, "messageTrace", componentPlotAssemblyCallTree, "messageTraces");
                            analysisInstance.connect(componentPlotAssemblyCallTree, "systemModelRepository", SYSTEM_ENTITY_FACTORY);
                            allTraceProcessingComponents.add(componentPlotAssemblyCallTree);
                        }
                        if (retVal && cmdl.hasOption("print-Deployment-Equivalence-Classes")) {
                            ++numRequestedTasks;
                        }
                        TraceAnalysisTool.attachGraphProcessors(allGraphProducers, analysisInstance, cmdl);
                        if (numRequestedTasks != 0) break block44;
                        LOG.warn("No task requested");
                        TraceAnalysisTool.printUsage();
                        System.err.println("");
                        System.err.println("No task requested");
                        System.err.println("");
                        componentPlotAssemblyCallTreeConfig2222 = false;
                        if (numRequestedTasks <= 0) break block45;
                        if (mtReconstrFilter != null) {
                            mtReconstrFilter.printStatusMessage();
                        }
                        if (traceEvents2ExecutionAndMessageTraceFilter == null) break block45;
                        traceEvents2ExecutionAndMessageTraceFilter.printStatusMessage();
                    }
                    System.out.println("");
                    System.out.println("See 'kieker.log' for details");
                    return componentPlotAssemblyCallTreeConfig2222;
                }
                try {
                    block46: {
                        int numErrorCount;
                        block49: {
                            if (retVal) {
                                String systemEntitiesHtmlFn = outputDir + File.separator + outputFnPrefix + "system-entities.html";
                                Configuration systemModel2FileFilterConfig = new Configuration();
                                systemModel2FileFilterConfig.setProperty("outputFnHtml", systemEntitiesHtmlFn);
                                SystemModel2FileFilter systemModel2FileFilter = new SystemModel2FileFilter(systemModel2FileFilterConfig);
                                analysisInstance.registerFilter(systemModel2FileFilter);
                                analysisInstance.connect(systemModel2FileFilter, "systemModelRepository", SYSTEM_ENTITY_FACTORY);
                            }
                            numErrorCount = 0;
                            analysisInstance.run();
                            Object var34_37 = null;
                            for (AbstractTraceProcessingFilter c : allTraceProcessingComponents) {
                                numErrorCount += c.getErrorCount();
                                c.printStatusMessage();
                            }
                            String kaxOutputFn = outputDir + File.separator + outputFnPrefix + "traceAnalysis.kax";
                            File kaxOutputFile = new File(kaxOutputFn);
                            try {
                                analysisInstance.saveToFile(kaxOutputFile);
                                LOG.info("Saved analysis configuration to file '" + kaxOutputFile.getCanonicalPath() + "'");
                            }
                            catch (IOException ex) {
                                LOG.error("Failed to save analysis configuration to file '" + kaxOutputFile.getCanonicalPath() + "'");
                            }
                            break block49;
                            {
                                catch (Exception ex) {
                                    throw new Exception("Error occured while running analysis", ex);
                                }
                            }
                            catch (Throwable throwable) {
                                Object var34_38 = null;
                                for (AbstractTraceProcessingFilter c : allTraceProcessingComponents) {
                                    numErrorCount += c.getErrorCount();
                                    c.printStatusMessage();
                                }
                                kaxOutputFn = outputDir + File.separator + outputFnPrefix + "traceAnalysis.kax";
                                kaxOutputFile = new File(kaxOutputFn);
                                try {
                                    analysisInstance.saveToFile(kaxOutputFile);
                                    LOG.info("Saved analysis configuration to file '" + kaxOutputFile.getCanonicalPath() + "'");
                                }
                                catch (IOException ex) {
                                    LOG.error("Failed to save analysis configuration to file '" + kaxOutputFile.getCanonicalPath() + "'");
                                }
                                throw throwable;
                            }
                        }
                        if (!ignoreInvalidTraces && numErrorCount > 0) {
                            throw new Exception(numErrorCount + " errors occured in trace processing components");
                        }
                        if (retVal && cmdl.hasOption("print-Deployment-Equivalence-Classes")) {
                            retVal = TraceAnalysisTool.writeTraceEquivalenceReport(outputDir + File.separator + outputFnPrefix + "traceDeploymentEquivClasses" + ".txt", traceAllocationEquivClassFilter);
                        }
                        if (retVal && cmdl.hasOption("print-Assembly-Equivalence-Classes")) {
                            retVal = TraceAnalysisTool.writeTraceEquivalenceReport(outputDir + File.separator + outputFnPrefix + "traceAssemblyEquivClasses" + ".txt", traceAssemblyEquivClassFilter);
                        }
                        if (retVal) break block46;
                        System.err.println("A task failed");
                    }
                    Object var39_46 = null;
                    if (numRequestedTasks <= 0) break block47;
                    if (mtReconstrFilter != null) {
                        mtReconstrFilter.printStatusMessage();
                    }
                    if (traceEvents2ExecutionAndMessageTraceFilter == null) break block47;
                }
                catch (Throwable throwable) {
                    Object var39_48 = null;
                    if (numRequestedTasks > 0) {
                        if (mtReconstrFilter != null) {
                            mtReconstrFilter.printStatusMessage();
                        }
                        if (traceEvents2ExecutionAndMessageTraceFilter != null) {
                            traceEvents2ExecutionAndMessageTraceFilter.printStatusMessage();
                        }
                    }
                    System.out.println("");
                    System.out.println("See 'kieker.log' for details");
                    throw throwable;
                }
                traceEvents2ExecutionAndMessageTraceFilter.printStatusMessage();
            }
            System.out.println("");
            System.out.println("See 'kieker.log' for details");
            {
                break block48;
                catch (Exception ex) {
                    System.err.println("An error occured: " + ex.getMessage());
                    System.err.println("");
                    LOG.error("Exception", ex);
                    retVal = false;
                    Object var39_47 = null;
                    if (numRequestedTasks > 0) {
                        if (mtReconstrFilter != null) {
                            mtReconstrFilter.printStatusMessage();
                        }
                        if (traceEvents2ExecutionAndMessageTraceFilter != null) {
                            traceEvents2ExecutionAndMessageTraceFilter.printStatusMessage();
                        }
                    }
                    System.out.println("");
                    System.out.println("See 'kieker.log' for details");
                }
            }
        }
        return retVal;
    }

    private static boolean assertOutputDirExists() {
        File outputDirFile = new File(outputDir);
        try {
            if (!outputDirFile.exists()) {
                System.err.println("");
                System.err.println("The specified output directory '" + outputDirFile.getCanonicalPath() + "' does not exist");
                return false;
            }
            if (!outputDirFile.isDirectory()) {
                System.err.println("");
                System.err.println("The specified output directory '" + outputDirFile.getCanonicalPath() + "' is not a directory");
                return false;
            }
        }
        catch (IOException e) {
            System.err.println("");
            System.err.println("Error resolving name of output directory: '" + outputDir + "'");
        }
        return true;
    }

    private static boolean assertInputDirsExistsAndAreMonitoringLogs() {
        for (String inputDir : inputDirs) {
            File inputDirFile = new File(inputDir);
            try {
                if (!inputDirFile.exists()) {
                    System.err.println("");
                    System.err.println("The specified input directory '" + inputDirFile.getCanonicalPath() + "' does not exist");
                    return false;
                }
                if (!inputDirFile.isDirectory()) {
                    System.err.println("");
                    System.err.println("The specified input directory '" + inputDirFile.getCanonicalPath() + "' is not a directory");
                    return false;
                }
                File[] mapFiles = new File[]{new File(inputDir + "/kieker.map"), new File(inputDir + "/tpmon.map")};
                boolean mapFileExists = false;
                for (File potentialMapFile : mapFiles) {
                    if (!potentialMapFile.isFile()) continue;
                    mapFileExists = true;
                    break;
                }
                if (mapFileExists) continue;
                System.err.println("");
                System.err.println("The specified input directory '" + inputDirFile.getCanonicalPath() + "' is not a kieker log directory");
                return false;
            }
            catch (IOException e) {
                System.err.println("");
                System.err.println("Error resolving name of input directory: '" + inputDir + "'");
            }
        }
        return true;
    }

    public static void main(String[] args) {
        try {
            if (!(TraceAnalysisTool.parseArgs(args) && TraceAnalysisTool.initFromArgs() && TraceAnalysisTool.assertOutputDirExists() && TraceAnalysisTool.assertInputDirsExistsAndAreMonitoringLogs())) {
                System.exit(1);
            }
            TraceAnalysisTool.dumpConfiguration();
            if (!TraceAnalysisTool.dispatchTasks()) {
                System.exit(1);
            }
        }
        catch (Exception exc) {
            System.err.println("An error occured. See 'kieker.log' for details");
            LOG.error(Arrays.toString(args), exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean writeTraceEquivalenceReport(String outputFnPrefixL, TraceEquivalenceClassFilter traceEquivFilter) throws IOException {
        boolean retVal = true;
        String outputFn = new File(outputFnPrefixL).getCanonicalPath();
        PrintStream ps = null;
        try {
            try {
                ps = new PrintStream((OutputStream)new FileOutputStream(outputFn), false, ENCODING);
                int numClasses = 0;
                ConcurrentMap<ExecutionTrace, Integer> classMap = traceEquivFilter.getEquivalenceClassMap();
                for (Map.Entry e : classMap.entrySet()) {
                    ExecutionTrace t = (ExecutionTrace)e.getKey();
                    ps.println("Class " + numClasses++ + " ; cardinality: " + e.getValue() + "; # executions: " + t.getLength() + "; representative: " + t.getTraceId() + "; max. stack depth: " + t.getMaxEss());
                }
                System.out.println("");
                System.out.println("#");
                System.out.println("# Plugin: Trace equivalence report");
                System.out.println("Wrote " + numClasses + " equivalence class" + (numClasses > 1 ? "es" : "") + " to file '" + outputFn + "'");
            }
            catch (FileNotFoundException e) {
                LOG.error("File not found", e);
                retVal = false;
                Object var11_12 = null;
                if (ps != null) {
                    ps.close();
                }
            }
            Object var11_11 = null;
            if (ps != null) {
                ps.close();
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            if (ps != null) {
                ps.close();
            }
            throw throwable;
        }
        return retVal;
    }

    static {
        shortLabels = true;
        maxTraceDurationMillis = 600000;
        ignoreExecutionsBeforeTimestamp = TimestampFilter.CONFIG_PROPERTY_VALUE_MIN_TIMESTAMP;
        ignoreExecutionsAfterTimestamp = TimestampFilter.CONFIG_PROPERTY_VALUE_MAX_TIMESTAMP;
    }
}

