/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.traceAnalysis.filter;

import kieker.analysis.plugin.filter.AbstractFilterPlugin;
import kieker.common.configuration.Configuration;

public abstract class AbstractTimestampFilter
extends AbstractFilterPlugin {
    public static final long MAX_TIMESTAMP = Long.MAX_VALUE;
    public static final long MIN_TIMESTAMP = 0L;
    private final long ignoreBeforeTimestamp;
    private final long ignoreAfterTimestamp;

    public AbstractTimestampFilter(Configuration configuration) {
        super(configuration);
        this.ignoreBeforeTimestamp = configuration.getLongProperty(this.getConfigurationPropertyIgnoreBeforeTimestamp());
        this.ignoreAfterTimestamp = configuration.getLongProperty(this.getConfigurationPropertyIgnoreAfterTimestamp());
    }

    protected boolean inRange(long timestamp) {
        return timestamp >= this.ignoreBeforeTimestamp && timestamp <= this.ignoreAfterTimestamp;
    }

    protected abstract String getConfigurationPropertyIgnoreBeforeTimestamp();

    protected abstract String getConfigurationPropertyIgnoreAfterTimestamp();

    public Configuration getCurrentConfiguration() {
        Configuration configuration = new Configuration(null);
        configuration.setProperty(this.getConfigurationPropertyIgnoreBeforeTimestamp(), Long.toString(this.ignoreBeforeTimestamp));
        configuration.setProperty(this.getConfigurationPropertyIgnoreAfterTimestamp(), Long.toString(this.ignoreAfterTimestamp));
        return configuration;
    }
}

