/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.traceAnalysis.filter;

import java.util.Set;
import java.util.TreeSet;
import kieker.analysis.plugin.filter.AbstractFilterPlugin;
import kieker.common.configuration.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTraceIdFilter
extends AbstractFilterPlugin {
    private final Set<Long> selectedTraceIds;

    public AbstractTraceIdFilter(Configuration configuration) {
        super(configuration);
        this.selectedTraceIds = AbstractTraceIdFilter.extractIDsFromConfiguration(configuration, this.getConfigurationPropertySelectAllTraces(), this.getConfigurationPropertySelectedTraces());
    }

    private static Set<Long> extractIDsFromConfiguration(Configuration configuration, String configurationPropertySelectAllTraces, String configurationPropertySelectedTraces) {
        String[] ids;
        boolean passAll = configuration.getBooleanProperty(configurationPropertySelectAllTraces);
        if (passAll) {
            return null;
        }
        TreeSet<Long> idsToPass = new TreeSet<Long>();
        for (String id : ids = configuration.getStringArrayProperty(configurationPropertySelectedTraces)) {
            idsToPass.add(Long.parseLong(id));
        }
        return idsToPass;
    }

    protected boolean passId(long traceId) {
        return this.selectedTraceIds == null || this.selectedTraceIds.contains(traceId);
    }

    protected abstract String getConfigurationPropertySelectAllTraces();

    protected abstract String getConfigurationPropertySelectedTraces();

    @Override
    public Configuration getCurrentConfiguration() {
        Configuration configuration = new Configuration(null);
        if (this.selectedTraceIds != null) {
            configuration.setProperty(this.getConfigurationPropertySelectAllTraces(), Boolean.toString(true));
            configuration.setProperty(this.getConfigurationPropertySelectedTraces(), Configuration.toProperty(this.selectedTraceIds.toArray(new Long[this.selectedTraceIds.size()])));
        } else {
            configuration.setProperty(this.getConfigurationPropertySelectAllTraces(), Boolean.toString(true));
            configuration.setProperty(this.getConfigurationPropertySelectedTraces(), "");
        }
        return configuration;
    }
}

