/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.traceAnalysis.filter;

import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.RepositoryPort;
import kieker.common.configuration.Configuration;
import kieker.tools.traceAnalysis.filter.AbstractTraceAnalysisFilter;
import kieker.tools.traceAnalysis.systemModel.repository.SystemModelRepository;

@Plugin(repositoryPorts={@RepositoryPort(name="systemModelRepository", repositoryType=SystemModelRepository.class)})
public abstract class AbstractTraceProcessingFilter
extends AbstractTraceAnalysisFilter {
    public static final long MAX_DURATION_MILLIS = Integer.MAX_VALUE;
    private int numTracesProcessed;
    private int numTracesSucceeded;
    private int numTracesFailed;
    private long lastTraceIdSuccess = -1L;
    private long lastTraceIdError = -1L;

    public AbstractTraceProcessingFilter(Configuration configuration) {
        super(configuration);
    }

    protected final void reportSuccess(long traceId) {
        this.lastTraceIdSuccess = traceId;
        ++this.numTracesSucceeded;
        ++this.numTracesProcessed;
    }

    protected final void reportError(long traceId) {
        this.lastTraceIdError = traceId;
        ++this.numTracesFailed;
        ++this.numTracesProcessed;
    }

    public final int getSuccessCount() {
        return this.numTracesSucceeded;
    }

    public final int getErrorCount() {
        return this.numTracesFailed;
    }

    public final int getTotalCount() {
        return this.numTracesProcessed;
    }

    public final long getLastTraceIdError() {
        return this.lastTraceIdError;
    }

    public final long getLastTraceIdSuccess() {
        return this.lastTraceIdSuccess;
    }

    public void printStatusMessage() {
        this.printMessage(new String[]{"Trace processing summary: " + this.numTracesProcessed + " total; " + this.numTracesSucceeded + " succeeded; " + this.numTracesFailed + " failed."});
    }
}

