/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.traceAnalysis.filter.flow;

import java.util.Stack;
import kieker.analysis.plugin.annotation.InputPort;
import kieker.analysis.plugin.annotation.OutputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.Property;
import kieker.analysis.plugin.annotation.RepositoryPort;
import kieker.analysis.plugin.filter.flow.TraceEventRecords;
import kieker.common.configuration.Configuration;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.common.record.flow.trace.AbstractTraceEvent;
import kieker.common.record.flow.trace.Trace;
import kieker.common.record.flow.trace.concurrency.SplitEvent;
import kieker.common.record.flow.trace.operation.AbstractOperationEvent;
import kieker.common.record.flow.trace.operation.AfterOperationEvent;
import kieker.common.record.flow.trace.operation.AfterOperationFailedEvent;
import kieker.common.record.flow.trace.operation.BeforeOperationEvent;
import kieker.common.record.flow.trace.operation.CallOperationEvent;
import kieker.common.record.flow.trace.operation.constructor.AfterConstructorEvent;
import kieker.common.record.flow.trace.operation.constructor.AfterConstructorFailedEvent;
import kieker.common.record.flow.trace.operation.constructor.BeforeConstructorEvent;
import kieker.common.record.flow.trace.operation.constructor.CallConstructorEvent;
import kieker.common.util.ClassOperationSignaturePair;
import kieker.common.util.Signature;
import kieker.tools.traceAnalysis.filter.AbstractTraceAnalysisFilter;
import kieker.tools.traceAnalysis.filter.AbstractTraceProcessingFilter;
import kieker.tools.traceAnalysis.filter.traceReconstruction.InvalidTraceException;
import kieker.tools.traceAnalysis.systemModel.Execution;
import kieker.tools.traceAnalysis.systemModel.ExecutionTrace;
import kieker.tools.traceAnalysis.systemModel.MessageTrace;
import kieker.tools.traceAnalysis.systemModel.repository.SystemModelRepository;

@Plugin(description="Transforms incoming TraceEventRecords into execution and message traces", outputPorts={@OutputPort(name="executionTrace", description="Outputs transformed execution traces", eventTypes={ExecutionTrace.class}), @OutputPort(name="messageTrace", description="Outputs transformed message traces", eventTypes={MessageTrace.class})}, repositoryPorts={@RepositoryPort(name="systemModelRepository", repositoryType=SystemModelRepository.class)}, configuration={@Property(name="enhanceJavaConstructors", defaultValue="true"), @Property(name="enhanceCallDetection", defaultValue="true")})
public class TraceEventRecords2ExecutionAndMessageTraceFilter
extends AbstractTraceProcessingFilter {
    public static final String INPUT_PORT_NAME_EVENT_TRACE = "traceEvents";
    public static final String OUTPUT_PORT_NAME_EXECUTION_TRACE = "executionTrace";
    public static final String OUTPUT_PORT_NAME_MESSAGE_TRACE = "messageTrace";
    public static final String CONFIG_ENHANCE_JAVA_CONSTRUCTORS = "enhanceJavaConstructors";
    public static final String CONFIG_ENHANCE_CALL_DETECTION = "enhanceCallDetection";
    private static final Log LOG = LogFactory.getLog(TraceEventRecords2ExecutionAndMessageTraceFilter.class);
    private final boolean enhanceJavaConstructors;
    private final boolean enhanceCallDetection;

    public TraceEventRecords2ExecutionAndMessageTraceFilter(Configuration configuration) {
        super(configuration);
        this.enhanceJavaConstructors = configuration.getBooleanProperty(CONFIG_ENHANCE_JAVA_CONSTRUCTORS);
        this.enhanceCallDetection = configuration.getBooleanProperty(CONFIG_ENHANCE_CALL_DETECTION);
    }

    public Configuration getCurrentConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setProperty(CONFIG_ENHANCE_JAVA_CONSTRUCTORS, String.valueOf(this.enhanceJavaConstructors));
        configuration.setProperty(CONFIG_ENHANCE_CALL_DETECTION, String.valueOf(this.enhanceCallDetection));
        return configuration;
    }

    @InputPort(name="traceEvents", description="Receives TraceEvents to be transformed", eventTypes={TraceEventRecords.class})
    public void inputTraceEvents(TraceEventRecords traceEventRecords) {
        Trace trace = traceEventRecords.getTrace();
        if (trace == null) {
            LOG.error("Trace is missing from TraceEvents");
            return;
        }
        long traceId = trace.getTraceId();
        ExecutionTrace executionTrace = new ExecutionTrace(traceId, trace.getSessionId());
        TraceEventRecordHandler traceEventRecordHandler = new TraceEventRecordHandler(trace, executionTrace, this.getSystemEntityFactory(), this.enhanceJavaConstructors, this.enhanceCallDetection);
        int expectedOrderIndex = -1;
        for (AbstractTraceEvent event : traceEventRecords.getTraceEvents()) {
            if (event.getOrderIndex() != ++expectedOrderIndex) {
                LOG.error("Found event with wrong orderIndex. Found: " + event.getOrderIndex() + " expected: " + (expectedOrderIndex - 1));
                continue;
            }
            if (event.getTraceId() != traceId) {
                LOG.error("Found event with wrong traceId. Found: " + event.getTraceId() + " expected: " + traceId);
                continue;
            }
            try {
                if (BeforeOperationEvent.class.equals(event.getClass())) {
                    traceEventRecordHandler.handleBeforeOperationEvent((BeforeOperationEvent)event);
                    continue;
                }
                if (AfterOperationEvent.class.equals(event.getClass())) {
                    traceEventRecordHandler.handleAfterOperationEvent((AfterOperationEvent)event);
                    continue;
                }
                if (AfterOperationFailedEvent.class.equals(event.getClass())) {
                    traceEventRecordHandler.handleAfterOperationEvent((AfterOperationFailedEvent)event);
                    continue;
                }
                if (BeforeConstructorEvent.class.equals(event.getClass())) {
                    traceEventRecordHandler.handleBeforeConstructorEvent((BeforeConstructorEvent)event);
                    continue;
                }
                if (AfterConstructorEvent.class.equals(event.getClass())) {
                    traceEventRecordHandler.handleAfterConstructorEvent((AfterConstructorEvent)event);
                    continue;
                }
                if (AfterConstructorFailedEvent.class.equals(event.getClass())) {
                    traceEventRecordHandler.handleAfterConstructorEvent((AfterConstructorFailedEvent)event);
                    continue;
                }
                if (CallOperationEvent.class.equals(event.getClass())) {
                    traceEventRecordHandler.handleCallOperationEvent((CallOperationEvent)event);
                    continue;
                }
                if (CallConstructorEvent.class.equals(event.getClass())) {
                    traceEventRecordHandler.handleCallOperationEvent((CallConstructorEvent)event);
                    continue;
                }
                if (SplitEvent.class.equals(event.getClass())) {
                    LOG.warn("Events of type 'SplitEvent' are currently not handled and ignored.");
                    continue;
                }
                LOG.warn("Events of type '" + event.getClass().getName() + "' are currently not handled and ignored.");
            }
            catch (InvalidTraceException ex) {
                LOG.error("Failed to reconstruct trace.", ex);
                return;
            }
        }
        super.deliver(OUTPUT_PORT_NAME_EXECUTION_TRACE, executionTrace);
        try {
            super.deliver(OUTPUT_PORT_NAME_MESSAGE_TRACE, executionTrace.toMessageTrace(SystemModelRepository.ROOT_EXECUTION));
            super.reportSuccess(executionTrace.getTraceId());
        }
        catch (InvalidTraceException ex) {
            LOG.warn("Failed to convert to message trace: " + ex.getMessage());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TraceEventRecordHandler {
        private final SystemModelRepository systemModelRepository;
        private final Trace trace;
        private final ExecutionTrace executionTrace;
        private final Stack<AbstractTraceEvent> eventStack = new Stack();
        private final Stack<ExecutionInformation> executionStack = new Stack();
        private final boolean enhanceJavaConstructors;
        private final boolean enhanceCallDetection;
        private int orderindex;

        public TraceEventRecordHandler(Trace trace, ExecutionTrace executionTrace, SystemModelRepository systemModelRepository, boolean enhanceJavaConstructors, boolean enhanceCallDetection) {
            this.trace = trace;
            this.executionTrace = executionTrace;
            this.systemModelRepository = systemModelRepository;
            this.enhanceJavaConstructors = enhanceJavaConstructors;
            this.enhanceCallDetection = enhanceCallDetection;
        }

        private AbstractTraceEvent peekEvent() {
            if (this.eventStack.isEmpty()) {
                return null;
            }
            return this.eventStack.peek();
        }

        private void registerExecution(AbstractTraceEvent cause) {
            this.eventStack.push(cause);
            ExecutionInformation executionInformation = new ExecutionInformation(this.orderindex++, this.executionStack.size());
            this.executionStack.push(executionInformation);
        }

        private void finishExecution(String operationSignature, String classSignature, long traceId, String sessionId, String hostname, int eoi, int ess, long tin, long tout, boolean assumed, boolean constructor) throws InvalidTraceException {
            ClassOperationSignaturePair fqComponentNameSignaturePair = ClassOperationSignaturePair.splitOperationSignatureStr(operationSignature, constructor && this.enhanceJavaConstructors);
            String executionContext = classSignature.length() == 0 ? fqComponentNameSignaturePair.getFqClassname() : classSignature;
            Execution execution = AbstractTraceAnalysisFilter.createExecutionByEntityNames(this.systemModelRepository, hostname, executionContext, fqComponentNameSignaturePair.getFqClassname(), fqComponentNameSignaturePair.getSignature(), traceId, sessionId, eoi, ess, tin, tout, assumed);
            try {
                this.executionTrace.add(execution);
            }
            catch (InvalidTraceException ex) {
                throw new InvalidTraceException("Failed to add execution " + execution + " to trace " + this.executionTrace + ".", ex);
            }
        }

        private void closeOpenCalls(AbstractOperationEvent lastEvent) throws InvalidTraceException {
            AbstractTraceEvent prevEvent;
            Stack<CallOperationEvent> tmpEventStack = new Stack<CallOperationEvent>();
            Stack<ExecutionInformation> tmpExecutionStack = new Stack<ExecutionInformation>();
            while (!this.eventStack.isEmpty() && (prevEvent = this.eventStack.peek()) instanceof CallOperationEvent) {
                tmpEventStack.push((CallOperationEvent)this.eventStack.pop());
                tmpExecutionStack.push(this.executionStack.pop());
                if (!lastEvent.getOperationSignature().equals(((CallOperationEvent)prevEvent).getOperationSignature())) continue;
                while (!tmpEventStack.isEmpty()) {
                    CallOperationEvent currentCallEvent = (CallOperationEvent)tmpEventStack.pop();
                    ExecutionInformation executionInformation = (ExecutionInformation)tmpExecutionStack.pop();
                    this.finishExecution(currentCallEvent.getCalleeOperationSignature(), currentCallEvent.getCalleeClassSignature(), this.trace.getTraceId(), this.trace.getSessionId(), this.trace.getHostname(), executionInformation.getEoi(), executionInformation.getEss(), currentCallEvent.getTimestamp(), lastEvent.getTimestamp(), true, currentCallEvent instanceof CallConstructorEvent);
                }
                return;
            }
            while (!tmpEventStack.isEmpty()) {
                this.eventStack.push((AbstractTraceEvent)tmpEventStack.pop());
                this.executionStack.push((ExecutionInformation)tmpExecutionStack.pop());
            }
        }

        private void handleBeforeEvent(BeforeOperationEvent beforeOperationEvent, Class<? extends CallOperationEvent> callClass) throws InvalidTraceException {
            AbstractTraceEvent prevEvent = this.peekEvent();
            if (this.isPrevEventMatchingCall(beforeOperationEvent, prevEvent, callClass)) {
                this.eventStack.push(beforeOperationEvent);
            } else {
                this.closeOpenCalls(beforeOperationEvent);
                this.registerExecution(beforeOperationEvent);
            }
        }

        public void handleBeforeOperationEvent(BeforeOperationEvent beforeOperationEvent) throws InvalidTraceException {
            this.handleBeforeEvent(beforeOperationEvent, CallOperationEvent.class);
        }

        public void handleBeforeConstructorEvent(BeforeConstructorEvent beforeConstructorEvent) throws InvalidTraceException {
            this.handleBeforeEvent(beforeConstructorEvent, CallConstructorEvent.class);
        }

        private boolean isPrevEventMatchingCall(BeforeOperationEvent beforeOperationEvent, AbstractTraceEvent prevEvent, Class<? extends CallOperationEvent> callClass) {
            if (prevEvent != null && prevEvent.getClass().equals(callClass) && prevEvent.getOrderIndex() == beforeOperationEvent.getOrderIndex() - 1) {
                if (((CallOperationEvent)prevEvent).callsReferencedOperationOf(beforeOperationEvent)) {
                    return true;
                }
                if (this.enhanceCallDetection) {
                    Signature afterSignature;
                    boolean isConstructor = beforeOperationEvent instanceof BeforeConstructorEvent;
                    CallOperationEvent callEvent = (CallOperationEvent)prevEvent;
                    Signature callSignature = ClassOperationSignaturePair.splitOperationSignatureStr(callEvent.getCalleeOperationSignature(), isConstructor && this.enhanceJavaConstructors).getSignature();
                    if (callSignature.equals(afterSignature = ClassOperationSignaturePair.splitOperationSignatureStr(beforeOperationEvent.getOperationSignature(), isConstructor && this.enhanceJavaConstructors).getSignature()) && callEvent.getCalleeClassSignature().equals(beforeOperationEvent.getClassSignature())) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Guessed call of \n\t" + callEvent + "\n\t" + beforeOperationEvent);
                        }
                        return true;
                    }
                }
            }
            return false;
        }

        private void handleAfterEvent(AfterOperationEvent afterOperationEvent, Class<? extends BeforeOperationEvent> beforeClass, Class<? extends CallOperationEvent> callClass) throws InvalidTraceException {
            boolean definiteCall;
            this.closeOpenCalls(afterOperationEvent);
            AbstractTraceEvent potentialBeforeEvent = this.peekEvent();
            if (potentialBeforeEvent == null || !potentialBeforeEvent.getClass().equals(beforeClass)) {
                throw new InvalidTraceException("Didn't find corresponding " + beforeClass.getName() + " for " + afterOperationEvent.getClass().getName() + " " + afterOperationEvent.toString() + " (found: " + potentialBeforeEvent + ").");
            }
            if (!afterOperationEvent.refersToSameOperationAs((BeforeOperationEvent)potentialBeforeEvent)) {
                throw new InvalidTraceException("Components of before (" + potentialBeforeEvent + ") " + "and after (" + afterOperationEvent + ") events do not match.");
            }
            BeforeOperationEvent beforeOperationEvent = (BeforeOperationEvent)this.eventStack.pop();
            AbstractTraceEvent prevEvent = this.peekEvent();
            boolean bl = definiteCall = prevEvent == null || this.isPrevEventMatchingCall(beforeOperationEvent, prevEvent, callClass);
            if (definiteCall && !this.eventStack.isEmpty()) {
                this.eventStack.pop();
            }
            ExecutionInformation executionInformation = this.executionStack.pop();
            this.finishExecution(beforeOperationEvent.getOperationSignature(), beforeOperationEvent.getClassSignature(), this.trace.getTraceId(), this.trace.getSessionId(), this.trace.getHostname(), executionInformation.getEoi(), executionInformation.getEss(), beforeOperationEvent.getTimestamp(), afterOperationEvent.getTimestamp(), !definiteCall, beforeOperationEvent instanceof BeforeConstructorEvent);
        }

        public void handleAfterOperationEvent(AfterOperationEvent afterOperationEvent) throws InvalidTraceException {
            this.handleAfterEvent(afterOperationEvent, BeforeOperationEvent.class, CallOperationEvent.class);
        }

        public void handleAfterConstructorEvent(AfterConstructorEvent afterConstructorEvent) throws InvalidTraceException {
            this.handleAfterEvent(afterConstructorEvent, BeforeConstructorEvent.class, CallConstructorEvent.class);
        }

        public void handleCallOperationEvent(CallOperationEvent callOperationEvent) throws InvalidTraceException {
            this.closeOpenCalls(callOperationEvent);
            this.registerExecution(callOperationEvent);
        }

        private static class ExecutionInformation {
            private final int eoi;
            private final int ess;

            public ExecutionInformation(int executionIndex, int stackDepth) {
                this.eoi = executionIndex;
                this.ess = stackDepth;
            }

            public int getEoi() {
                return this.eoi;
            }

            public int getEss() {
                return this.ess;
            }
        }
    }
}

