/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.traceAnalysis.filter.systemModel;

import java.io.File;
import java.io.IOException;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.Property;
import kieker.analysis.plugin.annotation.RepositoryPort;
import kieker.common.configuration.Configuration;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.tools.traceAnalysis.filter.AbstractTraceAnalysisFilter;
import kieker.tools.traceAnalysis.systemModel.repository.SystemModelRepository;

@Plugin(description="Prints the contents of a connected SystemModelRepository to an HTML file", repositoryPorts={@RepositoryPort(name="systemModelRepository", repositoryType=SystemModelRepository.class)}, configuration={@Property(name="outputFnHtml", defaultValue="system-model.html")})
public class SystemModel2FileFilter
extends AbstractTraceAnalysisFilter {
    public static final String CONFIG_PROPERTY_NAME_HTML_OUTPUT_FN = "outputFnHtml";
    protected static final String DEFAULT_HTML_OUTPUT_FN = "system-model.html";
    private static final Log LOG = LogFactory.getLog(SystemModel2FileFilter.class);
    private final String outputFnHTML;

    public SystemModel2FileFilter(Configuration configuration) {
        super(configuration);
        this.outputFnHTML = configuration.getPathProperty(CONFIG_PROPERTY_NAME_HTML_OUTPUT_FN);
    }

    public Configuration getCurrentConfiguration() {
        Configuration currentConfiguration = new Configuration();
        currentConfiguration.setProperty(CONFIG_PROPERTY_NAME_HTML_OUTPUT_FN, this.outputFnHTML);
        return currentConfiguration;
    }

    public void terminate(boolean errorBeforeTermination) {
        String outputFnHTMLCanonical = this.outputFnHTML;
        boolean error = errorBeforeTermination;
        if (!error) {
            try {
                File outputFileHTML = new File(this.outputFnHTML);
                outputFnHTMLCanonical = outputFileHTML.getCanonicalPath();
                SystemModelRepository sysModelRepo = super.getSystemEntityFactory();
                if (sysModelRepo == null) {
                    String errorMsg = "Failed to get system model repository";
                    LOG.error("Failed to get system model repository");
                    error = true;
                } else {
                    sysModelRepo.saveSystemToHTMLFile(outputFnHTMLCanonical);
                }
            }
            catch (IOException e) {
                String errorMsg = "Failed to save system model to file " + outputFnHTMLCanonical;
                LOG.error(errorMsg, e);
                error = true;
            }
        }
        if (!error) {
            this.printMessage(new String[]{"Wrote HTML output of system model to file '" + outputFnHTMLCanonical + "'"});
        } else {
            this.printMessage(new String[]{"Failed to write HTML output of system model to file '" + outputFnHTMLCanonical + "'"});
        }
    }
}

