/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.traceAnalysis.filter.traceReconstruction;

import java.util.Comparator;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import kieker.analysis.plugin.annotation.InputPort;
import kieker.analysis.plugin.annotation.OutputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.Property;
import kieker.analysis.plugin.annotation.RepositoryPort;
import kieker.common.configuration.Configuration;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.tools.traceAnalysis.filter.AbstractTraceProcessingFilter;
import kieker.tools.traceAnalysis.filter.executionRecordTransformation.ExecutionEventProcessingException;
import kieker.tools.traceAnalysis.filter.traceReconstruction.InvalidTraceException;
import kieker.tools.traceAnalysis.systemModel.Execution;
import kieker.tools.traceAnalysis.systemModel.ExecutionTrace;
import kieker.tools.traceAnalysis.systemModel.InvalidExecutionTrace;
import kieker.tools.traceAnalysis.systemModel.MessageTrace;
import kieker.tools.traceAnalysis.systemModel.repository.SystemModelRepository;
import kieker.tools.util.LoggingTimestampConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Plugin(description="Uses the incoming data to enrich the connected repository with the reconstructed traces", outputPorts={@OutputPort(name="messageTraces", description="Reconstructed Message Traces", eventTypes={MessageTrace.class}), @OutputPort(name="executionTraces", description="Reconstructed Execution Traces", eventTypes={ExecutionTrace.class}), @OutputPort(name="invalidExecutionTraces", description="Invalid Execution Traces", eventTypes={InvalidExecutionTrace.class})}, repositoryPorts={@RepositoryPort(name="systemModelRepository", repositoryType=SystemModelRepository.class)}, configuration={@Property(name="maxTraceDurationMillis", defaultValue="2147483647"), @Property(name="ignoreInvalidTraces", defaultValue="true")})
public class TraceReconstructionFilter
extends AbstractTraceProcessingFilter {
    public static final String INPUT_PORT_NAME_EXECUTIONS = "executions";
    public static final String OUTPUT_PORT_NAME_MESSAGE_TRACE = "messageTraces";
    public static final String OUTPUT_PORT_NAME_EXECUTION_TRACE = "executionTraces";
    public static final String OUTPUT_PORT_NAME_INVALID_EXECUTION_TRACE = "invalidExecutionTraces";
    public static final String CONFIG_PROPERTY_NAME_MAX_TRACE_DURATION_MILLIS = "maxTraceDurationMillis";
    public static final String CONFIG_PROPERTY_NAME_IGNORE_INVALID_TRACES = "ignoreInvalidTraces";
    private static final long CONFIG_PROPERTY_VALUE_MAX_DURATION_NANOS = Long.MAX_VALUE;
    private static final Log LOG = LogFactory.getLog(TraceReconstructionFilter.class);
    private final Map<Long, ExecutionTrace> pendingTraces = new Hashtable<Long, ExecutionTrace>();
    private final Set<Long> invalidTraces = new TreeSet<Long>();
    private volatile long minTin = -1L;
    private volatile long maxTout = -1L;
    private volatile boolean terminated;
    private final boolean ignoreInvalidTraces;
    private final long maxTraceDurationNanos;
    private final long maxTraceDurationMillis;
    private boolean traceProcessingErrorOccured;
    private final SortedSet<ExecutionTrace> timeoutMap = new TreeSet<ExecutionTrace>(new Comparator<ExecutionTrace>(){

        @Override
        public int compare(ExecutionTrace t1, ExecutionTrace t2) {
            long t2LowestTin;
            if (t1 == t2) {
                return 0;
            }
            long t1LowestTin = t1.getTraceAsSortedExecutionSet().first().getTin();
            if (t1LowestTin != (t2LowestTin = t2.getTraceAsSortedExecutionSet().first().getTin())) {
                return t1LowestTin < t2LowestTin ? -1 : 1;
            }
            return t1.getTraceId() < t2.getTraceId() ? -1 : 1;
        }
    });

    public TraceReconstructionFilter(Configuration configuration) {
        super(configuration);
        this.maxTraceDurationMillis = configuration.getLongProperty(CONFIG_PROPERTY_NAME_MAX_TRACE_DURATION_MILLIS);
        this.ignoreInvalidTraces = configuration.getBooleanProperty(CONFIG_PROPERTY_NAME_IGNORE_INVALID_TRACES);
        if (this.maxTraceDurationMillis < 0L) {
            throw new IllegalArgumentException("value maxTraceDurationMillis must not be negative (found: " + this.maxTraceDurationMillis + ")");
        }
        this.maxTraceDurationNanos = this.maxTraceDurationMillis == Integer.MAX_VALUE ? Long.MAX_VALUE : this.maxTraceDurationMillis * 1000000L;
    }

    public Set<Long> getInvalidTraces() {
        return this.invalidTraces;
    }

    public final long getMinTin() {
        return this.minTin;
    }

    public final long getMaxTout() {
        return this.maxTout;
    }

    @Override
    public boolean init() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InputPort(name="executions", description="Receives the executions to be processed", eventTypes={Execution.class})
    public void inputExecutions(Execution execution) {
        TraceReconstructionFilter traceReconstructionFilter = this;
        synchronized (traceReconstructionFilter) {
            if (this.terminated || this.traceProcessingErrorOccured && !this.ignoreInvalidTraces) {
                return;
            }
            long traceId = execution.getTraceId();
            this.minTin = this.minTin < 0L || execution.getTin() < this.minTin ? execution.getTin() : this.minTin;
            this.maxTout = execution.getTout() > this.maxTout ? execution.getTout() : this.maxTout;
            ExecutionTrace executionTrace = this.pendingTraces.get(traceId);
            if (executionTrace != null) {
                if (!this.timeoutMap.remove(executionTrace)) {
                    LOG.error("Missing entry for trace in timeoutMap: " + executionTrace + " PendingTraces and timeoutMap are now longer consistent!");
                    this.reportError(traceId);
                }
            } else {
                executionTrace = new ExecutionTrace(traceId, execution.getSessionId());
                this.pendingTraces.put(traceId, executionTrace);
            }
            try {
                executionTrace.add(execution);
                if (!this.timeoutMap.add(executionTrace)) {
                    LOG.error("Equal entry existed in timeoutMap already:" + executionTrace);
                }
                this.processTimeoutQueue();
            }
            catch (InvalidTraceException ex) {
                LOG.error("Attempt to add record to wrong trace", ex);
            }
            catch (ExecutionEventProcessingException ex) {
                LOG.error("ExecutionEventProcessingException occured while processing the timeout queue.", ex);
            }
        }
    }

    private void processExecutionTrace(ExecutionTrace executionTrace) throws ExecutionEventProcessingException {
        long curTraceId = executionTrace.getTraceId();
        try {
            MessageTrace mt = executionTrace.toMessageTrace(SystemModelRepository.ROOT_EXECUTION);
            if (!this.invalidTraces.contains(mt.getTraceId())) {
                super.deliver(OUTPUT_PORT_NAME_MESSAGE_TRACE, mt);
                super.deliver(OUTPUT_PORT_NAME_EXECUTION_TRACE, executionTrace);
                this.reportSuccess(curTraceId);
            } else {
                super.deliver(OUTPUT_PORT_NAME_INVALID_EXECUTION_TRACE, new InvalidExecutionTrace(executionTrace));
            }
        }
        catch (InvalidTraceException ex) {
            super.deliver(OUTPUT_PORT_NAME_INVALID_EXECUTION_TRACE, new InvalidExecutionTrace(executionTrace));
            String transformationError = "Failed to transform execution trace to message trace (ID: " + curTraceId + "). \n" + "Reason: " + ex.getMessage() + "\n Trace: " + executionTrace;
            if (!this.invalidTraces.contains(curTraceId)) {
                this.reportError(curTraceId);
                this.invalidTraces.add(curTraceId);
                if (!this.ignoreInvalidTraces) {
                    this.traceProcessingErrorOccured = true;
                    LOG.warn("Note that this filter was configured to terminate at the *first* occurence of an invalid trace \nIf this is not the desired behavior, set the configuration property ignoreInvalidTraces to 'true'");
                    throw new ExecutionEventProcessingException(transformationError, ex);
                }
                LOG.error(transformationError);
            }
            LOG.warn("Found additional fragment for trace already marked invalid: " + transformationError);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTimeoutQueue() throws ExecutionEventProcessingException {
        SortedSet<ExecutionTrace> sortedSet = this.timeoutMap;
        synchronized (sortedSet) {
            while (!this.timeoutMap.isEmpty() && (this.terminated || this.maxTout - this.timeoutMap.first().getMinTin() > this.maxTraceDurationNanos)) {
                ExecutionTrace polledTrace = this.timeoutMap.first();
                this.timeoutMap.remove(polledTrace);
                long curTraceId = polledTrace.getTraceId();
                this.pendingTraces.remove(curTraceId);
                this.processExecutionTrace(polledTrace);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getMaxTraceDurationNanos() {
        TraceReconstructionFilter traceReconstructionFilter = this;
        synchronized (traceReconstructionFilter) {
            return this.maxTraceDurationNanos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminate(boolean error) {
        TraceReconstructionFilter traceReconstructionFilter = this;
        synchronized (traceReconstructionFilter) {
            try {
                this.terminated = true;
                if (!error || this.traceProcessingErrorOccured && !this.ignoreInvalidTraces) {
                    this.processTimeoutQueue();
                } else {
                    LOG.info("terminate called with error an flag set or a trace processing occurred; won't process timeoutqueue any more.");
                }
            }
            catch (ExecutionEventProcessingException ex) {
                this.traceProcessingErrorOccured = true;
                LOG.error("Error processing timeout queue", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStatusMessage() {
        TraceReconstructionFilter traceReconstructionFilter = this;
        synchronized (traceReconstructionFilter) {
            super.printStatusMessage();
            if (this.getSuccessCount() > 0 || this.getErrorCount() > 0) {
                String minTinStr = this.minTin + " (" + LoggingTimestampConverter.convertLoggingTimestampToUTCString(this.minTin) + "," + LoggingTimestampConverter.convertLoggingTimestampLocalTimeZoneString(this.minTin) + ")";
                String maxToutStr = this.maxTout + " (" + LoggingTimestampConverter.convertLoggingTimestampToUTCString(this.maxTout) + "," + LoggingTimestampConverter.convertLoggingTimestampLocalTimeZoneString(this.maxTout) + ")";
                this.stdOutPrintln("First timestamp: " + minTinStr);
                this.stdOutPrintln("Last timestamp: " + maxToutStr);
            }
        }
    }

    @Override
    public Configuration getCurrentConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setProperty(CONFIG_PROPERTY_NAME_MAX_TRACE_DURATION_MILLIS, Long.toString(this.maxTraceDurationMillis));
        configuration.setProperty(CONFIG_PROPERTY_NAME_IGNORE_INVALID_TRACES, Boolean.toString(this.ignoreInvalidTraces));
        return configuration;
    }
}

