/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.traceAnalysis.filter.traceWriter;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import kieker.analysis.plugin.annotation.InputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.Property;
import kieker.analysis.plugin.annotation.RepositoryPort;
import kieker.analysis.plugin.filter.AbstractFilterPlugin;
import kieker.common.configuration.Configuration;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.tools.traceAnalysis.filter.AbstractExecutionTraceProcessingFilter;
import kieker.tools.traceAnalysis.systemModel.ExecutionTrace;
import kieker.tools.traceAnalysis.systemModel.repository.SystemModelRepository;

@Plugin(description="A filter allowing to write the incoming ExecutionTraces into a configured file", repositoryPorts={@RepositoryPort(name="systemModelRepository", repositoryType=SystemModelRepository.class)}, configuration={@Property(name="outputFn", defaultValue="invalidTraceArtifacts-yyyyMMdd-HHmmssSSS.txt")})
public class ExecutionTraceWriterFilter
extends AbstractExecutionTraceProcessingFilter {
    public static final String INPUT_PORT_NAME_EXECUTION_TRACES = "executionTraces";
    public static final String CONFIG_PROPERTY_NAME_OUTPUT_FN = "outputFn";
    private static final Log LOG = LogFactory.getLog(ExecutionTraceWriterFilter.class);
    private static final String ENCODING = "UTF-8";
    private final String outputFn;
    private final BufferedWriter ps;

    public ExecutionTraceWriterFilter(Configuration configuration) throws IOException {
        super(configuration);
        this.outputFn = configuration.getStringProperty(CONFIG_PROPERTY_NAME_OUTPUT_FN);
        this.ps = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.outputFn), ENCODING));
    }

    public void printStatusMessage() {
        super.printStatusMessage();
        int numTraces = this.getSuccessCount();
        this.stdOutPrintln("Wrote " + numTraces + " execution trace" + (numTraces > 1 ? "s" : "") + " to file '" + this.outputFn + "'");
    }

    public void terminate(boolean error) {
        if (this.ps != null) {
            try {
                this.ps.close();
            }
            catch (IOException ex) {
                LOG.error("IOException while terminating", ex);
            }
        }
    }

    @InputPort(name="executionTraces", description="Receives the execution traces to be written", eventTypes={ExecutionTrace.class})
    public void newExecutionTrace(ExecutionTrace et) {
        try {
            this.ps.append(et.toString()).append(AbstractFilterPlugin.SYSTEM_NEWLINE_STRING);
            this.reportSuccess(et.getTraceId());
        }
        catch (IOException ex) {
            this.reportError(et.getTraceId());
            LOG.error("IOException", ex);
        }
    }

    public Configuration getCurrentConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setProperty(CONFIG_PROPERTY_NAME_OUTPUT_FN, this.outputFn);
        return configuration;
    }
}

