/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.traceAnalysis.filter.traceWriter;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import kieker.analysis.plugin.annotation.InputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.Property;
import kieker.analysis.plugin.annotation.RepositoryPort;
import kieker.analysis.plugin.filter.AbstractFilterPlugin;
import kieker.common.configuration.Configuration;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.tools.traceAnalysis.filter.AbstractMessageTraceProcessingFilter;
import kieker.tools.traceAnalysis.systemModel.MessageTrace;
import kieker.tools.traceAnalysis.systemModel.repository.SystemModelRepository;

@Plugin(description="A filter allowing to write the incoming MessageTraces into a configured file", repositoryPorts={@RepositoryPort(name="systemModelRepository", repositoryType=SystemModelRepository.class)}, configuration={@Property(name="outputFn", defaultValue="messageTraces-yyyyMMdd-HHmmssSSS.txt")})
public class MessageTraceWriterFilter
extends AbstractMessageTraceProcessingFilter {
    public static final String CONFIG_PROPERTY_NAME_OUTPUT_FN = "outputFn";
    private static final Log LOG = LogFactory.getLog(MessageTraceWriterFilter.class);
    private static final String ENCODING = "UTF-8";
    private final String outputFn;
    private final BufferedWriter ps;

    public MessageTraceWriterFilter(Configuration configuration) throws IOException {
        super(configuration);
        this.outputFn = this.configuration.getStringProperty(CONFIG_PROPERTY_NAME_OUTPUT_FN);
        this.ps = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.outputFn), ENCODING));
    }

    public void printStatusMessage() {
        super.printStatusMessage();
        int numTraces = this.getSuccessCount();
        this.stdOutPrintln("Wrote " + numTraces + " trace" + (numTraces > 1 ? "s" : "") + " to file '" + this.outputFn + "'");
    }

    public void terminate(boolean error) {
        if (this.ps != null) {
            try {
                this.ps.close();
            }
            catch (IOException ex) {
                LOG.error("IOException while terminating", ex);
            }
        }
    }

    public Configuration getCurrentConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setProperty(CONFIG_PROPERTY_NAME_OUTPUT_FN, this.outputFn);
        return configuration;
    }

    @InputPort(name="messageTraces", description="Receives message traces to be processed", eventTypes={MessageTrace.class})
    public void inputMessageTraces(MessageTrace mt) {
        try {
            this.ps.append(mt.toString()).append(AbstractFilterPlugin.SYSTEM_NEWLINE_STRING);
            this.reportSuccess(mt.getTraceId());
        }
        catch (IOException ex) {
            LOG.error("IOException", ex);
            this.reportError(mt.getTraceId());
        }
    }
}

