/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.traceAnalysis.filter.visualization;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kieker.analysis.plugin.annotation.InputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.Property;
import kieker.analysis.plugin.filter.AbstractFilterPlugin;
import kieker.common.configuration.Configuration;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.tools.traceAnalysis.filter.visualization.AbstractGraphFormatter;
import kieker.tools.traceAnalysis.filter.visualization.GraphWriterConfiguration;
import kieker.tools.traceAnalysis.filter.visualization.dependencyGraph.ComponentAllocationDependencyGraph;
import kieker.tools.traceAnalysis.filter.visualization.dependencyGraph.ComponentAllocationDependencyGraphFormatter;
import kieker.tools.traceAnalysis.filter.visualization.dependencyGraph.ComponentAssemblyDependencyGraph;
import kieker.tools.traceAnalysis.filter.visualization.dependencyGraph.ComponentAssemblyDependencyGraphFormatter;
import kieker.tools.traceAnalysis.filter.visualization.dependencyGraph.ContainerDependencyGraph;
import kieker.tools.traceAnalysis.filter.visualization.dependencyGraph.ContainerDependencyGraphFormatter;
import kieker.tools.traceAnalysis.filter.visualization.dependencyGraph.OperationAllocationDependencyGraph;
import kieker.tools.traceAnalysis.filter.visualization.dependencyGraph.OperationAllocationDependencyGraphFormatter;
import kieker.tools.traceAnalysis.filter.visualization.dependencyGraph.OperationAssemblyDependencyGraph;
import kieker.tools.traceAnalysis.filter.visualization.dependencyGraph.OperationAssemblyDependencyGraphFormatter;
import kieker.tools.traceAnalysis.filter.visualization.exception.GraphFormattingException;
import kieker.tools.traceAnalysis.filter.visualization.graph.AbstractGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Plugin(name="Graph writer plugin", description="Generic plugin for writing graphs to files", configuration={@Property(name="includeWeights", defaultValue="true"), @Property(name="shortLabels", defaultValue="true"), @Property(name="selfLoops", defaultValue="false")})
public class GraphWriterPlugin
extends AbstractFilterPlugin {
    public static final String INPUT_PORT_NAME_GRAPHS = "inputGraph";
    private static final Log LOG = LogFactory.getLog(GraphWriterPlugin.class);
    private static final String ENCODING = "UTF-8";
    private static final String NO_SUITABLE_FORMATTER_MESSAGE_TEMPLATE = "No formatter type defined for graph type %s.";
    private static final String INSTANTIATION_ERROR_MESSAGE_TEMPLATE = "Could not instantiate formatter type %s for graph type %s.";
    private static final String WRITE_ERROR_MESSAGE_TEMPLATE = "Graph could not be written to file %s.";
    private static final ConcurrentMap<Class<? extends AbstractGraph<?, ?, ?>>, Class<? extends AbstractGraphFormatter<?>>> FORMATTER_REGISTRY = new ConcurrentHashMap();
    private final GraphWriterConfiguration gConfiguration;

    public GraphWriterPlugin(Configuration configuration) {
        super(configuration);
        this.gConfiguration = new GraphWriterConfiguration(configuration);
    }

    @Override
    public Configuration getCurrentConfiguration() {
        return this.gConfiguration.getConfiguration();
    }

    private static void handleInstantiationException(Class<?> graphClass, Class<?> formatterClass, Exception exception) {
        throw new GraphFormattingException(String.format(INSTANTIATION_ERROR_MESSAGE_TEMPLATE, formatterClass.getName(), graphClass.getName()), exception);
    }

    private static AbstractGraphFormatter<?> createFormatter(AbstractGraph<?, ?, ?> graph) {
        Class formatterClass = (Class)FORMATTER_REGISTRY.get(graph.getClass());
        if (formatterClass == null) {
            throw new GraphFormattingException(String.format(NO_SUITABLE_FORMATTER_MESSAGE_TEMPLATE, graph.getClass().getName()));
        }
        try {
            Constructor constructor = formatterClass.getConstructor(new Class[0]);
            return (AbstractGraphFormatter)constructor.newInstance(new Object[0]);
        }
        catch (SecurityException e) {
            GraphWriterPlugin.handleInstantiationException(graph.getClass(), formatterClass, e);
        }
        catch (NoSuchMethodException e) {
            GraphWriterPlugin.handleInstantiationException(graph.getClass(), formatterClass, e);
        }
        catch (IllegalArgumentException e) {
            GraphWriterPlugin.handleInstantiationException(graph.getClass(), formatterClass, e);
        }
        catch (InstantiationException e) {
            GraphWriterPlugin.handleInstantiationException(graph.getClass(), formatterClass, e);
        }
        catch (IllegalAccessException e) {
            GraphWriterPlugin.handleInstantiationException(graph.getClass(), formatterClass, e);
        }
        catch (InvocationTargetException e) {
            GraphWriterPlugin.handleInstantiationException(graph.getClass(), formatterClass, e);
        }
        return null;
    }

    private String getOutputFileName(AbstractGraphFormatter<?> formatter) {
        String outputFileName = this.gConfiguration.getOutputFileName();
        if (outputFileName.length() == 0) {
            outputFileName = formatter.getDefaultFileName();
        }
        return outputFileName;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @InputPort(name="inputGraph", eventTypes={AbstractGraph.class})
    public void writeGraph(AbstractGraph<?, ?, ?> graph) {
        AbstractGraphFormatter<?> graphFormatter = GraphWriterPlugin.createFormatter(graph);
        String specification = graphFormatter.createFormattedRepresentation(graph, this.gConfiguration);
        String outputFileName = this.gConfiguration.getOutputPath() + this.getOutputFileName(graphFormatter);
        BufferedWriter writer = null;
        writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFileName), ENCODING));
        writer.write(specification);
        writer.flush();
        Object var8_6 = null;
        if (writer == null) return;
        try {
            writer.close();
            return;
        }
        catch (IOException e) {
            LOG.error(String.format(WRITE_ERROR_MESSAGE_TEMPLATE, outputFileName), e);
        }
        return;
        {
            catch (IOException e) {
                throw new GraphFormattingException(String.format(WRITE_ERROR_MESSAGE_TEMPLATE, outputFileName), e);
            }
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            if (writer == null) throw throwable;
            try {
                writer.close();
                throw throwable;
            }
            catch (IOException e) {
                LOG.error(String.format(WRITE_ERROR_MESSAGE_TEMPLATE, outputFileName), e);
            }
            throw throwable;
        }
    }

    static {
        FORMATTER_REGISTRY.put(ComponentAllocationDependencyGraph.class, ComponentAllocationDependencyGraphFormatter.class);
        FORMATTER_REGISTRY.put(ComponentAssemblyDependencyGraph.class, ComponentAssemblyDependencyGraphFormatter.class);
        FORMATTER_REGISTRY.put(OperationAllocationDependencyGraph.class, OperationAllocationDependencyGraphFormatter.class);
        FORMATTER_REGISTRY.put(OperationAssemblyDependencyGraph.class, OperationAssemblyDependencyGraphFormatter.class);
        FORMATTER_REGISTRY.put(ContainerDependencyGraph.class, ContainerDependencyGraphFormatter.class);
    }
}

