/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.traceAnalysis.filter.visualization.callTree;

import java.io.File;
import java.io.IOException;
import kieker.analysis.plugin.annotation.InputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.Property;
import kieker.analysis.plugin.annotation.RepositoryPort;
import kieker.common.configuration.Configuration;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.tools.traceAnalysis.filter.traceReconstruction.TraceProcessingException;
import kieker.tools.traceAnalysis.filter.visualization.callTree.AbstractAggregatedCallTreeNode;
import kieker.tools.traceAnalysis.filter.visualization.callTree.AbstractCallTreeFilter;
import kieker.tools.traceAnalysis.systemModel.MessageTrace;
import kieker.tools.traceAnalysis.systemModel.SynchronousCallMessage;
import kieker.tools.traceAnalysis.systemModel.repository.SystemModelRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Plugin(description="An abstract filter for aggregated call trees", repositoryPorts={@RepositoryPort(name="systemModelRepository", repositoryType=SystemModelRepository.class)}, configuration={@Property(name="includeWeights", defaultValue="true"), @Property(name="shortLabels", defaultValue="true"), @Property(name="dotOutputFn", defaultValue="calltree.dot")})
public abstract class AbstractAggregatedCallTreeFilter<T>
extends AbstractCallTreeFilter<T> {
    public static final String CONFIG_PROPERTY_NAME_OUTPUT_FILENAME = "dotOutputFn";
    public static final String CONFIG_PROPERTY_NAME_INCLUDE_WEIGHTS = "includeWeights";
    public static final String CONFIG_PROPERTY_NAME_SHORT_LABELS = "shortLabels";
    public static final String CONFIG_PROPERTY_VALUE_OUTPUT_FILENAME_DEFAULT = "calltree.dot";
    public static final String CONFIG_PROPERTY_VALUE_INCLUDE_WEIGHTS_DEFAULT = "true";
    public static final String CONFIG_PROPERTY_VALUE_SHORT_LABELS_DEFAULT = "true";
    private static final Log LOG = LogFactory.getLog(AbstractAggregatedCallTreeFilter.class);
    private volatile AbstractAggregatedCallTreeNode<T> root;
    private final String dotOutputFile;
    private final boolean includeWeights;
    private final boolean shortLabels;
    private int numGraphsSaved;

    public AbstractAggregatedCallTreeFilter(Configuration configuration) {
        super(configuration);
        this.includeWeights = configuration.getBooleanProperty(CONFIG_PROPERTY_NAME_INCLUDE_WEIGHTS);
        this.shortLabels = configuration.getBooleanProperty(CONFIG_PROPERTY_NAME_SHORT_LABELS);
        this.dotOutputFile = configuration.getPathProperty(CONFIG_PROPERTY_NAME_OUTPUT_FILENAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRoot(AbstractAggregatedCallTreeNode<T> root) {
        AbstractAggregatedCallTreeFilter abstractAggregatedCallTreeFilter = this;
        synchronized (abstractAggregatedCallTreeFilter) {
            this.root = root;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveTreeToDotFile() throws IOException {
        AbstractAggregatedCallTreeFilter abstractAggregatedCallTreeFilter = this;
        synchronized (abstractAggregatedCallTreeFilter) {
            String outputFn = new File(this.dotOutputFile).getCanonicalPath();
            AbstractCallTreeFilter.saveTreeToDotFile(this.root, outputFn, this.includeWeights, false, this.shortLabels);
            ++this.numGraphsSaved;
            this.printMessage(new String[]{"Wrote call tree to file '" + outputFn + "'", "Dot file can be converted using the dot tool", "Example: dot -T svg " + outputFn + " > " + outputFn + ".svg"});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStatusMessage() {
        AbstractAggregatedCallTreeFilter abstractAggregatedCallTreeFilter = this;
        synchronized (abstractAggregatedCallTreeFilter) {
            super.printStatusMessage();
            this.stdOutPrintln("Saved " + this.numGraphsSaved + " call tree" + (this.numGraphsSaved > 1 ? "s" : ""));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminate(boolean error) {
        AbstractAggregatedCallTreeFilter abstractAggregatedCallTreeFilter = this;
        synchronized (abstractAggregatedCallTreeFilter) {
            if (!error) {
                try {
                    this.saveTreeToDotFile();
                }
                catch (IOException ex) {
                    LOG.error("IOException while saving to dot file", ex);
                }
            }
        }
    }

    @Override
    public Configuration getCurrentConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setProperty(CONFIG_PROPERTY_NAME_INCLUDE_WEIGHTS, Boolean.toString(this.includeWeights));
        configuration.setProperty(CONFIG_PROPERTY_NAME_SHORT_LABELS, Boolean.toString(this.shortLabels));
        configuration.setProperty(CONFIG_PROPERTY_NAME_OUTPUT_FILENAME, this.dotOutputFile);
        return configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InputPort(name="messageTraces", description="Receives the message traces to be processed", eventTypes={MessageTrace.class})
    public void inputMessageTraces(MessageTrace t) {
        AbstractAggregatedCallTreeFilter abstractAggregatedCallTreeFilter = this;
        synchronized (abstractAggregatedCallTreeFilter) {
            try {
                AbstractCallTreeFilter.addTraceToTree(this.root, t, new AbstractCallTreeFilter.IPairFactory(){

                    public Object createPair(SynchronousCallMessage callMsg) {
                        return AbstractAggregatedCallTreeFilter.this.concreteCreatePair(callMsg);
                    }
                }, true);
                this.reportSuccess(t.getTraceId());
            }
            catch (TraceProcessingException ex) {
                LOG.error("TraceProcessingException", ex);
                this.reportError(t.getTraceId());
            }
        }
    }

    protected abstract Object concreteCreatePair(SynchronousCallMessage var1);
}

