/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.traceAnalysis.systemModel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import kieker.tools.traceAnalysis.systemModel.Operation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentType {
    private final int id;
    private final String packageName;
    private final String typeName;
    private final Collection<Operation> operations = Collections.synchronizedList(new ArrayList());

    public ComponentType(int id, String packageName, String typeName) {
        this.id = id;
        this.packageName = packageName;
        this.typeName = typeName;
    }

    public ComponentType(int id, String fullqualifiedTypeName) {
        String tmpTypeName;
        String tmpPackagName;
        this.id = id;
        if (fullqualifiedTypeName.indexOf(46) != -1) {
            String tmpComponentName = fullqualifiedTypeName;
            int index = 0;
            for (index = tmpComponentName.length() - 1; index > 0 && tmpComponentName.charAt(index) != '.'; --index) {
            }
            tmpPackagName = tmpComponentName.substring(0, index);
            tmpTypeName = tmpComponentName.substring(index + 1);
        } else {
            tmpPackagName = "";
            tmpTypeName = fullqualifiedTypeName;
        }
        this.packageName = tmpPackagName;
        this.typeName = tmpTypeName;
    }

    public final int getId() {
        return this.id;
    }

    public final String getTypeName() {
        return this.typeName;
    }

    public final String getPackageName() {
        return this.packageName;
    }

    public final String getFullQualifiedName() {
        if (this.packageName == null || this.packageName.length() == 0) {
            return this.typeName;
        }
        return this.packageName + "." + this.typeName;
    }

    public final Collection<Operation> getOperations() {
        return this.operations;
    }

    public final Operation addOperation(Operation op) {
        this.operations.add(op);
        return op;
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ComponentType)) {
            return false;
        }
        ComponentType other = (ComponentType)obj;
        return other.id == this.id;
    }
}

