/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.traceAnalysis.systemModel;

import kieker.tools.traceAnalysis.systemModel.AllocationComponent;
import kieker.tools.traceAnalysis.systemModel.Operation;

public class Execution {
    public static final String NO_SESSION_ID = "<NOSESSIONID>";
    private final Operation operation;
    private final AllocationComponent allocationComponent;
    private final long traceId;
    private final String sessionId;
    private final int eoi;
    private final int ess;
    private final long tin;
    private final long tout;
    private final boolean assumed;

    public Execution(Operation op, AllocationComponent allocationComponent, long traceId, String sessionId, int eoi, int ess, long tin, long tout, boolean assumed) {
        if (op == null) {
            throw new NullPointerException("argument op must not be null");
        }
        if (allocationComponent == null) {
            throw new NullPointerException("argument allocationComponent must not be null");
        }
        if (sessionId == null) {
            throw new NullPointerException("argument sessionId must not be null");
        }
        this.operation = op;
        this.allocationComponent = allocationComponent;
        this.traceId = traceId;
        this.sessionId = sessionId;
        this.eoi = eoi;
        this.ess = ess;
        this.tin = tin;
        this.tout = tout;
        this.assumed = assumed;
    }

    public Execution(Operation op, AllocationComponent allocationComponent, long traceId, int eoi, int ess, long tin, long tout, boolean assumed) {
        this(op, allocationComponent, traceId, NO_SESSION_ID, eoi, ess, tin, tout, assumed);
    }

    public final AllocationComponent getAllocationComponent() {
        return this.allocationComponent;
    }

    public final int getEoi() {
        return this.eoi;
    }

    public final int getEss() {
        return this.ess;
    }

    public final Operation getOperation() {
        return this.operation;
    }

    public final String getSessionId() {
        return this.sessionId;
    }

    public final long getTin() {
        return this.tin;
    }

    public final long getTout() {
        return this.tout;
    }

    public final long getTraceId() {
        return this.traceId;
    }

    public boolean isAssumed() {
        return this.assumed;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Execution)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        Execution other = (Execution)obj;
        return this.allocationComponent.equals(other.allocationComponent) && this.operation.equals(other.operation) && this.sessionId.equals(other.sessionId) && this.traceId == other.traceId && this.eoi == other.eoi && this.ess == other.ess && this.tin == other.tin && this.tout == other.tout && this.assumed == other.assumed;
    }

    public int hashCode() {
        int hash = 3;
        hash = 43 * hash + (this.operation != null ? this.operation.hashCode() : 0);
        hash = 43 * hash + (this.allocationComponent != null ? this.allocationComponent.hashCode() : 0);
        hash = 43 * hash + (int)(this.traceId ^ this.traceId >>> 32);
        hash = 43 * hash + (this.sessionId != null ? this.sessionId.hashCode() : 0);
        hash = 43 * hash + this.eoi;
        hash = 43 * hash + this.ess;
        hash = 43 * hash + (int)(this.tin ^ this.tin >>> 32);
        hash = 43 * hash + (int)(this.tout ^ this.tout >>> 32);
        hash = 43 * hash + (this.assumed ? 5643 : 5648);
        return hash;
    }

    public String toString() {
        StringBuilder strBuild = new StringBuilder(128);
        strBuild.append(this.traceId);
        strBuild.append('[').append(this.eoi).append(',').append(this.ess).append("] ");
        strBuild.append(this.tin).append('-').append(this.tout).append(' ');
        strBuild.append(this.allocationComponent.toString()).append('.');
        strBuild.append(this.operation.getSignature().getName()).append(' ');
        strBuild.append(this.sessionId != null ? this.sessionId : NO_SESSION_ID);
        if (this.assumed) {
            strBuild.append(" (assumed)");
        }
        return strBuild.toString();
    }
}

