/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.plugin.filter.flow;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import kieker.analysis.plugin.annotation.InputPort;
import kieker.analysis.plugin.annotation.OutputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.Property;
import kieker.analysis.plugin.filter.AbstractFilterPlugin;
import kieker.analysis.plugin.filter.flow.TraceEventRecords;
import kieker.common.configuration.Configuration;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.common.record.flow.IFlowRecord;
import kieker.common.record.flow.trace.AbstractTraceEvent;
import kieker.common.record.flow.trace.Trace;
import kieker.common.record.flow.trace.operation.AfterOperationEvent;
import kieker.common.record.flow.trace.operation.AfterOperationFailedEvent;
import kieker.common.record.flow.trace.operation.BeforeOperationEvent;

@Plugin(name="Trace Reconstruction Filter", description="Filter to reconstruct event based (flow) traces", outputPorts={@OutputPort(name="validTraces", description="Outputs valid traces", eventTypes={TraceEventRecords.class}), @OutputPort(name="invalidTraces", description="Outputs traces missing crucial records", eventTypes={TraceEventRecords.class})}, configuration={@Property(name="maxTraceDuration", defaultValue="9223372036854775807"), @Property(name="maxTraceTimeout", defaultValue="9223372036854775807")})
public final class EventRecordTraceReconstructionFilter
extends AbstractFilterPlugin {
    public static final String OUTPUT_PORT_NAME_TRACE_VALID = "validTraces";
    public static final String OUTPUT_PORT_NAME_TRACE_INVALID = "invalidTraces";
    public static final String INPUT_PORT_NAME_TRACE_RECORDS = "traceRecords";
    public static final String CONFIG_PROPERTY_NAME_MAX_TRACE_DURATION = "maxTraceDuration";
    public static final String CONFIG_PROPERTY_NAME_MAX_TRACE_TIMEOUT = "maxTraceTimeout";
    public static final String CONFIG_PROPERTY_VALUE_MAX_TIME = "9223372036854775807";
    private final long maxTraceDuration;
    private final long maxTraceTimeout;
    private final boolean timeout;
    private long maxEncounteredLoggingTimestamp = -1L;
    private final Map<Long, TraceBuffer> traceId2trace;

    public EventRecordTraceReconstructionFilter(Configuration configuration) {
        super(configuration);
        this.maxTraceDuration = configuration.getLongProperty(CONFIG_PROPERTY_NAME_MAX_TRACE_DURATION);
        this.maxTraceTimeout = configuration.getLongProperty(CONFIG_PROPERTY_NAME_MAX_TRACE_TIMEOUT);
        this.timeout = this.maxTraceTimeout != Long.MAX_VALUE || this.maxTraceDuration != Long.MAX_VALUE;
        this.traceId2trace = new ConcurrentHashMap<Long, TraceBuffer>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InputPort(name="traceRecords", description="Reconstruct traces from incoming flow records", eventTypes={Trace.class, AbstractTraceEvent.class})
    public void newEvent(IFlowRecord record) {
        long loggingTimestamp;
        EventRecordTraceReconstructionFilter eventRecordTraceReconstructionFilter;
        TraceBuffer traceBuffer;
        Long traceId;
        if (record instanceof Trace) {
            traceId = ((Trace)record).getTraceId();
            traceBuffer = this.traceId2trace.get(traceId);
            if (traceBuffer == null) {
                eventRecordTraceReconstructionFilter = this;
                synchronized (eventRecordTraceReconstructionFilter) {
                    traceBuffer = this.traceId2trace.get(traceId);
                    if (traceBuffer == null) {
                        traceBuffer = new TraceBuffer();
                        this.traceId2trace.put(traceId, traceBuffer);
                    }
                }
            }
            traceBuffer.setTrace((Trace)record);
            loggingTimestamp = -1L;
        } else if (record instanceof AbstractTraceEvent) {
            traceId = ((AbstractTraceEvent)record).getTraceId();
            traceBuffer = this.traceId2trace.get(traceId);
            if (traceBuffer == null) {
                eventRecordTraceReconstructionFilter = this;
                synchronized (eventRecordTraceReconstructionFilter) {
                    traceBuffer = this.traceId2trace.get(traceId);
                    if (traceBuffer == null) {
                        traceBuffer = new TraceBuffer();
                        this.traceId2trace.put(traceId, traceBuffer);
                    }
                }
            }
            traceBuffer.insertEvent((AbstractTraceEvent)record);
            loggingTimestamp = ((AbstractTraceEvent)record).getTimestamp();
        } else {
            return;
        }
        if (traceBuffer.isFinished()) {
            eventRecordTraceReconstructionFilter = this;
            synchronized (eventRecordTraceReconstructionFilter) {
                this.traceId2trace.remove(traceId);
            }
            super.deliver(OUTPUT_PORT_NAME_TRACE_VALID, traceBuffer.toTraceEvents());
        }
        if (this.timeout) {
            eventRecordTraceReconstructionFilter = this;
            synchronized (eventRecordTraceReconstructionFilter) {
                if (loggingTimestamp > this.maxEncounteredLoggingTimestamp) {
                    this.maxEncounteredLoggingTimestamp = loggingTimestamp;
                }
                this.processTimeoutQueue(this.maxEncounteredLoggingTimestamp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate(boolean error) {
        super.terminate(error);
        EventRecordTraceReconstructionFilter eventRecordTraceReconstructionFilter = this;
        synchronized (eventRecordTraceReconstructionFilter) {
            for (Map.Entry<Long, TraceBuffer> entry : this.traceId2trace.entrySet()) {
                TraceBuffer traceBuffer = entry.getValue();
                if (traceBuffer.isInvalid()) {
                    super.deliver(OUTPUT_PORT_NAME_TRACE_INVALID, traceBuffer.toTraceEvents());
                    continue;
                }
                super.deliver(OUTPUT_PORT_NAME_TRACE_VALID, traceBuffer.toTraceEvents());
            }
            this.traceId2trace.clear();
        }
    }

    private void processTimeoutQueue(long timestamp) {
        long duration = timestamp - this.maxTraceDuration;
        long traceTimeout = timestamp - this.maxTraceTimeout;
        Iterator<Map.Entry<Long, TraceBuffer>> iterator = this.traceId2trace.entrySet().iterator();
        while (iterator.hasNext()) {
            TraceBuffer traceBuffer = iterator.next().getValue();
            if (traceBuffer.getMaxLoggingTimestamp() > traceTimeout && traceBuffer.getMinLoggingTimestamp() > duration) continue;
            if (traceBuffer.isInvalid()) {
                super.deliver(OUTPUT_PORT_NAME_TRACE_INVALID, traceBuffer.toTraceEvents());
            } else {
                super.deliver(OUTPUT_PORT_NAME_TRACE_VALID, traceBuffer.toTraceEvents());
            }
            iterator.remove();
        }
    }

    public Configuration getCurrentConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setProperty(CONFIG_PROPERTY_NAME_MAX_TRACE_DURATION, String.valueOf(this.maxTraceDuration));
        configuration.setProperty(CONFIG_PROPERTY_NAME_MAX_TRACE_TIMEOUT, String.valueOf(this.maxTraceTimeout));
        return configuration;
    }

    private static final class TraceBuffer {
        private static final Log LOG = LogFactory.getLog(TraceBuffer.class);
        private static final Comparator<AbstractTraceEvent> COMPARATOR = new TraceEventComperator();
        private Trace trace;
        private final SortedSet<AbstractTraceEvent> events = new TreeSet<AbstractTraceEvent>(COMPARATOR);
        private boolean closeable;
        private boolean damaged;
        private int openEvents;
        private int maxOrderIndex = -1;
        private long minLoggingTimestamp = Long.MAX_VALUE;
        private long maxLoggingTimestamp = -1L;
        private long traceId = -1L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void insertEvent(AbstractTraceEvent event) {
            long myTraceId = event.getTraceId();
            TraceBuffer traceBuffer = this;
            synchronized (traceBuffer) {
                int orderIndex;
                if (this.traceId == -1L) {
                    this.traceId = myTraceId;
                } else if (this.traceId != myTraceId) {
                    LOG.error("Invalid traceId! Expected: " + this.traceId + " but found: " + myTraceId + " in event " + event.toString());
                    this.damaged = true;
                }
                long loggingTimestamp = event.getTimestamp();
                if (loggingTimestamp > this.maxLoggingTimestamp) {
                    this.maxLoggingTimestamp = loggingTimestamp;
                }
                if (loggingTimestamp < this.minLoggingTimestamp) {
                    this.minLoggingTimestamp = loggingTimestamp;
                }
                if ((orderIndex = event.getOrderIndex()) > this.maxOrderIndex) {
                    this.maxOrderIndex = orderIndex;
                }
                if (event instanceof BeforeOperationEvent) {
                    if (orderIndex == 0) {
                        this.closeable = true;
                    }
                    ++this.openEvents;
                } else if (event instanceof AfterOperationEvent) {
                    --this.openEvents;
                } else if (event instanceof AfterOperationFailedEvent) {
                    --this.openEvents;
                }
                if (!this.events.add(event)) {
                    LOG.error("Duplicate entry for orderIndex " + orderIndex + " with tarceId " + myTraceId);
                    this.damaged = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setTrace(Trace trace) {
            long myTraceId = trace.getTraceId();
            TraceBuffer traceBuffer = this;
            synchronized (traceBuffer) {
                if (this.traceId == -1L) {
                    this.traceId = myTraceId;
                } else if (this.traceId != myTraceId) {
                    LOG.error("Invalid traceId! Expected: " + this.traceId + " but found: " + myTraceId + " in trace " + trace.toString());
                    this.damaged = true;
                }
                if (this.trace == null) {
                    this.trace = trace;
                } else {
                    LOG.error("Duplicate Trace entry for traceId " + myTraceId);
                    this.damaged = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isFinished() {
            TraceBuffer traceBuffer = this;
            synchronized (traceBuffer) {
                return this.closeable && !this.isInvalid();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isInvalid() {
            TraceBuffer traceBuffer = this;
            synchronized (traceBuffer) {
                return this.trace == null || this.damaged || this.openEvents != 0 || this.maxOrderIndex + 1 != this.events.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TraceEventRecords toTraceEvents() {
            TraceBuffer traceBuffer = this;
            synchronized (traceBuffer) {
                return new TraceEventRecords(this.trace, this.events.toArray(new AbstractTraceEvent[this.events.size()]));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getMaxLoggingTimestamp() {
            TraceBuffer traceBuffer = this;
            synchronized (traceBuffer) {
                return this.maxLoggingTimestamp;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getMinLoggingTimestamp() {
            TraceBuffer traceBuffer = this;
            synchronized (traceBuffer) {
                return this.minLoggingTimestamp;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static final class TraceEventComperator
        implements Comparator<AbstractTraceEvent>,
        Serializable {
            private static final long serialVersionUID = 8920737343446332517L;

            @Override
            public int compare(AbstractTraceEvent o1, AbstractTraceEvent o2) {
                return o1.getOrderIndex() - o2.getOrderIndex();
            }
        }
    }
}

