/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.plugin.reader.database;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import kieker.analysis.plugin.annotation.OutputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.Property;
import kieker.analysis.plugin.reader.AbstractReaderPlugin;
import kieker.common.configuration.Configuration;
import kieker.common.exception.MonitoringRecordException;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.common.record.AbstractMonitoringRecord;
import kieker.common.record.IMonitoringRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Plugin(description="A reader which reads records from a database", outputPorts={@OutputPort(name="monitoringRecords", eventTypes={IMonitoringRecord.class}, description="Output Port of the DBReader")}, configuration={@Property(name="DriverClassname", defaultValue="org.apache.derby.jdbc.EmbeddedDriver", description="The classname of the driver used for the connection."), @Property(name="ConnectionString", defaultValue="jdbc:derby:tmp/KIEKER;user=DBUSER;password=DBPASS", description="The connection string used to establish the connection."), @Property(name="TablePrefix", defaultValue="kieker", description="The prefix of the used table within the database.")})
public class DbReader
extends AbstractReaderPlugin {
    public static final String OUTPUT_PORT_NAME_RECORDS = "monitoringRecords";
    public static final String CONFIG_PROPERTY_NAME_DRIVERCLASSNAME = "DriverClassname";
    public static final String CONFIG_PROPERTY_NAME_CONNECTIONSTRING = "ConnectionString";
    public static final String CONFIG_PROPERTY_NAME_TABLEPREFIX = "TablePrefix";
    private static final Log LOG = LogFactory.getLog(DbReader.class);
    private final String driverClassname;
    private final String connectionString;
    private final String tablePrefix;
    private volatile boolean running = true;

    public DbReader(Configuration configuration) throws Exception {
        super(configuration);
        this.driverClassname = configuration.getStringProperty(CONFIG_PROPERTY_NAME_DRIVERCLASSNAME);
        this.connectionString = configuration.getStringProperty(CONFIG_PROPERTY_NAME_CONNECTIONSTRING);
        this.tablePrefix = configuration.getStringProperty(CONFIG_PROPERTY_NAME_TABLEPREFIX);
        try {
            Class.forName(this.driverClassname).newInstance();
        }
        catch (Exception ex) {
            throw new Exception("DB driver registration failed. Perhaps the driver jar is missing?", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean read() {
        Connection connection = null;
        try {
            connection = DriverManager.getConnection(this.connectionString);
            Statement getIndexTable = null;
            try {
                getIndexTable = connection.createStatement();
                ResultSet indexTable = null;
                try {
                    indexTable = getIndexTable.executeQuery("SELECT * from " + this.tablePrefix);
                    while (this.running && indexTable.next()) {
                        String tablename = indexTable.getString(1);
                        String classname = indexTable.getString(2);
                        try {
                            this.table2record(connection, tablename, AbstractMonitoringRecord.classForName(classname));
                        }
                        catch (MonitoringRecordException ex) {
                            LOG.error("Failed to load records of type " + classname + " from table " + tablename, ex);
                        }
                    }
                }
                finally {
                    if (indexTable != null) {
                        indexTable.close();
                    }
                }
            }
            finally {
                if (getIndexTable != null) {
                    getIndexTable.close();
                }
            }
        }
        catch (SQLException ex) {
            LOG.error("SQLException with SQLState: '" + ex.getSQLState() + "' and VendorError: '" + ex.getErrorCode() + "'", ex);
            boolean bl = false;
            return bl;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException ex) {
                    LOG.error("SQLException with SQLState: '" + ex.getSQLState() + "' and VendorError: '" + ex.getErrorCode() + "'", ex);
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void table2record(Connection connection, String tablename, Class<? extends IMonitoringRecord> clazz) throws SQLException, MonitoringRecordException {
        Statement selectRecord = null;
        try {
            selectRecord = connection.createStatement();
            ResultSet records = null;
            try {
                records = selectRecord.executeQuery("SELECT * from " + tablename);
                int size = records.getMetaData().getColumnCount() - 2;
                while (this.running && records.next()) {
                    Object[] recordValues = new Object[size];
                    for (int i = 0; i < size; ++i) {
                        recordValues[i] = records.getObject(i + 3);
                    }
                    IMonitoringRecord record = AbstractMonitoringRecord.createFromArray(clazz, recordValues);
                    record.setLoggingTimestamp(records.getLong(2));
                    super.deliver(OUTPUT_PORT_NAME_RECORDS, record);
                }
            }
            finally {
                if (records != null) {
                    records.close();
                }
            }
        }
        finally {
            if (selectRecord != null) {
                selectRecord.close();
            }
        }
    }

    @Override
    public void terminate(boolean error) {
        LOG.info("Shutdown of DBReader requested.");
        this.running = false;
    }

    @Override
    public Configuration getCurrentConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setProperty(CONFIG_PROPERTY_NAME_DRIVERCLASSNAME, this.driverClassname);
        configuration.setProperty(CONFIG_PROPERTY_NAME_CONNECTIONSTRING, this.connectionString);
        configuration.setProperty(CONFIG_PROPERTY_NAME_TABLEPREFIX, this.tablePrefix);
        return configuration;
    }
}

