/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.plugin.reader.filesystem;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kieker.analysis.plugin.reader.filesystem.FSReader;
import kieker.analysis.plugin.reader.filesystem.IMonitoringRecordReceiver;
import kieker.common.exception.MonitoringRecordException;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.common.record.AbstractMonitoringRecord;
import kieker.common.record.IMonitoringRecord;
import kieker.common.record.controlflow.OperationExecutionRecord;

final class FSDirectoryReader
implements Runnable {
    private static final Log LOG = LogFactory.getLog(FSDirectoryReader.class);
    private static final String LEGACY_FILE_PREFIX = "tpmon";
    private static final String NORMAL_FILE_PREFIX = "kieker";
    private static final String NORMAL_FILE_POSTFIX = ".dat";
    private static final String BINARY_FILE_POSTFIX = ".bin";
    private static final String ENCODING = "UTF-8";
    String filePrefix = "kieker";
    private final Map<Integer, String> stringRegistry = new HashMap<Integer, String>();
    private final IMonitoringRecordReceiver recordReceiver;
    private final File inputDir;
    private boolean terminated;
    private final boolean ignoreUnknownRecordTypes;
    private final Set<String> unknownTypesObserved = new HashSet<String>();

    public FSDirectoryReader(String inputDirName, IMonitoringRecordReceiver recordReceiver, boolean ignoreUnknownRecordTypes) {
        if (inputDirName == null || inputDirName.length() == 0) {
            throw new IllegalArgumentException("Invalid or empty inputDir: " + inputDirName);
        }
        this.inputDir = new File(inputDirName);
        this.recordReceiver = recordReceiver;
        this.ignoreUnknownRecordTypes = ignoreUnknownRecordTypes;
    }

    public final void run() {
        this.readMappingFile();
        File[] inputFiles = this.inputDir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().startsWith(FSDirectoryReader.this.filePrefix) && (pathname.getName().endsWith(FSDirectoryReader.NORMAL_FILE_POSTFIX) || pathname.getName().endsWith(FSDirectoryReader.BINARY_FILE_POSTFIX));
            }
        });
        if (inputFiles == null) {
            LOG.error("Directory '" + this.inputDir + "' does not exist or an I/O error occured.");
        } else if (inputFiles.length == 0) {
            LOG.warn("Directory '" + this.inputDir + "' contains no files starting with '" + this.filePrefix + "' and ending with '" + NORMAL_FILE_POSTFIX + "' or '" + BINARY_FILE_POSTFIX + "'.");
        } else {
            Arrays.sort(inputFiles, new Comparator<File>(){

                @Override
                public final int compare(File f1, File f2) {
                    return f1.compareTo(f2);
                }
            });
            for (File inputFile : inputFiles) {
                if (this.terminated) {
                    LOG.info("Shutting down DirectoryReader.");
                    break;
                }
                LOG.info("< Loading " + inputFile.getAbsolutePath());
                if (inputFile.getName().endsWith(NORMAL_FILE_POSTFIX)) {
                    this.processNormalInputFile(inputFile);
                    continue;
                }
                if (!inputFile.getName().endsWith(BINARY_FILE_POSTFIX)) continue;
                if (this.ignoreUnknownRecordTypes) {
                    LOG.warn("The property 'ignoreUnknownRecordTypes' is not supported for binary files. But trying to read '" + inputFile + "'");
                }
                this.processBinaryInputFile(inputFile);
            }
        }
        this.recordReceiver.newMonitoringRecord(FSReader.EOF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void readMappingFile() {
        File mappingFile = new File(this.inputDir.getAbsolutePath() + File.separator + "kieker.map");
        if (!mappingFile.exists()) {
            mappingFile = new File(this.inputDir.getAbsolutePath() + File.separator + "tpmon.map");
            if (mappingFile.exists()) {
                LOG.info("Directory '" + this.inputDir + "' contains no file 'kieker.map'. Found 'tpmon.map' ... switching to legacy mode");
                this.filePrefix = LEGACY_FILE_PREFIX;
            } else {
                LOG.warn("No mapping file in directory '" + this.inputDir.getAbsolutePath() + "'");
                return;
            }
        }
        BufferedReader in = null;
        try {
            String line;
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(mappingFile), ENCODING));
            while ((line = in.readLine()) != null) {
                Integer id;
                if (line.length() == 0) continue;
                int split = line.indexOf(61);
                if (split == -1) {
                    LOG.error("Failed to parse line: {" + line + "} from file " + mappingFile.getAbsolutePath() + ". Each line must contain ID=VALUE pairs.");
                    continue;
                }
                String key = line.substring(0, split);
                String value = line.substring(split + 1);
                try {
                    id = Integer.valueOf(key.charAt(0) == '$' ? key.substring(1) : key);
                }
                catch (NumberFormatException ex) {
                    LOG.error("Error reading mapping file, id must be integer", ex);
                    continue;
                }
                String prevVal = this.stringRegistry.put(id, value);
                if (prevVal == null) continue;
                LOG.error("Found addional entry for id='" + id + "', old value was '" + prevVal + "' new value is '" + value + "'");
            }
        }
        catch (IOException ex) {
            LOG.error("Error reading mapping file", ex);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    LOG.error("Exception while closing input stream for mapping file", ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processNormalInputFile(File inputFile) {
        boolean abortDueToUnknownRecordType = false;
        BufferedReader in = null;
        try {
            String line;
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inputFile), ENCODING));
            while ((line = in.readLine()) != null) {
                IMonitoringRecord record;
                block22: {
                    if ((line = line.trim()).length() == 0) continue;
                    record = null;
                    String[] recordFields = line.split(";");
                    try {
                        if (recordFields[0].charAt(0) == '$') {
                            if (recordFields.length < 2) {
                                LOG.error("Illegal record format: " + line);
                                continue;
                            }
                            Integer id = Integer.valueOf(recordFields[0].substring(1));
                            String classname = this.stringRegistry.get(id);
                            if (classname == null) {
                                LOG.error("Missing classname mapping for record type id '" + id + "'");
                                continue;
                            }
                            Class<? extends IMonitoringRecord> clazz = null;
                            try {
                                clazz = AbstractMonitoringRecord.classForName(classname);
                            }
                            catch (MonitoringRecordException ex) {
                                if (!this.ignoreUnknownRecordTypes) {
                                    abortDueToUnknownRecordType = true;
                                    throw new MonitoringRecordException("Failed to load record type " + classname, ex);
                                }
                                if (this.unknownTypesObserved.contains(classname)) continue;
                                LOG.error("Failed to load record type " + classname, ex);
                                this.unknownTypesObserved.add(classname);
                                continue;
                            }
                            long loggingTimestamp = Long.valueOf(recordFields[1]);
                            int skipValues = recordFields.length == 11 && clazz.equals(OperationExecutionRecord.class) ? 3 : 2;
                            String[] recordFieldsReduced = new String[recordFields.length - skipValues];
                            System.arraycopy(recordFields, skipValues, recordFieldsReduced, 0, recordFields.length - skipValues);
                            record = AbstractMonitoringRecord.createFromStringArray(clazz, recordFieldsReduced);
                            record.setLoggingTimestamp(loggingTimestamp);
                            break block22;
                        }
                        String[] recordFieldsReduced = new String[recordFields.length - 1];
                        System.arraycopy(recordFields, 1, recordFieldsReduced, 0, recordFields.length - 1);
                        record = AbstractMonitoringRecord.createFromStringArray(OperationExecutionRecord.class, recordFieldsReduced);
                    }
                    catch (MonitoringRecordException ex) {
                        if (abortDueToUnknownRecordType) {
                            this.terminated = true;
                            IOException newEx = new IOException("Error processing line: " + line);
                            newEx.initCause(ex);
                            throw newEx;
                        }
                        LOG.warn("Error processing line: " + line, ex);
                        continue;
                    }
                }
                if (this.recordReceiver.newMonitoringRecord(record)) continue;
                this.terminated = true;
                break;
            }
        }
        catch (Exception ex) {
            LOG.error("Error reading " + inputFile, ex);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    LOG.error("Exception while closing input stream for processing input file", ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processBinaryInputFile(File inputFile) {
        block30: {
            FilterInputStream in = null;
            try {
                IMonitoringRecord record;
                in = new DataInputStream(new BufferedInputStream(new FileInputStream(inputFile), 0x100000));
                do {
                    Integer id;
                    try {
                        id = ((DataInputStream)in).readInt();
                    }
                    catch (EOFException eof) {
                        break block30;
                    }
                    String classname = this.stringRegistry.get(id);
                    if (classname == null) {
                        LOG.error("Missing classname mapping for record type id '" + id + "'");
                        break block30;
                    }
                    Class<? extends IMonitoringRecord> clazz = AbstractMonitoringRecord.classForName(classname);
                    Class<?>[] typeArray = AbstractMonitoringRecord.typesForClass(clazz);
                    long loggingTimestamp = ((DataInputStream)in).readLong();
                    Object[] objectArray = new Object[typeArray.length];
                    int idx = -1;
                    for (Class<?> type : typeArray) {
                        ++idx;
                        if (type == String.class) {
                            Integer strId = ((DataInputStream)in).readInt();
                            String str = this.stringRegistry.get(strId);
                            if (str == null) {
                                LOG.error("No String mapping found for id " + strId.toString());
                                objectArray[idx] = "";
                                continue;
                            }
                            objectArray[idx] = str;
                            continue;
                        }
                        if (type == Integer.TYPE || type == Integer.class) {
                            objectArray[idx] = ((DataInputStream)in).readInt();
                            continue;
                        }
                        if (type == Long.TYPE || type == Long.class) {
                            objectArray[idx] = ((DataInputStream)in).readLong();
                            continue;
                        }
                        if (type == Float.TYPE || type == Float.class) {
                            objectArray[idx] = Float.valueOf(((DataInputStream)in).readFloat());
                            continue;
                        }
                        if (type == Double.TYPE || type == Double.class) {
                            objectArray[idx] = ((DataInputStream)in).readDouble();
                            continue;
                        }
                        if (type == Byte.TYPE || type == Byte.class) {
                            objectArray[idx] = ((DataInputStream)in).readByte();
                            continue;
                        }
                        if (type == Short.TYPE || type == Short.class) {
                            objectArray[idx] = ((DataInputStream)in).readShort();
                            continue;
                        }
                        if (type == Boolean.TYPE || type == Boolean.class) {
                            objectArray[idx] = ((DataInputStream)in).readBoolean();
                            continue;
                        }
                        if (((DataInputStream)in).readByte() != 0) {
                            LOG.error("Unexpected value for unsupported type: " + clazz.getName());
                            return;
                        }
                        LOG.warn("Unsupported type: " + clazz.getName());
                        objectArray[idx] = null;
                    }
                    record = AbstractMonitoringRecord.createFromArray(clazz, objectArray);
                    record.setLoggingTimestamp(loggingTimestamp);
                } while (this.recordReceiver.newMonitoringRecord(record));
                this.terminated = true;
            }
            catch (Exception ex) {
                LOG.error("Error reading " + inputFile, ex);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ex) {
                        LOG.error("Exception while closing input stream for processing input file", ex);
                    }
                }
            }
        }
    }
}

