/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.plugin.reader.filesystem;

import java.util.PriorityQueue;
import kieker.analysis.plugin.annotation.OutputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.Property;
import kieker.analysis.plugin.reader.AbstractReaderPlugin;
import kieker.analysis.plugin.reader.filesystem.FSDirectoryReader;
import kieker.analysis.plugin.reader.filesystem.IMonitoringRecordReceiver;
import kieker.common.configuration.Configuration;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.common.record.IMonitoringRecord;
import kieker.common.record.misc.EmptyRecord;

@Plugin(description="A file system reader which reads records from multiple directories", outputPorts={@OutputPort(name="monitoringRecords", eventTypes={IMonitoringRecord.class}, description="Output Port of the FSReader")}, configuration={@Property(name="inputDirs", defaultValue=".", description="The name of the input dirs used to read data (multiple dirs are separated by |)."), @Property(name="ignoreUnknownRecordTypes", defaultValue="false", description="Ignore unknown records? Aborts if encountered and value is false.")})
public class FSReader
extends AbstractReaderPlugin
implements IMonitoringRecordReceiver {
    public static final String OUTPUT_PORT_NAME_RECORDS = "monitoringRecords";
    public static final String CONFIG_PROPERTY_NAME_INPUTDIRS = "inputDirs";
    public static final String CONFIG_PROPERTY_NAME_IGNORE_UNKNOWN_RECORD_TYPES = "ignoreUnknownRecordTypes";
    public static final IMonitoringRecord EOF = new EmptyRecord();
    private static final Log LOG = LogFactory.getLog(FSReader.class);
    private final boolean ignoreUnknownRecordTypes;
    private final String[] inputDirs = this.configuration.getStringArrayProperty("inputDirs");
    private final PriorityQueue<IMonitoringRecord> recordQueue;
    private volatile boolean running = true;

    public FSReader(Configuration configuration) {
        super(configuration);
        for (int i = 0; i < this.inputDirs.length; ++i) {
            this.inputDirs[i] = Configuration.convertToPath(this.inputDirs[i]);
        }
        if (this.inputDirs.length == 0) {
            LOG.warn("The list of input dirs passed to the " + FSReader.class.getSimpleName() + " is empty");
        }
        this.recordQueue = new PriorityQueue(this.inputDirs.length);
        this.ignoreUnknownRecordTypes = this.configuration.getBooleanProperty(CONFIG_PROPERTY_NAME_IGNORE_UNKNOWN_RECORD_TYPES);
    }

    public void terminate(boolean error) {
        LOG.info("Shutting down reader.");
        this.running = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean read() {
        for (String inputDir : this.inputDirs) {
            Thread readerThread = new Thread(new FSDirectoryReader(inputDir, this, this.ignoreUnknownRecordTypes));
            readerThread.setDaemon(true);
            readerThread.start();
        }
        int readingReaders = this.inputDirs.length;
        while (readingReaders > 0) {
            IMonitoringRecord record;
            PriorityQueue<IMonitoringRecord> len$ = this.recordQueue;
            synchronized (len$) {
                while (this.recordQueue.size() < readingReaders) {
                    try {
                        this.recordQueue.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            IMonitoringRecord iMonitoringRecord = record = (IMonitoringRecord)this.recordQueue.remove();
            synchronized (iMonitoringRecord) {
                record.notifyAll();
            }
            if (record == EOF) {
                --readingReaders;
                continue;
            }
            super.deliver(OUTPUT_PORT_NAME_RECORDS, record);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean newMonitoringRecord(IMonitoringRecord record) {
        IMonitoringRecord iMonitoringRecord = record;
        synchronized (iMonitoringRecord) {
            PriorityQueue<IMonitoringRecord> priorityQueue = this.recordQueue;
            synchronized (priorityQueue) {
                this.recordQueue.add(record);
                this.recordQueue.notifyAll();
            }
            try {
                record.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.running;
    }

    public Configuration getCurrentConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setProperty(CONFIG_PROPERTY_NAME_INPUTDIRS, Configuration.toProperty(this.inputDirs));
        configuration.setProperty(CONFIG_PROPERTY_NAME_IGNORE_UNKNOWN_RECORD_TYPES, Boolean.toString(this.ignoreUnknownRecordTypes));
        return configuration;
    }
}

