/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.plugin.reader.jms;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.concurrent.CountDownLatch;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageFormatException;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import kieker.analysis.plugin.annotation.OutputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.Property;
import kieker.analysis.plugin.reader.AbstractReaderPlugin;
import kieker.common.configuration.Configuration;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.common.record.IMonitoringRecord;

@Plugin(description="A reader which reads records from a (remove or local) JMS queue", dependencies="This plugin needs the file 'javax.jms-*.jar'.", outputPorts={@OutputPort(name="monitoringRecords", eventTypes={IMonitoringRecord.class}, description="Output Port of the JMSReader")}, configuration={@Property(name="jmsProviderUrl", defaultValue="tcp://127.0.0.1:61616/"), @Property(name="jmsDestination", defaultValue="queue1"), @Property(name="jmsFactoryLookupName", defaultValue="org.apache.activemq.jndi.ActiveMQInitialContextFactory")})
public final class JMSReader
extends AbstractReaderPlugin {
    public static final String OUTPUT_PORT_NAME_RECORDS = "monitoringRecords";
    public static final String CONFIG_PROPERTY_NAME_PROVIDERURL = "jmsProviderUrl";
    public static final String CONFIG_PROPERTY_NAME_DESTINATION = "jmsDestination";
    public static final String CONFIG_PROPERTY_NAME_FACTORYLOOKUP = "jmsFactoryLookupName";
    private static final Log LOG = LogFactory.getLog(JMSReader.class);
    private final String jmsProviderUrl;
    private final String jmsDestination;
    private final String jmsFactoryLookupName;
    private final CountDownLatch cdLatch = new CountDownLatch(1);

    public JMSReader(Configuration configuration) throws IllegalArgumentException {
        super(configuration);
        this.jmsProviderUrl = configuration.getStringProperty(CONFIG_PROPERTY_NAME_PROVIDERURL);
        this.jmsDestination = configuration.getStringProperty(CONFIG_PROPERTY_NAME_DESTINATION);
        this.jmsFactoryLookupName = configuration.getStringProperty(CONFIG_PROPERTY_NAME_FACTORYLOOKUP);
        if (this.jmsProviderUrl.length() == 0 || this.jmsDestination.length() == 0 || this.jmsFactoryLookupName.length() == 0) {
            throw new IllegalArgumentException("JMSReader has not sufficient parameters. jmsProviderUrl ('" + this.jmsProviderUrl + "'), jmsDestination ('" + this.jmsDestination + "'), or factoryLookupName ('" + this.jmsFactoryLookupName + "') is null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean read() {
        boolean retVal = false;
        Connection connection = null;
        try {
            Destination destination;
            Session session;
            block14: {
                Hashtable<String, String> properties = new Hashtable<String, String>();
                properties.put("java.naming.factory.initial", this.jmsFactoryLookupName);
                properties.put("java.naming.provider.url", this.jmsProviderUrl);
                InitialContext context = new InitialContext(properties);
                ConnectionFactory factory = (ConnectionFactory)context.lookup("ConnectionFactory");
                connection = factory.createConnection();
                session = connection.createSession(false, 1);
                try {
                    destination = (Destination)context.lookup(this.jmsDestination);
                }
                catch (NameNotFoundException exc) {
                    destination = session.createQueue(this.jmsDestination);
                    if (destination != null) break block14;
                    LOG.error("Failed to lookup queue '" + this.jmsDestination + "' via JNDI: " + exc.getMessage() + " AND failed to create queue");
                    throw exc;
                }
            }
            LOG.info("Listening to destination:" + destination + " at " + this.jmsProviderUrl + " !\n***\n\n");
            MessageConsumer receiver = session.createConsumer(destination);
            receiver.setMessageListener(new MessageListener(){

                public void onMessage(Message jmsMessage) {
                    if (jmsMessage instanceof TextMessage) {
                        TextMessage text = (TextMessage)jmsMessage;
                        LOG.info("Received text message: " + text);
                    } else {
                        try {
                            ObjectMessage om = (ObjectMessage)jmsMessage;
                            Serializable omo = om.getObject();
                            if (omo instanceof IMonitoringRecord && !JMSReader.super.deliver(JMSReader.OUTPUT_PORT_NAME_RECORDS, omo)) {
                                LOG.error("deliverRecord returned false");
                            }
                        }
                        catch (MessageFormatException ex) {
                            LOG.error("Error delivering record", ex);
                        }
                        catch (JMSException ex) {
                            LOG.error("Error delivering record", ex);
                        }
                        catch (Exception ex) {
                            LOG.error("Error delivering record", ex);
                        }
                    }
                }
            });
            connection.start();
            LOG.info("JMSReader started and waits for incoming monitoring events!");
            this.block();
            LOG.info("Woke up by shutdown");
        }
        catch (Exception ex) {
            LOG.error("Error in read()", ex);
            retVal = false;
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (JMSException ex) {
                LOG.error("Failed to close JMS", ex);
            }
        }
        return retVal;
    }

    private final void block() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public final void run() {
                JMSReader.this.unblock();
            }
        });
        try {
            this.cdLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    final void unblock() {
        this.cdLatch.countDown();
    }

    public void terminate(boolean error) {
        LOG.info("Shutdown of JMSReader requested.");
        this.unblock();
    }

    public Configuration getCurrentConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setProperty(CONFIG_PROPERTY_NAME_PROVIDERURL, this.jmsProviderUrl);
        configuration.setProperty(CONFIG_PROPERTY_NAME_DESTINATION, this.jmsDestination);
        configuration.setProperty(CONFIG_PROPERTY_NAME_FACTORYLOOKUP, this.jmsFactoryLookupName);
        return configuration;
    }
}

