/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.plugin.reader.jmx;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.concurrent.CountDownLatch;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import kieker.analysis.plugin.annotation.OutputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.Property;
import kieker.analysis.plugin.reader.AbstractReaderPlugin;
import kieker.common.configuration.Configuration;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.common.record.IMonitoringRecord;

@Plugin(description="A reader which reads records from a JMX queue", outputPorts={@OutputPort(name="monitoringRecords", eventTypes={IMonitoringRecord.class}, description="Output Port of the JMXReader")}, configuration={@Property(name="server", defaultValue="localhost", description="The address of the server used for the JMX connection."), @Property(name="port", defaultValue="59999", description="The port of the server used for the JMX connection."), @Property(name="serviceUrl", defaultValue="", description="As an alternative to specifiying server and port, a service URL can be given. This value is ignored if port > 0."), @Property(name="domain", defaultValue="kieker.monitoring", description="The JMX domain used by the JMXWriter."), @Property(name="logname", defaultValue="MonitoringLog", description="The logname used by the JMXWriter."), @Property(name="silentReconnect", defaultValue="false", description="Whether the JMXReader should silently reconnect on any errors. This prevents termination of the reader!")})
public final class JMXReader
extends AbstractReaderPlugin {
    public static final String OUTPUT_PORT_NAME_RECORDS = "monitoringRecords";
    public static final String CONFIG_PROPERTY_NAME_SERVER = "server";
    public static final String CONFIG_PROPERTY_NAME_PORT = "port";
    public static final String CONFIG_PROPERTY_NAME_SERVICEURL = "serviceUrl";
    public static final String CONFIG_PROPERTY_NAME_DOMAIN = "domain";
    public static final String CONFIG_PROPERTY_NAME_LOGNAME = "logname";
    public static final String CONFIG_PROPERTY_NAME_SILENT = "silentReconnect";
    private static final Log LOG = LogFactory.getLog(JMXReader.class);
    final boolean silentreconnect;
    private final JMXServiceURL serviceURL;
    private final ObjectName monitoringLog;
    private final CountDownLatch cdLatch = new CountDownLatch(1);
    private final String domain;
    private final String logname;
    private final int port;
    private final String server = this.configuration.getStringProperty("server");

    public JMXReader(Configuration configuation) throws IllegalArgumentException {
        super(configuation);
        this.port = this.configuration.getIntProperty(CONFIG_PROPERTY_NAME_PORT);
        String tmpServiceURL = this.port > 0 ? "service:jmx:rmi:///jndi/rmi://" + this.server + ":" + this.port + "/jmxrmi" : this.configuration.getStringProperty(CONFIG_PROPERTY_NAME_SERVICEURL);
        this.domain = this.configuration.getStringProperty(CONFIG_PROPERTY_NAME_DOMAIN);
        this.logname = this.configuration.getStringProperty(CONFIG_PROPERTY_NAME_LOGNAME);
        if (tmpServiceURL.length() == 0) {
            throw new IllegalArgumentException("JMXReader has not sufficient parameters. Set either port or serviceURL");
        }
        try {
            this.serviceURL = new JMXServiceURL(tmpServiceURL);
            this.monitoringLog = new ObjectName(this.domain, "type", this.logname);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException("Failed to parse configuration.", e);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Failed to parse configuration.", e);
        }
        this.silentreconnect = this.configuration.getBooleanProperty(CONFIG_PROPERTY_NAME_SILENT);
    }

    public void terminate(boolean error) {
        LOG.info("Shutdown of JMXReader requested.");
        this.unblock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public final boolean read() {
        boolean ret;
        block51: {
            Exception e2222222;
            LogNotificationListener logNotificationListener;
            ServerNotificationListener serverNotificationListener;
            MBeanServerConnection mbServer;
            JMXConnector jmx;
            block50: {
                block49: {
                    if (this.silentreconnect) {
                        return this.read2();
                    }
                    ret = true;
                    jmx = null;
                    mbServer = null;
                    serverNotificationListener = null;
                    logNotificationListener = null;
                    try {
                        jmx = JMXConnectorFactory.connect(this.serviceURL);
                    }
                    catch (IOException ex) {
                        boolean bl;
                        block48: {
                            Exception e2222222;
                            block47: {
                                block46: {
                                    LOG.error("Unable to connect to JMX Server (" + ex.getMessage() + ")");
                                    if (LOG.isDebugEnabled()) {
                                        LOG.debug("Error in JMX connection!", ex);
                                    }
                                    bl = false;
                                    Object var9_10 = null;
                                    try {
                                        if (logNotificationListener != null) {
                                            mbServer.removeNotificationListener(this.monitoringLog, logNotificationListener);
                                        }
                                    }
                                    catch (Exception e2222222) {
                                        if (!LOG.isDebugEnabled()) break block46;
                                        LOG.debug("Failed to remove Listener!", e2222222);
                                    }
                                }
                                try {
                                    if (serverNotificationListener != null) {
                                        jmx.removeConnectionNotificationListener(serverNotificationListener);
                                    }
                                }
                                catch (ListenerNotFoundException e2222222) {
                                    if (!LOG.isDebugEnabled()) break block47;
                                    LOG.debug("Failed to remove Listener!", e2222222);
                                }
                            }
                            try {
                                if (jmx != null) {
                                    jmx.close();
                                }
                            }
                            catch (Exception e2222222) {
                                if (!LOG.isDebugEnabled()) break block48;
                                LOG.debug("Failed to close JMX connection!", e2222222);
                            }
                        }
                        return bl;
                    }
                    serverNotificationListener = new ServerNotificationListener();
                    jmx.addConnectionNotificationListener(serverNotificationListener, null, null);
                    mbServer = jmx.getMBeanServerConnection();
                    logNotificationListener = new LogNotificationListener();
                    mbServer.addNotificationListener(this.monitoringLog, logNotificationListener, null, null);
                    LOG.info("Connected to JMX Server, ID: " + jmx.getConnectionId());
                    this.block();
                    LOG.info("Shutting down JMXReader");
                    Object var9_11 = null;
                    try {
                        if (logNotificationListener != null) {
                            mbServer.removeNotificationListener(this.monitoringLog, logNotificationListener);
                        }
                    }
                    catch (Exception e2222222) {
                        if (!LOG.isDebugEnabled()) break block49;
                        LOG.debug("Failed to remove Listener!", e2222222);
                    }
                }
                try {
                    if (serverNotificationListener != null) {
                        jmx.removeConnectionNotificationListener(serverNotificationListener);
                    }
                }
                catch (ListenerNotFoundException e2222222) {
                    if (!LOG.isDebugEnabled()) break block50;
                    LOG.debug("Failed to remove Listener!", e2222222);
                }
            }
            try {
                if (jmx != null) {
                    jmx.close();
                }
                break block51;
            }
            catch (Exception e2222222) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Failed to close JMX connection!", e2222222);
                }
                break block51;
            }
            {
                catch (InstanceNotFoundException ex) {
                    block53: {
                        block52: {
                            LOG.error("No monitoring log found: " + this.monitoringLog.toString());
                            ret = false;
                            Object var9_12 = null;
                            try {
                                if (logNotificationListener != null) {
                                    mbServer.removeNotificationListener(this.monitoringLog, logNotificationListener);
                                }
                            }
                            catch (Exception e2222222) {
                                if (!LOG.isDebugEnabled()) break block52;
                                LOG.debug("Failed to remove Listener!", e2222222);
                            }
                        }
                        try {
                            if (serverNotificationListener != null) {
                                jmx.removeConnectionNotificationListener(serverNotificationListener);
                            }
                        }
                        catch (ListenerNotFoundException e2222222) {
                            if (!LOG.isDebugEnabled()) break block53;
                            LOG.debug("Failed to remove Listener!", e2222222);
                        }
                    }
                    try {
                        if (jmx != null) {
                            jmx.close();
                        }
                        break block51;
                    }
                    catch (Exception e2222222) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Failed to close JMX connection!", e2222222);
                        }
                        break block51;
                    }
                }
                catch (Exception ex) {
                    block55: {
                        block54: {
                            LOG.error("Error in JMX connection!", ex);
                            ret = false;
                            Object var9_13 = null;
                            try {
                                if (logNotificationListener != null) {
                                    mbServer.removeNotificationListener(this.monitoringLog, logNotificationListener);
                                }
                            }
                            catch (Exception e2222222) {
                                if (!LOG.isDebugEnabled()) break block54;
                                LOG.debug("Failed to remove Listener!", e2222222);
                            }
                        }
                        try {
                            if (serverNotificationListener != null) {
                                jmx.removeConnectionNotificationListener(serverNotificationListener);
                            }
                        }
                        catch (ListenerNotFoundException e2222222) {
                            if (!LOG.isDebugEnabled()) break block55;
                            LOG.debug("Failed to remove Listener!", e2222222);
                        }
                    }
                    try {
                        if (jmx != null) {
                            jmx.close();
                        }
                        break block51;
                    }
                    catch (Exception e2222222) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Failed to close JMX connection!", e2222222);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                block58: {
                    block57: {
                        block56: {
                            Object var9_14 = null;
                            try {
                                if (logNotificationListener != null) {
                                    mbServer.removeNotificationListener(this.monitoringLog, logNotificationListener);
                                }
                            }
                            catch (Exception e2222222) {
                                if (!LOG.isDebugEnabled()) break block56;
                                LOG.debug("Failed to remove Listener!", e2222222);
                            }
                        }
                        try {
                            if (serverNotificationListener != null) {
                                jmx.removeConnectionNotificationListener(serverNotificationListener);
                            }
                        }
                        catch (ListenerNotFoundException e2222222) {
                            if (!LOG.isDebugEnabled()) break block57;
                            LOG.debug("Failed to remove Listener!", e2222222);
                        }
                    }
                    try {
                        if (jmx != null) {
                            jmx.close();
                        }
                    }
                    catch (Exception e2222222) {
                        if (!LOG.isDebugEnabled()) break block58;
                        LOG.debug("Failed to close JMX connection!", e2222222);
                    }
                }
                throw throwable;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final boolean read2() {
        while (true) {
            Exception e3222;
            Object var7_9;
            JMXConnector jmx = null;
            MBeanServerConnection mbServer = null;
            ServerNotificationListener serverNotificationListener = null;
            LogNotificationListener logNotificationListener = null;
            try {
                jmx = JMXConnectorFactory.connect(this.serviceURL);
            }
            catch (IOException e2) {
                Thread.sleep(10000L);
                var7_9 = null;
                try {
                    if (logNotificationListener != null) {
                        mbServer.removeNotificationListener(this.monitoringLog, logNotificationListener);
                    }
                }
                catch (Exception e3222) {
                    // empty catch block
                }
                try {
                    if (serverNotificationListener != null) {
                        jmx.removeConnectionNotificationListener(serverNotificationListener);
                    }
                }
                catch (ListenerNotFoundException e3222) {
                    // empty catch block
                }
                try {
                    if (jmx != null) {
                        jmx.close();
                    }
                    Thread.sleep(10000L);
                }
                catch (Exception e3222) {}
                continue;
            }
            serverNotificationListener = new ServerNotificationListener();
            jmx.addConnectionNotificationListener(serverNotificationListener, null, null);
            mbServer = jmx.getMBeanServerConnection();
            logNotificationListener = new LogNotificationListener();
            mbServer.addNotificationListener(this.monitoringLog, logNotificationListener, null, null);
            LOG.info("Connected to JMX Server, ID: " + jmx.getConnectionId());
            this.block();
            LOG.info("Shutting down JMXReader");
            var7_9 = null;
            try {
                if (logNotificationListener != null) {
                    mbServer.removeNotificationListener(this.monitoringLog, logNotificationListener);
                }
            }
            catch (Exception e3222) {
                // empty catch block
            }
            try {
                if (serverNotificationListener != null) {
                    jmx.removeConnectionNotificationListener(serverNotificationListener);
                }
            }
            catch (ListenerNotFoundException e3222) {
                // empty catch block
            }
            try {
                if (jmx != null) {
                    jmx.close();
                }
                Thread.sleep(10000L);
            }
            catch (Exception e3222) {}
            continue;
            {
                catch (InstanceNotFoundException e4) {
                    var7_9 = null;
                    try {
                        if (logNotificationListener != null) {
                            mbServer.removeNotificationListener(this.monitoringLog, logNotificationListener);
                        }
                    }
                    catch (Exception e3222) {
                        // empty catch block
                    }
                    try {
                        if (serverNotificationListener != null) {
                            jmx.removeConnectionNotificationListener(serverNotificationListener);
                        }
                    }
                    catch (ListenerNotFoundException e3222) {
                        // empty catch block
                    }
                    try {
                        if (jmx != null) {
                            jmx.close();
                        }
                        Thread.sleep(10000L);
                    }
                    catch (Exception e3222) {}
                    continue;
                }
                catch (Exception e5) {
                    LOG.error("Error in JMX connection!", e5);
                    var7_9 = null;
                    try {
                        if (logNotificationListener != null) {
                            mbServer.removeNotificationListener(this.monitoringLog, logNotificationListener);
                        }
                    }
                    catch (Exception e3222) {
                        // empty catch block
                    }
                    try {
                        if (serverNotificationListener != null) {
                            jmx.removeConnectionNotificationListener(serverNotificationListener);
                        }
                    }
                    catch (ListenerNotFoundException e3222) {
                        // empty catch block
                    }
                    try {
                        if (jmx != null) {
                            jmx.close();
                        }
                        Thread.sleep(10000L);
                    }
                    catch (Exception e3222) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                var7_9 = null;
                try {
                    if (logNotificationListener != null) {
                        mbServer.removeNotificationListener(this.monitoringLog, logNotificationListener);
                    }
                }
                catch (Exception e3222) {
                    // empty catch block
                }
                try {
                    if (serverNotificationListener != null) {
                        jmx.removeConnectionNotificationListener(serverNotificationListener);
                    }
                }
                catch (ListenerNotFoundException e3222) {
                    // empty catch block
                }
                try {
                    if (jmx != null) {
                        jmx.close();
                    }
                    Thread.sleep(10000L);
                }
                catch (Exception e3222) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private final void block() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public final void run() {
                JMXReader.this.unblock();
            }
        });
        try {
            this.cdLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    final void unblock() {
        this.cdLatch.countDown();
    }

    public Configuration getCurrentConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setProperty(CONFIG_PROPERTY_NAME_SERVER, this.server);
        configuration.setProperty(CONFIG_PROPERTY_NAME_PORT, Integer.toString(this.port));
        configuration.setProperty(CONFIG_PROPERTY_NAME_SERVICEURL, this.serviceURL.toString());
        configuration.setProperty(CONFIG_PROPERTY_NAME_DOMAIN, this.domain);
        configuration.setProperty(CONFIG_PROPERTY_NAME_LOGNAME, this.logname);
        configuration.setProperty(CONFIG_PROPERTY_NAME_SILENT, Boolean.toString(this.silentreconnect));
        return configuration;
    }

    private final class ServerNotificationListener
    implements NotificationListener {
        public final void handleNotification(Notification notification, Object handback) {
            String notificationType = notification.getType();
            if (notificationType.equals("jmx.remote.connection.closed")) {
                if (!JMXReader.this.silentreconnect) {
                    LOG.info("JMX connection closed.");
                }
                JMXReader.this.unblock();
            } else if (notificationType.equals("jmx.remote.connection.failed")) {
                if (!JMXReader.this.silentreconnect) {
                    LOG.info("JMX connection lost.");
                }
                JMXReader.this.unblock();
            } else if (notificationType.equals("jmx.remote.connection.notifs.lost")) {
                LOG.error("Monitoring record lost: " + notification.getMessage());
            } else {
                LOG.info(notificationType + ": " + notification.getMessage());
            }
        }
    }

    private final class LogNotificationListener
    implements NotificationListener {
        public final void handleNotification(Notification notification, Object handback) {
            JMXReader.super.deliver(JMXReader.OUTPUT_PORT_NAME_RECORDS, notification.getUserData());
        }
    }
}

