/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.flow.trace.operation;

import kieker.common.record.flow.ICallRecord;
import kieker.common.record.flow.IOperationRecord;
import kieker.common.record.flow.trace.operation.AbstractOperationEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallOperationEvent
extends AbstractOperationEvent
implements ICallRecord {
    private static final long serialVersionUID = 1193776099551467929L;
    private static final Class<?>[] TYPES = new Class[]{Long.TYPE, Long.TYPE, Integer.TYPE, String.class, String.class, String.class, String.class};
    private static final String NO_CALLEEOPERATIONSIGANTURE = "<no-calleeOperationSiganture>";
    private static final String NO_CALLEECLASSSIGANTURE = "";
    private final String calleeOperationSignature;
    private final String calleeClassSignature;

    public CallOperationEvent(long timestamp, long traceId, int orderIndex, String callerOperationSignature, String callerClassSignature, String calleeOperationSignature, String calleeClassSignature) {
        super(timestamp, traceId, orderIndex, callerOperationSignature, callerClassSignature);
        this.calleeOperationSignature = calleeOperationSignature == null ? NO_CALLEEOPERATIONSIGANTURE : calleeOperationSignature;
        this.calleeClassSignature = calleeClassSignature == null ? NO_CALLEECLASSSIGANTURE : calleeClassSignature;
    }

    public CallOperationEvent(Object[] values) {
        super(values, TYPES);
        this.calleeOperationSignature = (String)values[5];
        this.calleeClassSignature = (String)values[6];
    }

    protected CallOperationEvent(Object[] values, Class<?>[] types) {
        super(values, types);
        this.calleeOperationSignature = (String)values[5];
        this.calleeClassSignature = (String)values[6];
    }

    @Override
    public Object[] toArray() {
        return new Object[]{this.getTimestamp(), this.getTraceId(), this.getOrderIndex(), this.getCallerOperationSignature(), this.getCallerClassSignature(), this.getCalleeOperationSignature(), this.getCalleeClassSignature()};
    }

    @Override
    public Class<?>[] getValueTypes() {
        return (Class[])TYPES.clone();
    }

    @Override
    public final String getCallerOperationSignature() {
        return this.getOperationSignature();
    }

    @Override
    public final String getCallerClassSignature() {
        return this.getClassSignature();
    }

    @Override
    public final String getCalleeOperationSignature() {
        return this.calleeOperationSignature;
    }

    @Override
    public final String getCalleeClassSignature() {
        return this.calleeClassSignature;
    }

    @Override
    public final boolean callsReferencedOperationOf(IOperationRecord record) {
        return this.getCalleeOperationSignature().equals(record.getOperationSignature()) && this.getCalleeClassSignature().equals(record.getClassSignature());
    }
}

