/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.util;

import java.util.Arrays;

public class Signature {
    public static final String NO_RETURN_TYPE = "<NO-RETURN-TYPE>";
    private final String name;
    private final String[] modifierList;
    private final String returnType;
    private final String[] paramTypeList;

    public Signature(String name, String[] modifierList, String returnType, String[] paramTypeList) {
        this.name = name;
        this.modifierList = (String[])modifierList.clone();
        this.returnType = returnType == null ? NO_RETURN_TYPE : returnType;
        this.paramTypeList = (String[])paramTypeList.clone();
    }

    public final String getName() {
        return this.name;
    }

    public final String[] getModifier() {
        return (String[])this.modifierList.clone();
    }

    public final String[] getParamTypeList() {
        return (String[])this.paramTypeList.clone();
    }

    public final String getReturnType() {
        return this.returnType;
    }

    public final boolean hasReturnType() {
        return this.returnType != NO_RETURN_TYPE;
    }

    public String toString() {
        StringBuilder strBuild = new StringBuilder();
        for (String t : this.modifierList) {
            strBuild.append(t);
            strBuild.append(' ');
        }
        strBuild.append(this.name).append('(');
        boolean first = true;
        for (String t : this.paramTypeList) {
            if (!first) {
                strBuild.append(',');
            } else {
                first = false;
            }
            strBuild.append(t);
        }
        strBuild.append(')');
        if (this.hasReturnType()) {
            strBuild.append(':').append(this.returnType);
        }
        return strBuild.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.modifierList);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + Arrays.hashCode(this.paramTypeList);
        result = 31 * result + (this.returnType == null ? 0 : this.returnType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Signature other = (Signature)obj;
        if (!Arrays.equals(this.modifierList, other.modifierList)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (!Arrays.equals(this.paramTypeList, other.paramTypeList)) {
            return false;
        }
        return !(this.returnType == null ? other.returnType != null : !this.returnType.equals(other.returnType));
    }
}

