/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.core.controller;

import kieker.common.configuration.Configuration;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.monitoring.core.controller.AbstractController;
import kieker.monitoring.core.controller.IRegistryController;
import kieker.monitoring.core.registry.IRegistry;
import kieker.monitoring.core.registry.Registry;

public final class RegistryController
extends AbstractController
implements IRegistryController {
    private static final Log LOG = LogFactory.getLog(RegistryController.class);
    private final IRegistry<String> stringRegistry = new Registry<String>();

    protected RegistryController(Configuration configuration) {
        super(configuration);
    }

    protected final void init() {
        this.stringRegistry.setRecordReceiver(this.monitoringController);
    }

    protected final void cleanup() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Shutting down Registry Controller");
        }
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder(48);
        sb.append("RegistryController: ");
        sb.append(this.stringRegistry.getSize());
        sb.append(" strings registered.\n");
        return sb.toString();
    }

    public final int getIdForString(String string) {
        return this.stringRegistry.get(string);
    }
}

