/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.probe.cxf;

import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.core.controller.MonitoringController;
import kieker.monitoring.core.registry.ControlFlowRegistry;
import kieker.monitoring.core.registry.SessionRegistry;
import kieker.monitoring.probe.IMonitoringProbe;
import kieker.monitoring.probe.cxf.OperationExecutionSOAPResponseInInterceptor;
import kieker.monitoring.probe.cxf.SOAPHeaderConstants;
import kieker.monitoring.probe.cxf.SOAPTraceRegistry;
import kieker.monitoring.timer.ITimeSource;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.SoapHeaderOutFilterInterceptor;
import org.apache.cxf.headers.Header;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.interceptor.Fault;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OperationExecutionSOAPRequestOutInterceptor
extends SoapHeaderOutFilterInterceptor
implements IMonitoringProbe {
    public static final String SESSION_ID_ASYNC_TRACE = "NOSESSION-ASYNCOUT";
    protected static final ControlFlowRegistry CF_REGISTRY = ControlFlowRegistry.INSTANCE;
    protected static final SessionRegistry SESSION_REGISTRY = SessionRegistry.INSTANCE;
    protected static final SOAPTraceRegistry SOAP_REGISTRY = SOAPTraceRegistry.getInstance();
    protected final IMonitoringController monitoringController;
    protected final ITimeSource timeSource;

    public OperationExecutionSOAPRequestOutInterceptor() {
        this(MonitoringController.getInstance());
    }

    public OperationExecutionSOAPRequestOutInterceptor(IMonitoringController monitoringCtrl) {
        this.monitoringController = monitoringCtrl;
        this.timeSource = this.monitoringController.getTimeSource();
    }

    public void handleMessage(SoapMessage msg) throws Fault {
        int ess;
        int eoi;
        if (!this.monitoringController.isProbeActivated(OperationExecutionSOAPResponseInInterceptor.SIGNATURE)) {
            return;
        }
        String sessionID = SESSION_REGISTRY.recallThreadLocalSessionId();
        long traceId = CF_REGISTRY.recallThreadLocalTraceId();
        long tin = this.timeSource.getTime();
        boolean isEntryCall = false;
        if (traceId == -1L) {
            traceId = CF_REGISTRY.getAndStoreUniqueThreadLocalTraceId();
            eoi = 0;
            CF_REGISTRY.storeThreadLocalEOI(eoi);
            ess = 0;
            CF_REGISTRY.storeThreadLocalESS(ess);
            isEntryCall = true;
            if (sessionID == null) {
                sessionID = SESSION_ID_ASYNC_TRACE;
                SESSION_REGISTRY.storeThreadLocalSessionId(sessionID);
            }
        } else {
            eoi = CF_REGISTRY.incrementAndRecallThreadLocalEOI();
            ess = CF_REGISTRY.recallThreadLocalESS();
            if (sessionID == null) {
                sessionID = "<no-session-id>";
            }
        }
        SOAP_REGISTRY.storeThreadLocalOutRequestIsEntryCall(isEntryCall);
        SOAP_REGISTRY.storeThreadLocalOutRequestTin(tin);
        Document d = DOMUtils.createDocument();
        Element e = d.createElementNS("http://kieker-monitoring.net", "sessionId");
        e.setTextContent(sessionID);
        Header hdr = new Header(SOAPHeaderConstants.SESSION_IDENTIFIER_QNAME, (Object)e);
        msg.getHeaders().add(hdr);
        e = d.createElementNS("http://kieker-monitoring.net", "traceId");
        e.setTextContent(Long.toString(traceId));
        hdr = new Header(SOAPHeaderConstants.TRACE_IDENTIFIER_QNAME, (Object)e);
        msg.getHeaders().add(hdr);
        e = d.createElementNS("http://kieker-monitoring.net", "eoi");
        e.setTextContent(Integer.toString(eoi));
        hdr = new Header(SOAPHeaderConstants.EOI_IDENTIFIER_QNAME, (Object)e);
        msg.getHeaders().add(hdr);
        e = d.createElementNS("http://kieker-monitoring.net", "ess");
        e.setTextContent(Integer.toString(ess + 1));
        hdr = new Header(SOAPHeaderConstants.ESS_IDENTIFIER_QNAME, (Object)e);
        msg.getHeaders().add(hdr);
    }
}

