/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.probe.manual;

import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.common.record.controlflow.BranchingRecord;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.core.controller.MonitoringController;
import kieker.monitoring.probe.IMonitoringProbe;
import kieker.monitoring.timer.ITimeSource;

public final class BranchingProbe
implements IMonitoringProbe {
    private static final Log LOG = LogFactory.getLog(BranchingProbe.class);
    private static final IMonitoringController CTRLINST = MonitoringController.getInstance();
    private static final ITimeSource TIMESOURCE = CTRLINST.getTimeSource();

    private BranchingProbe() {
    }

    public static final void monitorBranch(int branchID, int branchingOutcome) {
        if (!CTRLINST.isMonitoringEnabled()) {
            return;
        }
        try {
            CTRLINST.newMonitoringRecord(new BranchingRecord(TIMESOURCE.getTime(), branchID, branchingOutcome));
        }
        catch (Exception ex) {
            LOG.error("Error monitoring branching", ex);
        }
    }
}

