/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.probe.sigar.samplers;

import kieker.common.record.system.CPUUtilizationRecord;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.probe.sigar.samplers.AbstractSigarSampler;
import kieker.monitoring.timer.ITimeSource;
import org.hyperic.sigar.CpuPerc;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarProxy;

public final class CPUsDetailedPercSampler
extends AbstractSigarSampler {
    public CPUsDetailedPercSampler(SigarProxy sigar) {
        super(sigar);
    }

    public void sample(IMonitoringController monitoringController) throws SigarException {
        if (!monitoringController.isMonitoringEnabled()) {
            return;
        }
        CpuPerc[] cpus = this.sigar.getCpuPercList();
        ITimeSource timesource = monitoringController.getTimeSource();
        for (int i = 0; i < cpus.length; ++i) {
            CpuPerc curCPU = cpus[i];
            CPUUtilizationRecord r = new CPUUtilizationRecord(timesource.getTime(), monitoringController.getHostname(), Integer.toString(i), curCPU.getUser(), curCPU.getSys(), curCPU.getWait(), curCPU.getNice(), curCPU.getIrq(), curCPU.getCombined(), curCPU.getIdle());
            monitoringController.newMonitoringRecord(r);
        }
    }
}

