/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.writer.database;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kieker.common.configuration.Configuration;
import kieker.monitoring.writer.AbstractAsyncWriter;
import kieker.monitoring.writer.database.DBWriterHelper;
import kieker.monitoring.writer.database.DbWriterThread;

public final class AsyncDbWriter
extends AbstractAsyncWriter {
    private static final String PREFIX = AsyncDbWriter.class.getName() + ".";
    public static final String CONFIG_DRIVERCLASSNAME = PREFIX + "DriverClassname";
    public static final String CONFIG_CONNECTIONSTRING = PREFIX + "ConnectionString";
    public static final String CONFIG_TABLEPREFIX = PREFIX + "TablePrefix";
    public static final String CONFIG_NRCONN = PREFIX + "numberOfConnections";
    public static final String CONFIG_OVERWRITE = PREFIX + "DropTables";

    public AsyncDbWriter(Configuration configuration) throws Exception {
        super(configuration);
        try {
            Class.forName(this.configuration.getStringProperty(CONFIG_DRIVERCLASSNAME)).newInstance();
        }
        catch (Exception ex) {
            throw new Exception("DB driver registration failed. Perhaps the driver jar is missing?", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init() throws Exception {
        boolean overwrite;
        String tablePrefix;
        String connectionString;
        AtomicInteger tableCounter;
        block8: {
            tableCounter = new AtomicInteger();
            connectionString = this.configuration.getStringProperty(CONFIG_CONNECTIONSTRING);
            tablePrefix = this.configuration.getStringProperty(CONFIG_TABLEPREFIX);
            overwrite = this.configuration.getBooleanProperty(CONFIG_OVERWRITE);
            Connection connection = null;
            try {
                try {
                    connection = DriverManager.getConnection(connectionString);
                    new DBWriterHelper(connection, tablePrefix, tableCounter, overwrite).createIndexTable();
                }
                catch (SQLException ex) {
                    throw new Exception("SQLException with SQLState: '" + ex.getSQLState() + "' and VendorError: '" + ex.getErrorCode() + "'", ex);
                }
                Object var8_6 = null;
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                if (connection == null) throw throwable;
                connection.close();
                throw throwable;
            }
            connection.close();
        }
        AtomicLong recordId = new AtomicLong();
        try {
            for (int i = 0; i < this.configuration.getIntProperty(CONFIG_NRCONN); ++i) {
                this.addWorker(new DbWriterThread(this.monitoringController, this.blockingQueue, connectionString, tablePrefix, tableCounter, recordId, overwrite));
            }
            return;
        }
        catch (SQLException ex) {
            throw new Exception("SQLException with SQLState: '" + ex.getSQLState() + "' and VendorError: '" + ex.getErrorCode() + "'", ex);
        }
    }
}

