/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.writer.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DBWriterHelper {
    private static final Log LOG = LogFactory.getLog(DBWriterHelper.class);
    private final Connection connection;
    private final String indexTablename;
    private final AtomicInteger tableCounter;
    private final boolean overwrite;
    private final Map<Class<?>, String> createTypeMap = new ConcurrentHashMap();

    public DBWriterHelper(Connection connection, String indexTablename, boolean overwrite) throws SQLException {
        this(connection, indexTablename, new AtomicInteger(), overwrite);
    }

    public DBWriterHelper(Connection connection, String indexTablename, AtomicInteger tableCounter, boolean overwrite) throws SQLException {
        this.connection = connection;
        ResultSet databaseTypeInfo = connection.getMetaData().getTypeInfo();
        while (databaseTypeInfo.next()) {
            int id = databaseTypeInfo.getInt("DATA_TYPE");
            String typeName = databaseTypeInfo.getString("TYPE_NAME");
            String typeParams = databaseTypeInfo.getString("CREATE_PARAMS");
            switch (id) {
                case 12: {
                    if (typeParams != null) {
                        this.createTypeMap.put(String.class, typeName + " (1024)");
                        break;
                    }
                    this.createTypeMap.put(String.class, typeName);
                    break;
                }
                case 4: {
                    this.createTypeMap.put(Integer.TYPE, typeName);
                    this.createTypeMap.put(Integer.class, typeName);
                    break;
                }
                case -5: {
                    this.createTypeMap.put(Long.TYPE, typeName);
                    this.createTypeMap.put(Long.class, typeName);
                    break;
                }
                case 7: {
                    this.createTypeMap.put(Float.TYPE, typeName);
                    this.createTypeMap.put(Float.class, typeName);
                    break;
                }
                case 8: {
                    this.createTypeMap.put(Double.TYPE, typeName);
                    this.createTypeMap.put(Double.class, typeName);
                    break;
                }
                case -6: {
                    this.createTypeMap.put(Byte.TYPE, typeName);
                    this.createTypeMap.put(Byte.class, typeName);
                    break;
                }
                case 5: {
                    this.createTypeMap.put(Short.TYPE, typeName);
                    this.createTypeMap.put(Short.class, typeName);
                    break;
                }
                case -7: {
                    this.createTypeMap.put(Boolean.TYPE, typeName);
                    this.createTypeMap.put(Boolean.class, typeName);
                    break;
                }
            }
        }
        databaseTypeInfo.close();
        this.indexTablename = indexTablename;
        this.tableCounter = tableCounter;
        this.overwrite = overwrite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String createTable(String classname, Class<?> ... columns) throws SQLException {
        Statement statement;
        String tablename;
        block14: {
            block13: {
                tablename = this.indexTablename + "_" + this.tableCounter.getAndIncrement();
                if (this.overwrite) {
                    String statementDropTableString = "DROP TABLE " + tablename;
                    Statement statementDropTable = null;
                    try {
                        Object var8_6;
                        try {
                            statementDropTable = this.connection.createStatement();
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Dropping table: " + statementDropTableString);
                            }
                            statementDropTable.execute(statementDropTableString);
                        }
                        catch (SQLException ignore) {
                            var8_6 = null;
                            if (statementDropTable != null) {
                                statementDropTable.close();
                            }
                            break block13;
                        }
                        var8_6 = null;
                        if (statementDropTable == null) break block13;
                    }
                    catch (Throwable throwable) {
                        Object var8_7 = null;
                        if (statementDropTable == null) throw throwable;
                        statementDropTable.close();
                        throw throwable;
                    }
                    statementDropTable.close();
                }
            }
            StringBuilder statementCreateTable = new StringBuilder(128);
            statementCreateTable.append("CREATE TABLE ").append(tablename).append(" (id ");
            String createLong = this.createTypeMap.get(Long.TYPE);
            if (createLong == null) throw new SQLException("Type 'long' not supported.");
            statementCreateTable.append(createLong);
            statementCreateTable.append(", timestamp ").append(createLong);
            int i = 1;
            for (Class<?> c : columns) {
                statementCreateTable.append(", c").append(i++).append(' ');
                String createType = this.createTypeMap.get(c);
                if (createType == null) throw new SQLException("Type '" + c.getSimpleName() + "' not supported.");
                statementCreateTable.append(createType);
            }
            statementCreateTable.append(')');
            String statementCreateTableString = statementCreateTable.toString();
            statement = null;
            try {
                statement = this.connection.createStatement();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Creating table: " + statementCreateTableString);
                }
                statement.execute(statementCreateTableString);
                Object var13_17 = null;
                if (statement == null) break block14;
            }
            catch (Throwable throwable) {
                Object var13_18 = null;
                if (statement == null) throw throwable;
                statement.close();
                throw throwable;
            }
            statement.close();
        }
        try {
            statement = this.connection.createStatement();
            statement.executeUpdate("INSERT INTO " + this.indexTablename + " VALUES ('" + tablename + "','" + classname + "')");
            Object var15_20 = null;
            if (statement == null) return tablename;
        }
        catch (Throwable throwable) {
            Object var15_21 = null;
            if (statement == null) throw throwable;
            statement.close();
            throw throwable;
        }
        statement.close();
        return tablename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createIndexTable() throws SQLException {
        String createString;
        block11: {
            createString = this.createTypeMap.get(String.class);
            if (createString == null) {
                throw new SQLException("Type 'String' not supported.");
            }
            if (this.overwrite) {
                String statementDropTableString = "DROP TABLE " + this.indexTablename;
                Statement statementDropTable = null;
                try {
                    try {
                        statementDropTable = this.connection.createStatement();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Dropping table: " + statementDropTableString);
                        }
                        statementDropTable.execute(statementDropTableString);
                    }
                    catch (SQLException ignore) {
                        Object var6_5 = null;
                        if (statementDropTable != null) {
                            statementDropTable.close();
                        }
                        break block11;
                    }
                    Object var6_4 = null;
                    if (statementDropTable == null) break block11;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    if (statementDropTable == null) throw throwable;
                    statementDropTable.close();
                    throw throwable;
                }
                statementDropTable.close();
            }
        }
        StringBuilder statementCreateTable = new StringBuilder(128);
        statementCreateTable.append("CREATE TABLE ").append(this.indexTablename);
        statementCreateTable.append(" (tablename ").append(createString).append(", classname ").append(createString).append(')');
        String statementCreateTableString = statementCreateTable.toString();
        Statement statement = null;
        try {
            statement = this.connection.createStatement();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Creating table: " + statementCreateTableString);
            }
            statement.execute(statementCreateTableString);
            Object var8_10 = null;
            if (statement == null) return;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (statement == null) throw throwable;
            statement.close();
            throw throwable;
        }
        statement.close();
    }

    public boolean set(PreparedStatement preparedStatement, int parameterIndex, Object value) throws SQLException {
        if (value instanceof String) {
            preparedStatement.setString(parameterIndex, (String)value);
        } else if (value instanceof Integer) {
            preparedStatement.setInt(parameterIndex, (Integer)value);
        } else if (value instanceof Long) {
            preparedStatement.setLong(parameterIndex, (Long)value);
        } else if (value instanceof Float) {
            preparedStatement.setFloat(parameterIndex, ((Float)value).floatValue());
        } else if (value instanceof Double) {
            preparedStatement.setDouble(parameterIndex, (Double)value);
        } else if (value instanceof Byte) {
            preparedStatement.setByte(parameterIndex, (Byte)value);
        } else if (value instanceof Short) {
            preparedStatement.setShort(parameterIndex, (Short)value);
        } else if (value instanceof Boolean) {
            preparedStatement.setBoolean(parameterIndex, (Boolean)value);
        } else {
            if (value == null) {
                LOG.error("Null value in record not supported!");
                return false;
            }
            LOG.error("Type '" + value.getClass().getSimpleName() + "' not supported");
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("Prefix: '");
        sb.append(this.indexTablename);
        sb.append("'; Drop Tables: '");
        sb.append(this.overwrite);
        sb.append("'; Created Tables: '");
        sb.append(this.tableCounter.get());
        sb.append('\'');
        return sb.toString();
    }
}

