/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.currentTimeEventGenerator;

import kieker.analysis.plugin.annotation.InputPort;
import kieker.analysis.plugin.annotation.OutputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.Property;
import kieker.analysis.plugin.filter.AbstractFilterPlugin;
import kieker.common.configuration.Configuration;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.common.record.IMonitoringRecord;
import kieker.common.record.misc.TimestampRecord;

@Plugin(description="Generates time events with a given resolution based on the timestamps of incoming IMonitoringRecords", outputPorts={@OutputPort(name="currentTimeRecord", eventTypes={TimestampRecord.class}, description="Provides current time events"), @OutputPort(name="currentTimeValue", eventTypes={Long.class}, description="Provides current time values")}, configuration={@Property(name="timeResolution", defaultValue="1000")})
public class CurrentTimeEventGenerationFilter
extends AbstractFilterPlugin {
    public static final String INPUT_PORT_NAME_NEW_TIMESTAMP = "inputNewTimestamp";
    public static final String INPUT_PORT_NAME_NEW_RECORD = "inputNewRecord";
    public static final String OUTPUT_PORT_NAME_CURRENT_TIME_RECORD = "currentTimeRecord";
    public static final String OUTPUT_PORT_NAME_CURRENT_TIME_VALUE = "currentTimeValue";
    public static final String CONFIG_PROPERTY_NAME_TIME_RESOLUTION = "timeResolution";
    private static final Log LOG = LogFactory.getLog(CurrentTimeEventGenerationFilter.class);
    private volatile long firstTimestamp = -1L;
    private volatile long maxTimestamp = -1L;
    private volatile long mostRecentEventFired = -1L;
    private final long timerResolution;

    public CurrentTimeEventGenerationFilter(Configuration configuration) {
        super(configuration);
        this.timerResolution = configuration.getLongProperty(CONFIG_PROPERTY_NAME_TIME_RESOLUTION);
    }

    @InputPort(name="inputNewRecord", eventTypes={IMonitoringRecord.class}, description="Receives a new timestamp and extracts the logging timestamp as a time event")
    public void inputRecord(IMonitoringRecord record) {
        if (record != null) {
            this.inputTimestamp(record.getLoggingTimestamp());
        }
    }

    @InputPort(name="inputNewTimestamp", description="Receives a new timestamp as a time event", eventTypes={Long.class})
    public void inputTimestamp(Long timestamp) {
        if (timestamp < 0L) {
            LOG.warn("Received timestamp value < 0: " + timestamp);
            return;
        }
        if (this.firstTimestamp == -1L) {
            this.maxTimestamp = timestamp;
            this.firstTimestamp = timestamp;
            super.deliver(OUTPUT_PORT_NAME_CURRENT_TIME_RECORD, new TimestampRecord(timestamp));
            super.deliver(OUTPUT_PORT_NAME_CURRENT_TIME_VALUE, timestamp);
            this.mostRecentEventFired = timestamp;
        } else if (timestamp > this.maxTimestamp) {
            this.maxTimestamp = timestamp;
            long nextTimerEventAt = this.mostRecentEventFired + this.timerResolution;
            while (timestamp >= nextTimerEventAt) {
                super.deliver(OUTPUT_PORT_NAME_CURRENT_TIME_RECORD, new TimestampRecord(nextTimerEventAt));
                super.deliver(OUTPUT_PORT_NAME_CURRENT_TIME_VALUE, nextTimerEventAt);
                this.mostRecentEventFired = nextTimerEventAt;
                nextTimerEventAt = this.mostRecentEventFired + this.timerResolution;
            }
        }
    }

    public Configuration getCurrentConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setProperty(CONFIG_PROPERTY_NAME_TIME_RESOLUTION, Long.toString(this.timerResolution));
        return configuration;
    }
}

