/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.logReplayer;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.tools.logReplayer.FilesystemLogReplayer;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public final class FilesystemLogReplayerStarter {
    private static final Log LOG = LogFactory.getLog(FilesystemLogReplayerStarter.class);
    private static CommandLine cmdl;
    private static final CommandLineParser CMDL_PARSER;
    private static final HelpFormatter CMD_HELP_FORMATTER;
    private static final Options CMDL_OPTS;
    private static final String CMD_OPT_NAME_MONITORING_CONFIGURATION = "monitoring.configuration";
    private static final String CMD_OPT_NAME_INPUTDIRS = "inputdirs";
    private static final String CMD_OPT_NAME_KEEPORIGINALLOGGINGTIMESTAMPS = "keep-logging-timestamps";
    private static final String CMD_OPT_NAME_REALTIME = "realtime";
    private static final String CMD_OPT_NAME_NUM_REALTIME_WORKERS = "realtime-worker-threads";
    private static final String CMD_OPT_NAME_IGNORERECORDSBEFOREDATE = "ignore-records-before-date";
    private static final String CMD_OPT_NAME_IGNORERECORDSAFTERDATE = "ignore-records-after-date";
    private static final String DATE_FORMAT_PATTERN = "yyyyMMdd'-'HHmmss";
    private static final String DATE_FORMAT_PATTERN_CMD_USAGE_HELP;
    private static final String OPTION_EXAMPLE_FILE_MONITORING_PROPERTIES;
    private static String monitoringConfigurationFile;
    private static String[] inputDirs;
    private static boolean keepOriginalLoggingTimestamps;
    private static boolean realtimeMode;
    private static int numRealtimeWorkerThreads;
    private static long ignoreRecordsBeforeTimestamp;
    private static long ignoreRecordsAfterTimestamp;

    private FilesystemLogReplayerStarter() {
    }

    private static boolean parseArgs(String[] args) {
        try {
            cmdl = CMDL_PARSER.parse(CMDL_OPTS, args);
        }
        catch (ParseException e) {
            System.err.println("Error parsing arguments: " + e.getMessage());
            FilesystemLogReplayerStarter.printUsage();
            return false;
        }
        return true;
    }

    private static void printUsage() {
        CMD_HELP_FORMATTER.printHelp(FilesystemLogReplayerStarter.class.getName(), CMDL_OPTS);
    }

    private static boolean initFromArgs() {
        boolean retVal = true;
        monitoringConfigurationFile = cmdl.getOptionValue(CMD_OPT_NAME_MONITORING_CONFIGURATION);
        inputDirs = cmdl.getOptionValues(CMD_OPT_NAME_INPUTDIRS);
        String keepOriginalLoggingTimestampsOptValStr = cmdl.getOptionValue(CMD_OPT_NAME_KEEPORIGINALLOGGINGTIMESTAMPS, "true");
        if (!"true".equals(keepOriginalLoggingTimestampsOptValStr) && !"false".equals(keepOriginalLoggingTimestampsOptValStr)) {
            System.out.println("Invalid value for option keep-logging-timestamps: '" + keepOriginalLoggingTimestampsOptValStr + "'");
            retVal = false;
        }
        keepOriginalLoggingTimestamps = "true".equals(keepOriginalLoggingTimestampsOptValStr);
        LOG.info("Keeping original logging timestamps: " + (keepOriginalLoggingTimestamps ? "true" : "false"));
        String realtimeOptValStr = cmdl.getOptionValue(CMD_OPT_NAME_REALTIME, "false");
        if (!"true".equals(realtimeOptValStr) && !"false".equals(realtimeOptValStr)) {
            System.out.println("Invalid value for option realtime: '" + realtimeOptValStr + "'");
            retVal = false;
        }
        realtimeMode = "true".equals(realtimeOptValStr);
        String numRealtimeWorkerThreadsStr = cmdl.getOptionValue(CMD_OPT_NAME_NUM_REALTIME_WORKERS, "1");
        try {
            numRealtimeWorkerThreads = Integer.parseInt(numRealtimeWorkerThreadsStr);
        }
        catch (NumberFormatException ex) {
            System.out.println("Invalid value for option realtime-worker-threads: '" + numRealtimeWorkerThreadsStr + "'");
            LOG.error("NumberFormatException: ", ex);
            retVal = false;
        }
        if (numRealtimeWorkerThreads < 1) {
            System.out.println("Option value for realtime-worker-threads must be >= 1; found " + numRealtimeWorkerThreads);
            LOG.error("Invalid specification of realtime-worker-threads:" + numRealtimeWorkerThreads);
            retVal = false;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT_PATTERN, Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        try {
            String ignoreRecordsBeforeTimestampString = cmdl.getOptionValue(CMD_OPT_NAME_IGNORERECORDSBEFOREDATE, null);
            String ignoreRecordsAfterTimestampString = cmdl.getOptionValue(CMD_OPT_NAME_IGNORERECORDSAFTERDATE, null);
            if (ignoreRecordsBeforeTimestampString != null) {
                Date ignoreBeforeDate = dateFormat.parse(ignoreRecordsBeforeTimestampString);
                ignoreRecordsBeforeTimestamp = ignoreBeforeDate.getTime() * 1000000L;
                LOG.info("Ignoring records before " + dateFormat.format(ignoreBeforeDate) + " (" + ignoreRecordsBeforeTimestamp + ")");
            }
            if (ignoreRecordsAfterTimestampString != null) {
                Date ignoreAfterDate = dateFormat.parse(ignoreRecordsAfterTimestampString);
                ignoreRecordsAfterTimestamp = ignoreAfterDate.getTime() * 1000000L;
                LOG.info("Ignoring records after " + dateFormat.format(ignoreAfterDate) + " (" + ignoreRecordsAfterTimestamp + ")");
            }
        }
        catch (java.text.ParseException ex) {
            String erorMsg = "Error parsing date/time string. Please use the following pattern: " + DATE_FORMAT_PATTERN_CMD_USAGE_HELP;
            System.err.println(erorMsg);
            LOG.error(erorMsg, ex);
            return false;
        }
        if (retVal) {
            LOG.info("inputDirs: " + FilesystemLogReplayerStarter.fromStringArrayToDeliminedString(inputDirs, ';'));
            LOG.info("Replaying in " + (realtimeMode ? "" : "non-") + "realtime mode");
            if (realtimeMode) {
                LOG.info("Using " + numRealtimeWorkerThreads + " realtime worker thread" + (numRealtimeWorkerThreads > 1 ? "s" : ""));
            }
        }
        return retVal;
    }

    private static String fromStringArrayToDeliminedString(String[] array, char delimiter) {
        StringBuilder arTostr = new StringBuilder();
        if (array.length > 0) {
            arTostr.append(array[0]);
            for (int i = 1; i < array.length; ++i) {
                arTostr.append(delimiter);
                arTostr.append(array[i]);
            }
        }
        return arTostr.toString();
    }

    public static void main(String[] args) {
        if (!FilesystemLogReplayerStarter.parseArgs(args) || !FilesystemLogReplayerStarter.initFromArgs()) {
            System.exit(1);
        }
        if (realtimeMode) {
            LOG.info("Replaying log data in real time");
        } else {
            LOG.info("Replaying log data in non-real time");
        }
        FilesystemLogReplayer player = new FilesystemLogReplayer(monitoringConfigurationFile, realtimeMode, keepOriginalLoggingTimestamps, numRealtimeWorkerThreads, ignoreRecordsBeforeTimestamp, ignoreRecordsAfterTimestamp, inputDirs);
        if (!player.replay()) {
            System.err.println("An error occured");
            System.err.println("");
            System.err.println("See 'kieker.log' for details");
            System.exit(1);
        }
    }

    static {
        CMDL_PARSER = new BasicParser();
        CMD_HELP_FORMATTER = new HelpFormatter();
        CMDL_OPTS = new Options();
        DATE_FORMAT_PATTERN_CMD_USAGE_HELP = DATE_FORMAT_PATTERN.replaceAll("'", "");
        OPTION_EXAMPLE_FILE_MONITORING_PROPERTIES = File.separator + "path" + File.separator + "to" + File.separator + "monitoring.properties";
        numRealtimeWorkerThreads = -1;
        ignoreRecordsBeforeTimestamp = 0L;
        ignoreRecordsAfterTimestamp = Long.MAX_VALUE;
        OptionBuilder.withArgName((String)OPTION_EXAMPLE_FILE_MONITORING_PROPERTIES);
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)CMD_OPT_NAME_MONITORING_CONFIGURATION);
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Configuration to use for the Kieker monitoring instance");
        OptionBuilder.withValueSeparator((char)'=');
        CMDL_OPTS.addOption(OptionBuilder.create((String)"c"));
        OptionBuilder.withArgName((String)"dir1 ... dirN");
        OptionBuilder.hasArgs();
        OptionBuilder.withLongOpt((String)CMD_OPT_NAME_INPUTDIRS);
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Log directories to read data from");
        OptionBuilder.withValueSeparator((char)'=');
        CMDL_OPTS.addOption(OptionBuilder.create((String)"i"));
        OptionBuilder.withArgName((String)"true|false");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)CMD_OPT_NAME_KEEPORIGINALLOGGINGTIMESTAMPS);
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Replay the original logging timestamps (defaults to true)?)");
        OptionBuilder.withValueSeparator((char)'=');
        CMDL_OPTS.addOption(OptionBuilder.create((String)"k"));
        OptionBuilder.withArgName((String)"true|false");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)CMD_OPT_NAME_REALTIME);
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Replay log data in realtime?");
        OptionBuilder.withValueSeparator((char)'=');
        CMDL_OPTS.addOption(OptionBuilder.create((String)"r"));
        OptionBuilder.withArgName((String)"num");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)CMD_OPT_NAME_NUM_REALTIME_WORKERS);
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Number of worker threads used in realtime mode (defaults to 1).");
        OptionBuilder.withValueSeparator((char)'=');
        CMDL_OPTS.addOption(OptionBuilder.create((String)"n"));
        OptionBuilder.withLongOpt((String)CMD_OPT_NAME_IGNORERECORDSBEFOREDATE);
        OptionBuilder.withArgName((String)DATE_FORMAT_PATTERN_CMD_USAGE_HELP);
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Records logged before this date (UTC timezone) are ignored (disabled by default).");
        CMDL_OPTS.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)CMD_OPT_NAME_IGNORERECORDSAFTERDATE);
        OptionBuilder.withArgName((String)DATE_FORMAT_PATTERN_CMD_USAGE_HELP);
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Records logged after this date (UTC timezone) are ignored (disabled by default).");
        CMDL_OPTS.addOption(OptionBuilder.create());
    }
}

