/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.loggingTimestampConverter;

import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.tools.util.LoggingTimestampConverter;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public final class LoggingTimestampConverterTool {
    private static final Log LOG = LogFactory.getLog(LoggingTimestampConverterTool.class);
    private static final CommandLineParser CMDL_PARSER = new BasicParser();
    private static final HelpFormatter CMD_HELP_FORMATTER = new HelpFormatter();
    private static final Options CMDL_OPTS = new Options();
    private static final List<Option> OPTIONS = new CopyOnWriteArrayList<Option>();
    private static final String CMD_OPT_NAME_TIMESTAMPS = "timestamps";
    private static CommandLine cmdl;
    private static String[] timestampsStr;
    private static long[] timestampsLong;

    private LoggingTimestampConverterTool() {
    }

    private static final void initializeOptions() {
        OptionBuilder.withLongOpt((String)CMD_OPT_NAME_TIMESTAMPS);
        OptionBuilder.withArgName((String)"timestamp1 ... timestampN");
        OptionBuilder.hasArgs();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"List of timestamps (UTC timezone) to convert");
        OPTIONS.add(OptionBuilder.create((String)"t"));
        for (Option o : OPTIONS) {
            CMDL_OPTS.addOption(o);
        }
        CMD_HELP_FORMATTER.setOptionComparator((Comparator)new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                int posO2;
                if (o1 == o2) {
                    return 0;
                }
                int posO1 = OPTIONS.indexOf(o1);
                if (posO1 < (posO2 = OPTIONS.indexOf(o2))) {
                    return -1;
                }
                if (posO1 > posO2) {
                    return 1;
                }
                return 0;
            }
        });
    }

    public static void main(String[] args) {
        if (!LoggingTimestampConverterTool.parseArgs(args) || !LoggingTimestampConverterTool.initFromArgs()) {
            System.exit(1);
        }
        for (long tstamp : timestampsLong) {
            StringBuilder strB = new StringBuilder();
            strB.append(tstamp).append(": ").append(LoggingTimestampConverter.convertLoggingTimestampToUTCString(tstamp)).append(" (").append(LoggingTimestampConverter.convertLoggingTimestampLocalTimeZoneString(tstamp)).append(')');
            System.out.println(strB.toString());
        }
    }

    private static boolean parseArgs(String[] args) {
        try {
            cmdl = CMDL_PARSER.parse(CMDL_OPTS, args);
        }
        catch (ParseException e) {
            LoggingTimestampConverterTool.printUsage();
            System.err.println("\nError parsing arguments: " + e.getMessage());
            return false;
        }
        return true;
    }

    private static void printUsage() {
        CMD_HELP_FORMATTER.printHelp(80, LoggingTimestampConverterTool.class.getName(), "", CMDL_OPTS, "", true);
    }

    private static boolean initFromArgs() {
        timestampsStr = cmdl.getOptionValues(CMD_OPT_NAME_TIMESTAMPS);
        if (timestampsStr == null) {
            LOG.error("Missing value for option 'timestamps'");
            return false;
        }
        timestampsLong = new long[timestampsStr.length];
        for (int curIdx = 0; curIdx < timestampsStr.length; ++curIdx) {
            try {
                LoggingTimestampConverterTool.timestampsLong[curIdx] = Long.parseLong(timestampsStr[curIdx]);
                continue;
            }
            catch (NumberFormatException ex) {
                LOG.error("Failed to parse timestamp:" + timestampsStr[curIdx], ex);
                System.err.println("Failed to parse timestamp:" + timestampsStr[curIdx]);
                return false;
            }
        }
        return true;
    }

    static {
        LoggingTimestampConverterTool.initializeOptions();
    }
}

