/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.traceAnalysis.filter.executionFilter;

import kieker.analysis.plugin.annotation.InputPort;
import kieker.analysis.plugin.annotation.OutputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.Property;
import kieker.common.configuration.Configuration;
import kieker.tools.traceAnalysis.filter.AbstractTimestampFilter;
import kieker.tools.traceAnalysis.systemModel.Execution;

@Plugin(description="A filter allowing to filter incoming execution objects based on their timestamps", outputPorts={@OutputPort(name="executionsWithinTimePeriod", description="Fowards records within the timeperiod", eventTypes={Execution.class})}, configuration={@Property(name="ignoreExecutionsBeforeTimestamp", defaultValue="0"), @Property(name="ignoreExecutionsAfterTimestamp", defaultValue="9223372036854775807")})
public class TimestampFilter
extends AbstractTimestampFilter {
    public static final String INPUT_PORT_NAME_EXECUTION = "executions";
    public static final String OUTPUT_PORT_NAME_WITHIN_PERIOD = "executionsWithinTimePeriod";
    public static final String CONFIG_PROPERTY_NAME_IGNORE_BEFORE_TIMESTAMP = "ignoreExecutionsBeforeTimestamp";
    public static final String CONFIG_PROPERTY_NAME_IGNORE_AFTER_TIMESTAMP = "ignoreExecutionsAfterTimestamp";

    public TimestampFilter(Configuration configuration) {
        super(configuration);
    }

    @InputPort(name="executions", description="Receives executions to be selected by their logging timestamps", eventTypes={Execution.class})
    public void inputExecution(Execution execution) {
        if (this.inRange(execution.getTin()) && this.inRange(execution.getTout())) {
            super.deliver(OUTPUT_PORT_NAME_WITHIN_PERIOD, execution);
        }
    }

    protected String getConfigurationPropertyIgnoreBeforeTimestamp() {
        return CONFIG_PROPERTY_NAME_IGNORE_BEFORE_TIMESTAMP;
    }

    protected String getConfigurationPropertyIgnoreAfterTimestamp() {
        return CONFIG_PROPERTY_NAME_IGNORE_AFTER_TIMESTAMP;
    }
}

