/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.traceAnalysis.filter.executionRecordTransformation;

import kieker.analysis.plugin.annotation.InputPort;
import kieker.analysis.plugin.annotation.OutputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.RepositoryPort;
import kieker.common.configuration.Configuration;
import kieker.common.record.controlflow.OperationExecutionRecord;
import kieker.common.util.ClassOperationSignaturePair;
import kieker.tools.traceAnalysis.filter.AbstractTraceAnalysisFilter;
import kieker.tools.traceAnalysis.systemModel.Execution;
import kieker.tools.traceAnalysis.systemModel.repository.SystemModelRepository;

@Plugin(description="A filter transforming OperationExecutionRecords into Execution objects", outputPorts={@OutputPort(name="transformedExecutions", description="Provides transformed executions", eventTypes={Execution.class})}, repositoryPorts={@RepositoryPort(name="systemModelRepository", repositoryType=SystemModelRepository.class)})
public class ExecutionRecordTransformationFilter
extends AbstractTraceAnalysisFilter {
    public static final String INPUT_PORT_NAME_RECORDS = "operationExecutionRecords";
    public static final String OUTPUT_PORT_NAME_EXECUTIONS = "transformedExecutions";

    public ExecutionRecordTransformationFilter(Configuration configuration) {
        super(configuration);
    }

    @InputPort(name="operationExecutionRecords", description="Receives operation execution records to be transformed", eventTypes={OperationExecutionRecord.class})
    public boolean inputOperationExecutionRecords(OperationExecutionRecord execRec) {
        ClassOperationSignaturePair fqComponentNameSignaturePair = ClassOperationSignaturePair.splitOperationSignatureStr(execRec.getOperationSignature());
        Execution execution = this.createExecutionByEntityNames(execRec.getHostname(), fqComponentNameSignaturePair.getFqClassname(), fqComponentNameSignaturePair.getSignature(), execRec.getTraceId(), execRec.getSessionId(), execRec.getEoi(), execRec.getEss(), execRec.getTin(), execRec.getTout(), false);
        super.deliver(OUTPUT_PORT_NAME_EXECUTIONS, execution);
        return true;
    }

    public Configuration getCurrentConfiguration() {
        Configuration configuration = new Configuration();
        return configuration;
    }
}

