/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.traceAnalysis.filter.traceWriter;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import kieker.analysis.plugin.annotation.InputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.Property;
import kieker.analysis.plugin.annotation.RepositoryPort;
import kieker.analysis.plugin.filter.AbstractFilterPlugin;
import kieker.common.configuration.Configuration;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.tools.traceAnalysis.filter.AbstractInvalidExecutionTraceProcessingFilter;
import kieker.tools.traceAnalysis.systemModel.InvalidExecutionTrace;
import kieker.tools.traceAnalysis.systemModel.repository.SystemModelRepository;

@Plugin(description="A filter allowing to write the incoming InvalidExecutionTraces into a configured file", repositoryPorts={@RepositoryPort(name="systemModelRepository", repositoryType=SystemModelRepository.class)}, configuration={@Property(name="outputFn", defaultValue="invalidTraceArtifacts-yyyyMMdd-HHmmssSSS.txt")})
public class InvalidExecutionTraceWriterFilter
extends AbstractInvalidExecutionTraceProcessingFilter {
    public static final String INPUT_PORT_NAME_INVALID_EXECUTION_TRACES = "invalidExecutionTraces";
    public static final String CONFIG_PROPERTY_NAME_OUTPUT_FN = "outputFn";
    private static final Log LOG = LogFactory.getLog(InvalidExecutionTraceWriterFilter.class);
    private static final String ENCODING = "UTF-8";
    private final String outputFn;
    private final BufferedWriter ps;

    public InvalidExecutionTraceWriterFilter(Configuration configuration) throws IOException {
        super(configuration);
        this.outputFn = configuration.getStringProperty(CONFIG_PROPERTY_NAME_OUTPUT_FN);
        this.ps = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.outputFn), ENCODING));
    }

    public void printStatusMessage() {
        super.printStatusMessage();
        int numTraces = this.getSuccessCount();
        this.stdOutPrintln("Wrote " + numTraces + " execution trace artifact" + (numTraces > 1 ? "s" : "") + " to file '" + this.outputFn + "'");
    }

    public void terminate(boolean error) {
        if (this.ps != null) {
            try {
                this.ps.close();
            }
            catch (IOException ex) {
                LOG.error("IOException while terminating", ex);
            }
        }
    }

    public String getInvalidExecutionTraceInputPortName() {
        return INPUT_PORT_NAME_INVALID_EXECUTION_TRACES;
    }

    @InputPort(name="invalidExecutionTraces", description="Receives the invalid execution traces to be written", eventTypes={InvalidExecutionTrace.class})
    public void newInvalidExecutionTrace(InvalidExecutionTrace et) {
        try {
            this.ps.append(et.getInvalidExecutionTraceArtifacts().toString()).append(AbstractFilterPlugin.SYSTEM_NEWLINE_STRING);
            this.reportSuccess(et.getInvalidExecutionTraceArtifacts().getTraceId());
        }
        catch (IOException ex) {
            this.reportError(et.getInvalidExecutionTraceArtifacts().getTraceId());
            LOG.error("IOException", ex);
        }
    }

    public Configuration getCurrentConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setProperty(CONFIG_PROPERTY_NAME_OUTPUT_FN, this.outputFn);
        return configuration;
    }
}

