/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.traceAnalysis.filter.visualization.callTree;

import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import kieker.analysis.plugin.annotation.InputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.Property;
import kieker.analysis.plugin.annotation.RepositoryPort;
import kieker.common.configuration.Configuration;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.tools.traceAnalysis.filter.AbstractMessageTraceProcessingFilter;
import kieker.tools.traceAnalysis.filter.traceReconstruction.TraceProcessingException;
import kieker.tools.traceAnalysis.filter.visualization.callTree.AbstractCallTreeFilter;
import kieker.tools.traceAnalysis.filter.visualization.callTree.TraceCallTreeNode;
import kieker.tools.traceAnalysis.filter.visualization.graph.IOriginRetentionPolicy;
import kieker.tools.traceAnalysis.filter.visualization.graph.NoOriginRetentionPolicy;
import kieker.tools.traceAnalysis.systemModel.AllocationComponent;
import kieker.tools.traceAnalysis.systemModel.MessageTrace;
import kieker.tools.traceAnalysis.systemModel.Operation;
import kieker.tools.traceAnalysis.systemModel.SynchronousCallMessage;
import kieker.tools.traceAnalysis.systemModel.repository.AllocationComponentOperationPairFactory;
import kieker.tools.traceAnalysis.systemModel.repository.SystemModelRepository;
import kieker.tools.traceAnalysis.systemModel.util.AllocationComponentOperationPair;

@Plugin(description="A filter allowing to write the incoming data into a calling tree", repositoryPorts={@RepositoryPort(name="systemModelRepository", repositoryType=SystemModelRepository.class)}, configuration={@Property(name="shortLabels", defaultValue="true"), @Property(name="dotOutputFn", defaultValue="traceCalltree.dot")})
public class TraceCallTreeFilter
extends AbstractMessageTraceProcessingFilter {
    public static final String CONFIG_PROPERTY_NAME_OUTPUT_FILENAME = "dotOutputFn";
    public static final String CONFIG_PROPERTY_NAME_SHORT_LABELS = "shortLabels";
    public static final String CONFIG_PROPERTY_VALUE_OUTPUT_FILENAME_DEFAULT = "traceCalltree.dot";
    public static final String CONFIG_PROPERTY_VALUE_SHORT_LABELS_DEFAULT = "true";
    private static final Log LOG = LogFactory.getLog(TraceCallTreeFilter.class);
    private final String dotOutputFn;
    private final boolean shortLabels;

    public TraceCallTreeFilter(Configuration configuration) {
        super(configuration);
        this.shortLabels = configuration.getBooleanProperty(CONFIG_PROPERTY_NAME_SHORT_LABELS);
        this.dotOutputFn = configuration.getStringProperty(CONFIG_PROPERTY_NAME_OUTPUT_FILENAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStatusMessage() {
        TraceCallTreeFilter traceCallTreeFilter = this;
        synchronized (traceCallTreeFilter) {
            super.printStatusMessage();
            int numPlots = this.getSuccessCount();
            long lastSuccessTracesId = this.getLastTraceIdSuccess();
            this.stdOutPrintln("Wrote " + numPlots + " call tree" + (numPlots > 1 ? "s" : "") + " to file" + (numPlots > 1 ? "s" : "") + " with name pattern '" + this.dotOutputFn + "-<traceId>.dot'");
            this.stdOutPrintln("Dot files can be converted using the dot tool");
            this.stdOutPrintln("Example: dot -T svg " + this.dotOutputFn + "-" + (numPlots > 0 ? Long.valueOf(lastSuccessTracesId) : "<traceId>") + ".dot > " + this.dotOutputFn + "-" + (numPlots > 0 ? Long.valueOf(lastSuccessTracesId) : "<traceId>") + ".svg");
        }
    }

    public Configuration getCurrentConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setProperty(CONFIG_PROPERTY_NAME_SHORT_LABELS, Boolean.toString(this.shortLabels));
        configuration.setProperty(CONFIG_PROPERTY_NAME_OUTPUT_FILENAME, this.dotOutputFn);
        return configuration;
    }

    @InputPort(name="messageTraces", description="Receives the message traces to be processed", eventTypes={MessageTrace.class})
    public void inputMessageTraces(MessageTrace mt) {
        try {
            TraceCallTreeNode rootNode = new TraceCallTreeNode(0, AllocationComponentOperationPairFactory.ROOT_PAIR, true, mt, (IOriginRetentionPolicy)NoOriginRetentionPolicy.createInstance());
            AbstractCallTreeFilter.writeDotForMessageTrace(rootNode, new AbstractCallTreeFilter.IPairFactory(){

                public Object createPair(SynchronousCallMessage callMsg) {
                    AllocationComponent allocationComponent = callMsg.getReceivingExecution().getAllocationComponent();
                    Operation op = callMsg.getReceivingExecution().getOperation();
                    AllocationComponentOperationPair destination = TraceCallTreeFilter.this.getSystemEntityFactory().getAllocationPairFactory().getPairInstanceByPair(allocationComponent, op);
                    return destination;
                }
            }, mt, this.dotOutputFn + "-" + mt.getTraceId() + ".dot", false, this.shortLabels);
            this.reportSuccess(mt.getTraceId());
        }
        catch (TraceProcessingException ex) {
            this.reportError(mt.getTraceId());
            LOG.error("TraceProcessingException", ex);
        }
        catch (FileNotFoundException ex) {
            this.reportError(mt.getTraceId());
            LOG.error("File not found", ex);
        }
        catch (UnsupportedEncodingException ex) {
            this.reportError(mt.getTraceId());
            LOG.error("Encoding not supported", ex);
        }
    }
}

