/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.traceAnalysis.systemModel.repository;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import kieker.tools.traceAnalysis.systemModel.AssemblyComponent;
import kieker.tools.traceAnalysis.systemModel.Operation;
import kieker.tools.traceAnalysis.systemModel.repository.AbstractSystemSubRepository;
import kieker.tools.traceAnalysis.systemModel.repository.AssemblyRepository;
import kieker.tools.traceAnalysis.systemModel.repository.OperationRepository;
import kieker.tools.traceAnalysis.systemModel.repository.SystemModelRepository;
import kieker.tools.traceAnalysis.systemModel.util.AssemblyComponentOperationPair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssemblyComponentOperationPairFactory
extends AbstractSystemSubRepository {
    public static final AssemblyComponentOperationPair ROOT_PAIR = new AssemblyComponentOperationPair(0, OperationRepository.ROOT_OPERATION, AssemblyRepository.ROOT_ASSEMBLY_COMPONENT);
    private final Map<String, AssemblyComponentOperationPair> pairsByName = new Hashtable<String, AssemblyComponentOperationPair>();
    private final Map<Integer, AssemblyComponentOperationPair> pairsById = new Hashtable<Integer, AssemblyComponentOperationPair>();

    public AssemblyComponentOperationPairFactory(SystemModelRepository systemFactory) {
        super(systemFactory);
    }

    public final AssemblyComponentOperationPair getPairInstanceByPair(AssemblyComponent assemblyComponent, Operation operation) {
        AssemblyComponentOperationPair inst = this.getPairByNamedIdentifier(assemblyComponent.getId() + "-" + operation.getId());
        if (inst == null) {
            return this.createAndRegisterPair(operation, assemblyComponent);
        }
        return inst;
    }

    private AssemblyComponentOperationPair createAndRegisterPair(Operation operation, AssemblyComponent assemblyComponent) {
        return this.createAndRegisterPair(assemblyComponent.getId() + "-" + operation.getId(), operation, assemblyComponent);
    }

    private AssemblyComponentOperationPair getPairByNamedIdentifier(String namedIdentifier) {
        return this.pairsByName.get(namedIdentifier);
    }

    public final AssemblyComponentOperationPair getPairById(int id) {
        return this.pairsById.get(id);
    }

    private AssemblyComponentOperationPair createAndRegisterPair(String namedIdentifier, Operation operation, AssemblyComponent assemblyComponent) {
        if (this.pairsByName.containsKey(namedIdentifier)) {
            throw new IllegalArgumentException("Element with name " + namedIdentifier + "exists already");
        }
        int id = this.getAndIncrementNextId();
        AssemblyComponentOperationPair newInst = new AssemblyComponentOperationPair(id, operation, assemblyComponent);
        this.pairsById.put(id, newInst);
        this.pairsByName.put(namedIdentifier, newInst);
        return newInst;
    }

    public final Collection<AssemblyComponentOperationPair> getPairs() {
        return this.pairsById.values();
    }

    public AssemblyComponentOperationPair getRootPair() {
        return ROOT_PAIR;
    }
}

